/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.modisco.infra.browser.core.ModelElementItemEx;
import org.eclipse.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.modisco.infra.browser.queries.SelectedQuery;
import org.eclipse.modisco.infra.browser.uicore.internal.AppearanceConfiguration;
import org.eclipse.modisco.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.modisco.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.modisco.infra.browser.uicore.internal.util.ImageProvider;
import org.eclipse.modisco.infra.browser.uicore.internal.util.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class QueryItem
implements ITreeElement {
    private final EObject parent;
    private final ITreeElement treeParent;
    private final SelectedQuery query;
    private final BrowserConfiguration browserConfiguration;
    private List<?> cachedChildren = null;
    private int cachedChildrenModCount = -1;

    public QueryItem(EObject parent, ITreeElement treeParent, SelectedQuery query, BrowserConfiguration browserConfiguration) {
        this.parent = parent;
        this.treeParent = treeParent;
        this.query = query;
        this.browserConfiguration = browserConfiguration;
    }

    public String getText() {
        String text;
        if (!this.query.isExecuted()) {
            return String.valueOf(this.query.getModelQuery().getName()) + " (?)";
        }
        Object queryResult = this.query.getResult();
        if (queryResult instanceof Collection) {
            Collection elements = (Collection)queryResult;
            return String.valueOf(this.query.getModelQuery().getName()) + " (" + elements.size() + ")";
        }
        if (queryResult instanceof EObject) {
            EObject eObject = (EObject)queryResult;
            text = ModelElementItem.getDisplayName((EObject)eObject, (AppearanceConfiguration)this.browserConfiguration.getAppearanceConfiguration());
        } else {
            text = queryResult == null ? "null" : queryResult.toString();
        }
        return String.valueOf(this.query.getModelQuery().getName()) + " = " + text;
    }

    public Image getImage() {
        return ImageProvider.getInstance().getQueryIcon();
    }

    public Object getParent() {
        return this.parent;
    }

    public ITreeElement getTreeParent() {
        return this.treeParent;
    }

    public List<?> getChildren() {
        if (this.cachedChildrenModCount != this.browserConfiguration.getAppearanceConfiguration().getModCount()) {
            Object queryResult = this.query.getResult();
            if (queryResult == null) {
                this.cachedChildren = Collections.emptyList();
            } else if (queryResult instanceof EObject) {
                EObject element = (EObject)queryResult;
                this.cachedChildren = Collections.singletonList(new ModelElementItemEx(element, this, this.browserConfiguration));
            } else if (queryResult instanceof Collection) {
                Collection elements = (Collection)queryResult;
                ArrayList<ModelElementItemEx> children = new ArrayList<ModelElementItemEx>();
                for (Object element : elements) {
                    if (element instanceof EObject) {
                        EObject eObject = (EObject)element;
                        children.add(new ModelElementItemEx(eObject, this, this.browserConfiguration));
                        continue;
                    }
                    children.add((ModelElementItemEx)((Object)element));
                }
                this.cachedChildren = Collections.unmodifiableList(children);
            } else {
                this.cachedChildren = Collections.singletonList(queryResult);
            }
            this.cachedChildrenModCount = this.browserConfiguration.getAppearanceConfiguration().getModCount();
        }
        return this.cachedChildren;
    }

    public boolean hasChildren() {
        if (!this.query.isExecuted()) {
            return true;
        }
        return this.getChildren().size() > 0;
    }

    public Font getFont() {
        return null;
    }

    public Color getForeground() {
        return null;
    }

    public Color getBackground() {
        return null;
    }

    public SelectedQuery getQuery() {
        return this.query;
    }

    public boolean equals(Object obj) {
        if (obj instanceof QueryItem) {
            QueryItem other = (QueryItem)obj;
            return Util.safeEquals((Object)this.query, (Object)other.query) && this.parent.equals(other.parent);
        }
        return false;
    }

    public int hashCode() {
        int hashPrime1 = 47;
        int hashPrime2 = 13;
        int parentHashCode = this.parent.hashCode() + 13;
        if (this.query != null) {
            return this.query.hashCode() * 47 + parentHashCode;
        }
        return parentHashCode;
    }
}

