/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.text.completion;

import org.eclipse.dltk.core.CompletionProposal;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.completion.ICompletionProposalInfo;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposalExtension2;
import org.eclipse.dltk.ui.text.completion.LinkedModeScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.MethodProposalInfo;
import org.eclipse.dltk.ui.text.completion.ProposalContextInformation;
import org.eclipse.dltk.ui.text.completion.ReplacementBuffer;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;

public class ScriptMethodCompletionProposal
extends LinkedModeScriptCompletionProposal
implements IScriptCompletionProposalExtension2 {
    protected static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '\t', '['};
    protected static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '-', ' '};
    protected static final char[] METHOD_NAME_TRIGGERS = new char[]{';'};
    private boolean fHasParameters;
    private boolean fHasParametersComputed = false;
    private int fContextInformationPosition;

    public ScriptMethodCompletionProposal(CompletionProposal proposal, ScriptContentAssistInvocationContext context) {
        super(proposal, context);
    }

    @Override
    public String getName() {
        return this.fProposal.getName();
    }

    @Override
    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        if (this.hasArgumentList()) {
            String completion = String.valueOf(this.fProposal.getName());
            if (this.isCamelCaseMatching()) {
                String prefix = this.getPrefix(document, completionOffset);
                return this.getCamelCaseCompound(prefix, completion);
            }
            return completion;
        }
        return super.getPrefixCompletionText(document, completionOffset);
    }

    @Override
    protected IContextInformation computeContextInformation() {
        if (this.fProposal.getKind() == 5 && this.hasParameters() && (this.getReplacementString().endsWith(")") || this.getReplacementString().length() == 0)) {
            ProposalContextInformation contextInformation = new ProposalContextInformation(this.fProposal);
            if (this.fContextInformationPosition != 0 && this.fProposal.getCompletion().length() == 0) {
                contextInformation.setContextInformationPosition(this.fContextInformationPosition);
            }
            return contextInformation;
        }
        return super.computeContextInformation();
    }

    @Override
    protected char[] computeTriggerCharacters() {
        if (this.fProposal.getKind() == 10) {
            return METHOD_NAME_TRIGGERS;
        }
        if (this.hasParameters()) {
            return METHOD_WITH_ARGUMENTS_TRIGGERS;
        }
        return METHOD_TRIGGERS;
    }

    protected final boolean hasParameters() {
        if (!this.fHasParametersComputed) {
            this.fHasParametersComputed = true;
            String[] findParameterNames = this.fProposal.findParameterNames(null);
            this.fHasParameters = findParameterNames != null && findParameterNames.length > 0;
        }
        return this.fHasParameters;
    }

    protected boolean hasArgumentList() {
        if (10 == this.fProposal.getKind()) {
            return false;
        }
        IPreferenceStore preferenceStore = DLTKUIPlugin.getDefault().getPreferenceStore();
        boolean noOverwrite = preferenceStore.getBoolean("content_assist_insert_completion") ^ this.isToggleEating();
        String completion = this.fProposal.getCompletion();
        return !this.isInDoc() && completion.length() > 0 && (noOverwrite || completion.charAt(completion.length() - 1) == ')');
    }

    @Override
    protected char getOpenTrigger() {
        return '(';
    }

    @Override
    protected char getExitTrigger() {
        return ')';
    }

    @Override
    protected void computeReplacement(ReplacementBuffer buffer) {
        if (!this.hasArgumentList()) {
            buffer.append(this.fProposal.getCompletion());
            return;
        }
        buffer.append(this.fProposal.getName());
        buffer.append("(");
        if (this.hasParameters()) {
            this.setCursorPosition(buffer.length());
            Integer paramLimit = (Integer)this.fProposal.getAttribute("org.eclipse.dltk.uiCompletionProposal#ParameterLimit");
            String[] parameterNames = this.fProposal.findParameterNames(null);
            int i = 0;
            while (i < parameterNames.length) {
                if (paramLimit != null && i >= paramLimit) break;
                if (i != 0) {
                    buffer.append(",");
                }
                buffer.addArgument(parameterNames[i]);
                ++i;
            }
        }
        buffer.append(")");
    }

    @Override
    protected ICompletionProposalInfo computeProposalInfo() {
        IScriptProject project = this.fInvocationContext.getProject();
        if (project != null) {
            return new MethodProposalInfo(project, this.fProposal);
        }
        return super.computeProposalInfo();
    }

    public void setContextInformationPosition(int contextInformationPosition) {
        this.fContextInformationPosition = contextInformationPosition;
    }

    @Override
    protected boolean isValidPrefix(String prefix) {
        if (super.isValidPrefix(prefix)) {
            return true;
        }
        String word = this.getDisplayString();
        if (this.isInDoc()) {
            int idx = word.indexOf("{@link ");
            if (idx == 0) {
                word = word.substring(7);
            } else {
                idx = word.indexOf("{@value ");
                if (idx == 0) {
                    word = word.substring(8);
                }
            }
        }
        return this.isPrefix(prefix, word);
    }
}

