import { TextDocument } from 'vscode-languageserver-textdocument';
import * as vscode from 'vscode-languageserver';
import type * as ts from 'typescript/lib/tsserverlibrary';
import { RuntimeEnvironment } from '../types';
interface IncrementalScriptSnapshotChange {
    applied: boolean;
    changeRange: ts.TextChangeRange | undefined;
    version: number;
    contentChange: {
        range: vscode.Range;
        text: string;
    } | undefined;
    snapshot: WeakRef<ts.IScriptSnapshot> | undefined;
}
declare class IncrementalScriptSnapshot {
    private document;
    uri: string;
    changes: IncrementalScriptSnapshotChange[];
    constructor(uri: string, languageId: string, version: number, text: string);
    get version(): number;
    get languageId(): string;
    update(params: vscode.DidChangeTextDocumentParams): void;
    getSnapshot(): ts.IScriptSnapshot;
    getDocument(): TextDocument;
    clearUnReferenceVersions(): void;
    applyVersionChanges(version: number, removeBeforeVersions: boolean): void;
}
export declare function combineContinuousChangeRanges(...changeRanges: ts.TextChangeRange[]): ts.TextChangeRange;
export declare function createDocuments(env: RuntimeEnvironment, connection: vscode.Connection): {
    data: {
        clear: () => void;
        values: () => IterableIterator<IncrementalScriptSnapshot>;
        uriDelete: (_uri: string) => boolean;
        uriGet: (_uri: string) => IncrementalScriptSnapshot | undefined;
        uriHas: (_uri: string) => boolean;
        uriSet: (_uri: string, item: IncrementalScriptSnapshot) => void;
        pathDelete: (path: string) => boolean;
        pathGet: (path: string) => IncrementalScriptSnapshot | undefined;
        pathHas: (path: string) => IncrementalScriptSnapshot | undefined;
        pathSet: (path: string, item: IncrementalScriptSnapshot) => void;
    };
    onDidChangeContent: (cb: (params: vscode.DidChangeTextDocumentParams) => void) => vscode.Disposable;
    onDidClose: (cb: (params: vscode.DidCloseTextDocumentParams) => void) => vscode.Disposable;
};
export {};
