/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioningListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.Reconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.genericeditor.AutoEditStrategyRegistry;
import org.eclipse.ui.internal.genericeditor.CompositeQuickAssistProcessor;
import org.eclipse.ui.internal.genericeditor.CompositeReconciler;
import org.eclipse.ui.internal.genericeditor.CompositeReconcilerStrategy;
import org.eclipse.ui.internal.genericeditor.ContentAssistProcessorRegistry;
import org.eclipse.ui.internal.genericeditor.ContentTypeRelatedExtensionTracker;
import org.eclipse.ui.internal.genericeditor.DefaultWordHighlightReconciler;
import org.eclipse.ui.internal.genericeditor.GenericEditorContentAssistant;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.internal.genericeditor.PresentationReconcilerRegistry;
import org.eclipse.ui.internal.genericeditor.ReconcilerRegistry;
import org.eclipse.ui.internal.genericeditor.TextDoubleClickStrategyRegistry;
import org.eclipse.ui.internal.genericeditor.folding.DefaultFoldingReconciler;
import org.eclipse.ui.internal.genericeditor.hover.CompositeInformationControlCreator;
import org.eclipse.ui.internal.genericeditor.hover.CompositeTextHover;
import org.eclipse.ui.internal.genericeditor.markers.MarkerResoltionQuickAssistProcessor;
import org.eclipse.ui.texteditor.ITextEditor;

public final class ExtensionBasedTextViewerConfiguration
extends TextSourceViewerConfiguration
implements IDocumentPartitioningListener {
    private ITextEditor editor;
    private Set<IContentType> resolvedContentTypes;
    private Set<IContentType> fallbackContentTypes = Set.of();
    private IDocument document;
    private GenericEditorContentAssistant contentAssistant;

    public ExtensionBasedTextViewerConfiguration(ITextEditor editor, IPreferenceStore preferenceStore) {
        super(preferenceStore);
        this.editor = editor;
    }

    public Set<IContentType> getContentTypes(IDocument document) {
        String fileName;
        if (this.resolvedContentTypes != null) {
            return this.resolvedContentTypes;
        }
        this.resolvedContentTypes = new LinkedHashSet<IContentType>();
        ITextFileBuffer buffer = ExtensionBasedTextViewerConfiguration.getCurrentBuffer(document);
        if (buffer != null) {
            try {
                IContentType contentType = buffer.getContentType();
                if (contentType != null) {
                    this.resolvedContentTypes.add(contentType);
                }
            }
            catch (CoreException ex) {
                GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.ui.genericeditor", ex.getMessage(), (Throwable)ex));
            }
        }
        if ((fileName = this.getCurrentFileName(document)) != null) {
            LinkedList<IContentType> types = new LinkedList<IContentType>(Arrays.asList(Platform.getContentTypeManager().findContentTypesFor(fileName)));
            while (!types.isEmpty()) {
                IContentType type = (IContentType)types.poll();
                this.resolvedContentTypes.add(type);
                IContentType parent = type.getBaseType();
                if (parent == null) continue;
                types.add(parent);
            }
        }
        return this.resolvedContentTypes.isEmpty() ? this.fallbackContentTypes : this.resolvedContentTypes;
    }

    private static ITextFileBuffer getCurrentBuffer(IDocument document) {
        if (document != null) {
            return FileBuffers.getTextFileBufferManager().getTextFileBuffer(document);
        }
        return null;
    }

    private String getCurrentFileName(IDocument document) {
        IPath path;
        ITextFileBuffer buffer;
        String fileName = null;
        if (this.editor != null) {
            fileName = this.editor.getEditorInput().getName();
        }
        if (fileName == null && (buffer = ExtensionBasedTextViewerConfiguration.getCurrentBuffer(document)) != null && (path = buffer.getLocation()) != null) {
            fileName = path.lastSegment();
        }
        return fileName;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        List<ITextHover> hovers = GenericEditorPlugin.getDefault().getHoverRegistry().getAvailableHovers(sourceViewer, this.editor, this.getContentTypes(sourceViewer.getDocument()));
        if (hovers == null || hovers.isEmpty()) {
            return null;
        }
        if (hovers.size() == 1) {
            return hovers.get(0);
        }
        return new CompositeTextHover(hovers);
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistProcessorRegistry registry = GenericEditorPlugin.getDefault().getContentAssistProcessorRegistry();
        ContentTypeRelatedExtensionTracker<IContentAssistProcessor> contentAssistProcessorTracker = new ContentTypeRelatedExtensionTracker<IContentAssistProcessor>(GenericEditorPlugin.getDefault().getBundle().getBundleContext(), IContentAssistProcessor.class, sourceViewer.getTextWidget().getDisplay());
        Set<IContentType> types = this.getContentTypes(sourceViewer.getDocument());
        this.contentAssistant = new GenericEditorContentAssistant(contentAssistProcessorTracker, registry.getContentAssistProcessors(sourceViewer, this.editor, types), types, this.fPreferenceStore);
        if (this.document != null) {
            this.associateTokenContentTypes(this.document);
        }
        this.watchDocument(sourceViewer.getDocument());
        return this.contentAssistant;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconcilerRegistry registry = GenericEditorPlugin.getDefault().getPresentationReconcilerRegistry();
        List<IPresentationReconciler> reconciliers = registry.getPresentationReconcilers(sourceViewer, this.editor, this.getContentTypes(sourceViewer.getDocument()));
        if (!reconciliers.isEmpty()) {
            return reconciliers.get(0);
        }
        return super.getPresentationReconciler(sourceViewer);
    }

    void watchDocument(IDocument document) {
        if (this.document == document) {
            return;
        }
        if (this.document != null) {
            this.document.removeDocumentPartitioningListener((IDocumentPartitioningListener)this);
        }
        if (document != null) {
            this.document = document;
            this.associateTokenContentTypes(document);
            document.addDocumentPartitioningListener((IDocumentPartitioningListener)this);
        }
    }

    public void documentPartitioningChanged(IDocument document) {
        this.associateTokenContentTypes(document);
    }

    private void associateTokenContentTypes(IDocument document) {
        if (this.contentAssistant == null) {
            return;
        }
        this.contentAssistant.updateTokens(document);
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant quickAssistAssistant = new QuickAssistAssistant();
        ArrayList<IQuickAssistProcessor> quickAssistProcessors = new ArrayList<IQuickAssistProcessor>();
        quickAssistProcessors.add(new MarkerResoltionQuickAssistProcessor());
        quickAssistProcessors.addAll(GenericEditorPlugin.getDefault().getQuickAssistProcessorRegistry().getQuickAssistProcessors(sourceViewer, this.editor, this.getContentTypes(sourceViewer.getDocument())));
        CompositeQuickAssistProcessor compQuickAssistProcessor = new CompositeQuickAssistProcessor(quickAssistProcessors);
        quickAssistAssistant.setQuickAssistProcessor((IQuickAssistProcessor)compQuickAssistProcessor);
        quickAssistAssistant.setRestoreCompletionProposalSize(EditorsPlugin.getDefault().getDialogSettingsSection("quick_assist_proposal_size"));
        quickAssistAssistant.setInformationControlCreator(parent -> new DefaultInformationControl(parent, EditorsPlugin.getAdditionalInfoAffordanceString()));
        return quickAssistAssistant;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        ReconcilerRegistry registry = GenericEditorPlugin.getDefault().getReconcilerRegistry();
        ArrayList<IReconcilingStrategy> reconcilingStrategies = new ArrayList<IReconcilingStrategy>();
        List<IReconciler> reconcilers = registry.getReconcilers(sourceViewer, this.editor, reconcilingStrategies, this.getContentTypes(sourceViewer.getDocument()));
        ArrayList<IReconcilingStrategy> highlightReconcilingStrategies = new ArrayList<IReconcilingStrategy>();
        List<IReconciler> highlightReconcilers = registry.getHighlightReconcilers(sourceViewer, this.editor, highlightReconcilingStrategies, this.getContentTypes(sourceViewer.getDocument()));
        if (!highlightReconcilers.isEmpty()) {
            reconcilers.addAll(highlightReconcilers);
        } else if (highlightReconcilingStrategies.isEmpty()) {
            reconcilers.add((IReconciler)new DefaultWordHighlightReconciler());
        }
        reconcilingStrategies.addAll(highlightReconcilingStrategies);
        ArrayList<IReconcilingStrategy> foldingReconcilingStrategies = new ArrayList<IReconcilingStrategy>();
        List<IReconciler> foldingReconcilers = registry.getFoldingReconcilers(sourceViewer, this.editor, foldingReconcilingStrategies, this.getContentTypes(sourceViewer.getDocument()));
        if (!foldingReconcilers.isEmpty()) {
            reconcilers.addAll(foldingReconcilers);
        }
        reconcilers.add((IReconciler)new DefaultFoldingReconciler());
        reconcilingStrategies.addAll(foldingReconcilingStrategies);
        if (!reconcilingStrategies.isEmpty()) {
            Reconciler reconciler = new Reconciler();
            reconciler.setReconcilingStrategy((IReconcilingStrategy)new CompositeReconcilerStrategy(reconcilingStrategies), "__dftl_partition_content_type");
            reconcilers.add(0, (IReconciler)reconciler);
        }
        if (!reconcilers.isEmpty()) {
            return new CompositeReconciler(reconcilers);
        }
        return null;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        AutoEditStrategyRegistry registry = GenericEditorPlugin.getDefault().getAutoEditStrategyRegistry();
        List<IAutoEditStrategy> editStrategies = registry.getAutoEditStrategies(sourceViewer, this.editor, this.getContentTypes(sourceViewer.getDocument()));
        if (!editStrategies.isEmpty()) {
            return editStrategies.toArray(new IAutoEditStrategy[editStrategies.size()]);
        }
        return super.getAutoEditStrategies(sourceViewer, contentType);
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.ui.genericeditor.GenericEditor", this.editor);
        return targets;
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        List<ITextHover> hovers = GenericEditorPlugin.getDefault().getHoverRegistry().getAvailableHovers(sourceViewer, this.editor, this.getContentTypes(sourceViewer.getDocument()));
        InformationPresenter presenter = new InformationPresenter((IInformationControlCreator)new CompositeInformationControlCreator(hovers));
        presenter.takesFocusWhenVisible(false);
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        ExtensionBaseInformationProvider provider = new ExtensionBaseInformationProvider(hovers);
        if (hovers != null && !hovers.isEmpty()) {
            String[] stringArray = this.getConfiguredContentTypes(sourceViewer);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                presenter.setInformationProvider((IInformationProvider)provider, contentType);
                ++n2;
            }
        }
        presenter.setSizeConstraints(100, 12, false, true);
        return presenter;
    }

    public void setFallbackContentTypes(Set<IContentType> contentTypes) {
        this.fallbackContentTypes = contentTypes == null ? Set.of() : contentTypes;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        TextDoubleClickStrategyRegistry registry = GenericEditorPlugin.getDefault().getTextDoubleClickStrategyRegistry();
        Optional<ITextDoubleClickStrategy> doubleClickStrategies = registry.getTextDoubleClickStrategy(sourceViewer, this.editor, this.getContentTypes(sourceViewer.getDocument()));
        if (!doubleClickStrategies.isEmpty()) {
            return doubleClickStrategies.get();
        }
        return super.getDoubleClickStrategy(sourceViewer, contentType);
    }

    class ExtensionBaseInformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        List<ITextHover> fHovers;
        private LinkedHashMap<ITextHover, Object> currentHovers;

        ExtensionBaseInformationProvider(List<ITextHover> hovers) {
            this.fHovers = hovers;
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            this.currentHovers = new LinkedHashMap();
            for (ITextHover hover : this.fHovers) {
                Object res;
                Object object = res = hover instanceof ITextHoverExtension2 ? ((ITextHoverExtension2)hover).getHoverInfo2(textViewer, subject) : hover.getHoverInfo(textViewer, subject);
                if (res == null) continue;
                this.currentHovers.put(hover, res);
            }
            if (this.currentHovers.isEmpty()) {
                return null;
            }
            if (this.currentHovers.size() == 1) {
                return this.currentHovers.values().iterator().next();
            }
            return this.currentHovers;
        }

        public IRegion getSubject(ITextViewer textViewer, int offset) {
            IRegion res = null;
            for (ITextHover hover : this.fHovers) {
                IRegion region = hover.getHoverRegion(textViewer, offset);
                if (region == null) continue;
                if (res == null) {
                    res = region;
                    continue;
                }
                int startOffset = Math.max(res.getOffset(), region.getOffset());
                int endOffset = Math.min(res.getOffset() + res.getLength(), region.getOffset() + region.getLength());
                res = new Region(startOffset, endOffset - startOffset);
            }
            return res;
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.fHovers.stream().map(hover -> hover.getHoverInfo(textViewer, subject)).filter(Objects::nonNull).collect(Collectors.joining("\n"));
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            if (this.currentHovers == null || this.currentHovers.isEmpty()) {
                return null;
            }
            if (this.currentHovers.size() == 1) {
                ITextHover hover = this.currentHovers.keySet().iterator().next();
                return hover instanceof ITextHoverExtension ? ((ITextHoverExtension)hover).getHoverControlCreator() : new AbstractReusableInformationControlCreator(){

                    protected IInformationControl doCreateInformationControl(Shell parent) {
                        return new DefaultInformationControl(parent);
                    }
                };
            }
            return new CompositeInformationControlCreator(new ArrayList<ITextHover>(this.currentHovers.keySet()));
        }
    }
}

