/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.markers;

import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.SchemaFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.xml.XmlUtils;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.internal.tmf.core.markers.Marker;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSegment;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSet;
import org.eclipse.tracecompass.internal.tmf.core.markers.SubMarker;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class MarkerConfigXmlParser {
    private static final URL DEFAULT_MARKER_CONFIG_URL = MarkerConfigXmlParser.class.getResource("/templates/markers.xml");
    public static final IPath MARKER_CONFIG_PATH = Activator.getDefault().getStateLocation().addTrailingSeparator().append("markers.xml");
    private static final File MARKER_CONFIG_FILE = MARKER_CONFIG_PATH.toFile();
    private static final URL MARKER_CONFIG_SCHEMA_URL = MarkerConfigXmlParser.class.getResource("/schema/markers.xsd");
    private static final IPath MARKER_CONFIG_SCHEMA_PATH = Activator.getDefault().getStateLocation().addTrailingSeparator().append("markers.xsd");
    private static final File MARKER_CONFIG_SCHEMA_FILE = MARKER_CONFIG_SCHEMA_PATH.toFile();
    private static final String DEFAULT_LABEL = "%d";
    private static final @NonNull String ELLIPSIS = "..";
    private static final @NonNull String TMF_CUSTOM_MARKERS_BUILTIN_EXTENSION_ID = "org.eclipse.tracecompass.tmf.core.custom.marker";
    private static final @NonNull String ELEMENT_NAME_CUSTOM_MARKERS = "customMarker";
    private static final @NonNull String ATTRIBUTE_NAME_FILE = "file";

    private MarkerConfigXmlParser() {
    }

    public static @NonNull List<MarkerSet> getMarkerSets() {
        LinkedHashMap<String, MarkerSet> markerSets = new LinkedHashMap<String, MarkerSet>();
        for (String extensionBookmark : MarkerConfigXmlParser.getExtensionDefinitionsPaths()) {
            for (MarkerSet markerSet : MarkerConfigXmlParser.parse(extensionBookmark)) {
                markerSets.put(markerSet.getId(), markerSet);
            }
        }
        if (MARKER_CONFIG_FILE.exists()) {
            for (MarkerSet markerSet : MarkerConfigXmlParser.parse(MARKER_CONFIG_FILE.getAbsolutePath())) {
                markerSets.put(markerSet.getId(), markerSet);
            }
        }
        return new ArrayList<MarkerSet>(markerSets.values());
    }

    public static void initMarkerSets() {
        if (!MARKER_CONFIG_FILE.exists()) {
            try {
                File defaultConfigFile = new File(FileLocator.toFileURL((URL)DEFAULT_MARKER_CONFIG_URL).toURI());
                Files.copy(defaultConfigFile.toPath(), MARKER_CONFIG_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException | URISyntaxException e) {
                Activator.logError("Error copying " + DEFAULT_MARKER_CONFIG_URL + " to " + MARKER_CONFIG_FILE.getAbsolutePath(), e);
            }
        }
        if (!MARKER_CONFIG_SCHEMA_FILE.exists()) {
            try {
                File schemaFile = new File(FileLocator.toFileURL((URL)MARKER_CONFIG_SCHEMA_URL).toURI());
                Files.copy(schemaFile.toPath(), MARKER_CONFIG_SCHEMA_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException | URISyntaxException e) {
                Activator.logError("Error copying " + MARKER_CONFIG_SCHEMA_URL + " to " + MARKER_CONFIG_SCHEMA_FILE.getAbsolutePath(), e);
            }
        }
    }

    public static @NonNull List<MarkerSet> parse(String path) {
        ArrayList<MarkerSet> markerSets = new ArrayList<MarkerSet>();
        try {
            DocumentBuilderFactory dbf = XmlUtils.newSafeDocumentBuilderFactory();
            dbf.setValidating(false);
            dbf.setNamespaceAware(true);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            dbf.setSchema(schemaFactory.newSchema(MARKER_CONFIG_SCHEMA_URL));
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException saxparseexception) throws SAXException {
                    throw saxparseexception;
                }

                @Override
                public void warning(SAXParseException saxparseexception) throws SAXException {
                    throw saxparseexception;
                }

                @Override
                public void fatalError(SAXParseException saxparseexception) throws SAXException {
                    throw saxparseexception;
                }
            });
            File file = new File(path);
            if (!file.canRead()) {
                return markerSets;
            }
            Document doc = db.parse(file);
            Element root = doc.getDocumentElement();
            if (!root.getNodeName().equals("marker-sets")) {
                return markerSets;
            }
            NodeList markerSetsList = root.getElementsByTagName("marker-set");
            int i = 0;
            while (i < markerSetsList.getLength()) {
                try {
                    Element markerSetElem = (Element)markerSetsList.item(i);
                    String name = markerSetElem.getAttribute("name");
                    String id = markerSetElem.getAttribute("id");
                    MarkerSet markerSet = new MarkerSet(name, id);
                    List<Marker> markers = MarkerConfigXmlParser.getMarkers(markerSetElem);
                    for (Marker marker : markers) {
                        markerSet.addMarker(marker);
                    }
                    markerSets.add(markerSet);
                }
                catch (IllegalArgumentException e) {
                    Activator.logError("Error parsing " + path, e);
                }
                ++i;
            }
            return markerSets;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Activator.logError("Error parsing " + path, e);
            return markerSets;
        }
    }

    private static List<Marker> getMarkers(Element markerSet) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        NodeList markerList = markerSet.getElementsByTagName("marker");
        int i = 0;
        while (i < markerList.getLength()) {
            Element markerElem = (Element)markerList.item(i);
            String name = markerElem.getAttribute("name");
            String label = MarkerConfigXmlParser.parseLabel(markerElem.getAttribute("label"));
            String id = markerElem.getAttribute("id");
            String referenceId = markerElem.getAttribute("referenceid");
            String color = markerElem.getAttribute("color");
            double period = MarkerConfigXmlParser.parsePeriod(markerElem.getAttribute("period"));
            String unit = MarkerConfigXmlParser.parseUnit(markerElem.getAttribute("unit"));
            Range<Long> range = MarkerConfigXmlParser.parseRange(markerElem.getAttribute("range"));
            long offset = MarkerConfigXmlParser.parseOffset(markerElem.getAttribute("offset"));
            RangeSet<Long> indexRange = MarkerConfigXmlParser.parseRangeSet(markerElem.getAttribute("index"));
            Marker.PeriodicMarker marker = new Marker.PeriodicMarker(name, label, id, referenceId, color, period, unit, range, offset, indexRange);
            MarkerConfigXmlParser.parseSubMarkers(markerElem, marker);
            markers.add(marker);
            ++i;
        }
        return markers;
    }

    private static void parseSubMarkers(Element marker, Marker parent) {
        NodeList nodeList = marker.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                if (node.getNodeName().equals("submarker")) {
                    String rangeAttr;
                    Range<Long> range;
                    Element subMarkerElem = (Element)node;
                    name = subMarkerElem.getAttribute("name");
                    String label = MarkerConfigXmlParser.parseLabel(subMarkerElem.getAttribute("label"));
                    String id = subMarkerElem.getAttribute("id");
                    String color = subMarkerElem.getAttribute("color");
                    if (color.isEmpty()) {
                        color = parent.getColor();
                    }
                    if (!(range = MarkerConfigXmlParser.parseRange(rangeAttr = subMarkerElem.getAttribute("range"))).hasLowerBound() || !range.hasUpperBound()) {
                        throw new IllegalArgumentException("Unsupported unbound range: " + range);
                    }
                    RangeSet<Long> indexRange = MarkerConfigXmlParser.parseRangeSet(subMarkerElem.getAttribute("index"));
                    SubMarker.SplitMarker subMarker = new SubMarker.SplitMarker(name, label, id, color, range, indexRange);
                    parent.addSubMarker(subMarker);
                    MarkerConfigXmlParser.parseSubMarkers(subMarkerElem, subMarker);
                } else if (node.getNodeName().equals("segments")) {
                    Element segmentsElem = (Element)node;
                    name = segmentsElem.getAttribute("name");
                    SubMarker.WeightedMarker subMarker = new SubMarker.WeightedMarker(name);
                    parent.addSubMarker(subMarker);
                    MarkerConfigXmlParser.parseSegments(segmentsElem, subMarker);
                    MarkerConfigXmlParser.parseSubMarkers(segmentsElem, subMarker);
                }
            }
            ++i;
        }
    }

    private static void parseSegments(Element marker, SubMarker.WeightedMarker parent) {
        NodeList nodeList = marker.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && node.getNodeName().equals("segment")) {
                Element segmentElem = (Element)node;
                String label = MarkerConfigXmlParser.parseLabel(segmentElem.getAttribute("label"));
                String id = segmentElem.getAttribute("id");
                String color = segmentElem.getAttribute("color");
                String lengthAttr = segmentElem.getAttribute("length");
                int length = Integer.parseInt(lengthAttr);
                if (length <= 0) {
                    throw new IllegalArgumentException("Unsupported length: " + lengthAttr);
                }
                MarkerSegment segment = new MarkerSegment(label, id, color, length);
                parent.addSegment(segment);
                MarkerConfigXmlParser.parseSubMarkers(segmentElem, segment);
            }
            ++i;
        }
    }

    private static String parseLabel(String labelAttr) {
        if (labelAttr.isEmpty()) {
            return DEFAULT_LABEL;
        }
        return labelAttr;
    }

    private static double parsePeriod(String periodAttr) {
        double period = Double.parseDouble(periodAttr);
        if (period <= 0.0) {
            throw new IllegalArgumentException("Unsupported period: " + periodAttr);
        }
        return period;
    }

    private static String parseUnit(String unitAttr) {
        if (Arrays.asList("ms", "us", "ns", "cycles").contains(unitAttr)) {
            return unitAttr;
        }
        throw new IllegalArgumentException("Unsupported unit: " + unitAttr);
    }

    private static Range<Long> parseRange(String rangeAttr) {
        int index = rangeAttr.indexOf(ELLIPSIS);
        if (index > 0) {
            long min = Long.parseLong(rangeAttr.substring(0, index));
            if ((index += ELLIPSIS.length()) < rangeAttr.length()) {
                long max = Long.parseLong(rangeAttr.substring(index));
                return Range.closed((Comparable)Long.valueOf(min), (Comparable)Long.valueOf(max));
            }
            return Range.atLeast((Comparable)Long.valueOf(min));
        }
        if (index == 0) {
            if ((index += ELLIPSIS.length()) < rangeAttr.length()) {
                long max = Long.parseLong(rangeAttr.substring(index));
                return Range.atMost((Comparable)Long.valueOf(max));
            }
            return Range.all();
        }
        if (!rangeAttr.isEmpty()) {
            long val = Long.parseLong(rangeAttr);
            return Range.singleton((Comparable)Long.valueOf(val));
        }
        return Range.atLeast((Comparable)Long.valueOf(0L));
    }

    private static RangeSet<Long> parseRangeSet(String rangeSetAttr) {
        if (rangeSetAttr.isEmpty()) {
            return ImmutableRangeSet.of((Range)Range.all());
        }
        TreeRangeSet rangeSet = TreeRangeSet.create();
        String[] ranges = rangeSetAttr.split(",");
        if (ranges.length == 0) {
            rangeSet.add(Range.all());
        } else {
            String[] stringArray = ranges;
            int n = ranges.length;
            int n2 = 0;
            while (n2 < n) {
                String range = stringArray[n2];
                rangeSet.add(MarkerConfigXmlParser.parseRange(range));
                ++n2;
            }
        }
        return rangeSet;
    }

    private static long parseOffset(String offset) {
        if (offset.isEmpty()) {
            return 0L;
        }
        return Long.parseLong(offset);
    }

    private static final Collection<String> getExtensionDefinitionsPaths() {
        IConfigurationElement[] elements;
        final ArrayList<String> extensionDefinitionsPaths = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(TMF_CUSTOM_MARKERS_BUILTIN_EXTENSION_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(ELEMENT_NAME_CUSTOM_MARKERS)) {
                final String filename = element.getAttribute(ATTRIBUTE_NAME_FILE);
                final String name = element.getContributor().getName();
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws IOException {
                        Bundle bundle;
                        if (name != null && (bundle = Platform.getBundle((String)name)) != null) {
                            URL xmlUrl = bundle.getResource(filename);
                            URL locatedURL = FileLocator.toFileURL((URL)xmlUrl);
                            extensionDefinitionsPaths.add(locatedURL.getPath());
                        }
                    }

                    public void handleException(Throwable exception) {
                    }
                });
            }
            ++n2;
        }
        return extensionDefinitionsPaths;
    }
}

