/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;

public class FileTransfer
extends ByteArrayTransfer {
    private static final String TYPE_NAME = "CF_HDROP ";
    private static final int TYPE_ID = FileTransfer.registerType("CF_HDROP ");

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return SingletonUtil.getSessionInstance(FileTransfer.class);
    }

    @Override
    public void javaToNative(Object object, TransferData transferData) {
        String[] fileNames;
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.data = fileNames = (String[])object;
        transferData.result = 1;
    }

    @Override
    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.result != 1) {
            return null;
        }
        String[] fileNames = (String[])transferData.data;
        String[] result = new String[fileNames.length];
        System.arraycopy(fileNames, 0, result, 0, fileNames.length);
        return result;
    }

    @Override
    protected int[] getTypeIds() {
        return new int[]{TYPE_ID};
    }

    @Override
    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] strings = (String[])object;
        int i = 0;
        while (i < strings.length) {
            if (strings[i] == null || strings[i].length() == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

