/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.io;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends InputStream {
    private static final long CLOSED = Long.MIN_VALUE;
    private final InputStream in;
    private final boolean closeBackingStream;
    private long remaining;
    private long remainingAtMark;

    public LimitedInputStream(InputStream in, long length, boolean closeBackingStream) {
        this.in = in;
        this.remaining = length;
        this.closeBackingStream = closeBackingStream;
    }

    public LimitedInputStream(InputStream in, long length) {
        this(in, length, true);
    }

    @Override
    public int read() throws IOException {
        this.checkOpen();
        if (this.remaining <= 0L) {
            return -1;
        }
        --this.remaining;
        return this.in.read();
    }

    @Override
    public int read(byte[] cbuf, int off, int len) throws IOException {
        this.checkOpen();
        if (this.remaining <= 0L) {
            return -1;
        }
        if ((long)len > this.remaining) {
            len = (int)this.remaining;
        }
        this.remaining = (len = this.in.read(cbuf, off, len)) > 0 ? (this.remaining -= (long)len) : 0L;
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkOpen();
        if (n > this.remaining) {
            n = this.remaining;
        }
        n = this.in.skip(n);
        this.remaining -= n;
        return n;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.markSupported() && this.remaining != Long.MIN_VALUE) {
            this.in.mark(readlimit);
            this.remainingAtMark = this.remaining;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markSupported()) {
            this.checkOpen();
            this.in.reset();
            this.remaining = this.remainingAtMark;
        }
    }

    @Override
    public void close() throws IOException {
        this.remaining = Long.MIN_VALUE;
        if (this.closeBackingStream) {
            this.in.close();
        }
    }

    private void checkOpen() throws IOException {
        if (this.remaining == Long.MIN_VALUE) {
            throw new IOException("Stream is closed");
        }
    }
}

