/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.internal.tasks.ui.ScheduleTaskMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.actions.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskListChangeAdapter;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;

public class TaskEditorScheduleAction
extends Action
implements IMenuCreator {
    private final ITask task;
    private MenuManager menuManager;
    private final ScheduleTaskMenuContributor scheduleMenuContributor = new ScheduleTaskMenuContributor();
    private final ITaskListChangeListener TASK_LIST_LISTENER = new TaskListChangeAdapter(){

        @Override
        public void containersChanged(Set<TaskContainerDelta> containers) {
            for (TaskContainerDelta taskContainerDelta : containers) {
                AbstractTask updateTask;
                if (!(taskContainerDelta.getElement() instanceof ITask) || !TaskEditorScheduleAction.this.task.equals(updateTask = (AbstractTask)taskContainerDelta.getElement()) || PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().isClosing()) continue;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TaskEditorScheduleAction.this.updateImageDescriptor();
                    }
                });
            }
        }
    };

    public TaskEditorScheduleAction(ITask task) {
        Assert.isNotNull((Object)task);
        this.task = task;
        this.updateImageDescriptor();
        this.setMenuCreator(this);
        this.setToolTipText(Messages.TaskEditorScheduleAction_Private_Scheduling);
        TasksUiPlugin.getTaskList().addChangeListener(this.TASK_LIST_LISTENER);
    }

    public void run() {
        if (((AbstractTask)this.task).getScheduledForDate() == null) {
            TasksUiPlugin.getTaskList().addTaskIfAbsent(this.task);
            TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)this.task, (DateRange)TaskActivityUtil.getCurrentWeek().getToday());
        } else {
            TasksUiPlugin.getTaskActivityManager().setScheduledFor((AbstractTask)this.task, null);
        }
    }

    public void updateImageDescriptor() {
        if (this.task instanceof AbstractTask && ((AbstractTask)this.task).getScheduledForDate() != null) {
            this.setImageDescriptor(CommonImages.SCHEDULE_DAY);
        } else {
            this.setImageDescriptor(CommonImages.SCHEDULE);
        }
        this.setEnabled(!this.task.isCompleted());
    }

    public Menu getMenu(Control parent) {
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        this.menuManager = this.scheduleMenuContributor.getSubMenuManager(Collections.singletonList(this.task));
        this.menuManager.createContextMenu(parent);
        return this.menuManager.getMenu();
    }

    public Menu getMenu(Menu parent) {
        if (this.menuManager != null) {
            return this.menuManager.getMenu();
        }
        return null;
    }

    public void dispose() {
        if (this.menuManager != null) {
            this.menuManager.dispose();
        }
        TasksUiPlugin.getTaskList().removeChangeListener(this.TASK_LIST_LISTENER);
    }
}

