/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.jenkins.core;

import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.builds.core.BuildState;
import org.eclipse.mylyn.builds.core.BuildStatus;
import org.eclipse.mylyn.builds.core.EditType;
import org.eclipse.mylyn.builds.core.IArtifact;
import org.eclipse.mylyn.builds.core.IBooleanParameterDefinition;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildCause;
import org.eclipse.mylyn.builds.core.IBuildFactory;
import org.eclipse.mylyn.builds.core.IBuildParameterDefinition;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildReference;
import org.eclipse.mylyn.builds.core.IChange;
import org.eclipse.mylyn.builds.core.IChangeArtifact;
import org.eclipse.mylyn.builds.core.IChangeSet;
import org.eclipse.mylyn.builds.core.IChoiceParameterDefinition;
import org.eclipse.mylyn.builds.core.IFileParameterDefinition;
import org.eclipse.mylyn.builds.core.IHealthReport;
import org.eclipse.mylyn.builds.core.IParameterDefinition;
import org.eclipse.mylyn.builds.core.IPasswordParameterDefinition;
import org.eclipse.mylyn.builds.core.IStringParameterDefinition;
import org.eclipse.mylyn.builds.core.ITestCase;
import org.eclipse.mylyn.builds.core.ITestResult;
import org.eclipse.mylyn.builds.core.ITestSuite;
import org.eclipse.mylyn.builds.core.IUser;
import org.eclipse.mylyn.builds.core.TestCaseResult;
import org.eclipse.mylyn.builds.core.spi.BuildPlanRequest;
import org.eclipse.mylyn.builds.core.spi.BuildServerBehaviour;
import org.eclipse.mylyn.builds.core.spi.BuildServerConfiguration;
import org.eclipse.mylyn.builds.core.spi.GetBuildsRequest;
import org.eclipse.mylyn.builds.core.spi.RunBuildRequest;
import org.eclipse.mylyn.builds.internal.core.BuildFactory;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelAbstractBuild;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelBallColor;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelBuild;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelHealthReport;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelJob;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelRun;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelRunArtifact;
import org.eclipse.mylyn.internal.hudson.model.HudsonModelUser;
import org.eclipse.mylyn.internal.hudson.model.HudsonScmChangeLogSet;
import org.eclipse.mylyn.internal.hudson.model.HudsonTasksJunitCaseResult;
import org.eclipse.mylyn.internal.hudson.model.HudsonTasksJunitSuiteResult;
import org.eclipse.mylyn.internal.hudson.model.HudsonTasksJunitTestResult;
import org.eclipse.mylyn.internal.hudson.model.HudsonTasksTestAggregatedTestResultAction;
import org.eclipse.mylyn.internal.hudson.model.HudsonTasksTestAggregatedTestResultActionChildReport;
import org.eclipse.mylyn.internal.jenkins.core.JenkinsCorePlugin;
import org.eclipse.mylyn.internal.jenkins.core.JenkinsStatus;
import org.eclipse.mylyn.internal.jenkins.core.Messages;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsConfigurationCache;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsException;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsResourceNotFoundException;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsServerInfo;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsTestReport;
import org.eclipse.mylyn.internal.jenkins.core.client.JenkinsUrlUtil;
import org.eclipse.mylyn.internal.jenkins.core.client.RestfulJenkinsClient;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JenkinsServerBehaviour
extends BuildServerBehaviour {
    private final RestfulJenkinsClient client;
    private final RepositoryLocation location;
    private final JenkinsUrlUtil jenkinsUrlUtil;

    public JenkinsServerBehaviour(RepositoryLocation location, JenkinsConfigurationCache cache) {
        this.location = location;
        this.client = new RestfulJenkinsClient(location, cache);
        this.jenkinsUrlUtil = new JenkinsUrlUtil(this.location);
    }

    public RepositoryLocation getLocation() {
        return this.location;
    }

    protected HudsonModelBuild createBuildParameter(IBuild build) {
        HudsonModelBuild hudsonBuild = new HudsonModelBuild();
        hudsonBuild.setNumber(build.getBuildNumber());
        return hudsonBuild;
    }

    protected HudsonModelJob createJobParameter(IBuildPlan plan) {
        HudsonModelJob job = new HudsonModelJob();
        job.setName(plan.getId());
        return job;
    }

    public List<IBuild> getBuilds(GetBuildsRequest request, IOperationMonitor monitor) throws CoreException {
        try {
            if (request.getKind() == GetBuildsRequest.Kind.LAST || request.getKind() == GetBuildsRequest.Kind.SELECTED) {
                HudsonModelBuild requestBuild;
                HudsonModelJob job = this.createJobParameter(request.getPlan());
                if (request.getKind() == GetBuildsRequest.Kind.LAST) {
                    requestBuild = RestfulJenkinsClient.BuildId.LAST.getBuild();
                } else {
                    requestBuild = new HudsonModelBuild();
                    requestBuild.setNumber(Integer.parseInt((String)request.getIds().iterator().next()));
                }
                HudsonModelBuild hudsonBuild = this.client.getBuild(job, requestBuild, monitor);
                IBuild build = this.parseBuild(job, hudsonBuild);
                try {
                    JenkinsTestReport jenkinsTestReport = this.client.getTestReport(job, hudsonBuild, monitor);
                    ITestResult testResult = jenkinsTestReport.getJunitResult() != null ? this.parseTestResult(jenkinsTestReport.getJunitResult()) : this.parseTestResult(jenkinsTestReport.getAggregatedResult());
                    testResult.setBuild(build);
                    build.setTestResult(testResult);
                }
                catch (JenkinsResourceNotFoundException jenkinsResourceNotFoundException) {
                    // empty catch block
                }
                return Collections.singletonList(build);
            }
            if (request.getKind() == GetBuildsRequest.Kind.ALL && request.getScope() == GetBuildsRequest.Scope.HISTORY) {
                HudsonModelJob job = this.createJobParameter(request.getPlan());
                List<HudsonModelRun> hudsonBuilds = this.client.getBuilds(job, monitor);
                ArrayList<IBuild> builds = new ArrayList<IBuild>(hudsonBuilds.size());
                for (HudsonModelRun hudsonBuild : hudsonBuilds) {
                    builds.add(this.parseBuild(job, hudsonBuild));
                }
                return builds;
            }
        }
        catch (JenkinsResourceNotFoundException e) {
            return null;
        }
        catch (JenkinsException e) {
            throw JenkinsCorePlugin.toCoreException(e);
        }
        throw new UnsupportedOperationException("Unsupported request kind and scope combination: kind=" + request.getKind() + ",scope=" + request.getScope());
    }

    public BuildServerConfiguration getConfiguration() {
        Map<String, String> jobNameById = this.client.getConfiguration().jobNameById;
        ArrayList<IBuildPlan> plans = new ArrayList<IBuildPlan>(jobNameById.size());
        for (Map.Entry<String, String> entry : jobNameById.entrySet()) {
            IBuildPlan plan = this.createBuildPlan();
            plan.setId(entry.getKey());
            plan.setName(entry.getValue());
            plans.add(plan);
        }
        return new BuildServerConfiguration(plans);
    }

    public Reader getConsole(IBuild build, IOperationMonitor monitor) throws CoreException {
        try {
            HudsonModelJob job = this.createJobParameter(build.getPlan());
            HudsonModelBuild hudsonBuild = this.createBuildParameter(build);
            return this.client.getConsole(job, hudsonBuild, monitor);
        }
        catch (JenkinsException e) {
            throw JenkinsCorePlugin.toCoreException(e);
        }
    }

    private String getDefaultValue(Element element) throws JenkinsException {
        String value = this.getElementContent(element, "defaultValue", false);
        if (value != null) {
            return value;
        }
        NodeList nodes = element.getElementsByTagName("defaultParameterValue");
        if (nodes.getLength() == 1) {
            NodeList children = nodes.item(0).getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Element child = (Element)children.item(i);
                String tagName = child.getTagName();
                if ("value".equals(tagName)) {
                    return child.getTextContent();
                }
                ++i;
            }
        }
        return null;
    }

    private String getElementContent(Element element, String name, boolean required) throws JenkinsException {
        NodeList elements = element.getElementsByTagName(name);
        if (elements.getLength() == 0) {
            if (required) {
                throw new JenkinsException("No " + name + " element");
            }
            return null;
        }
        if (elements.getLength() > 1) {
            throw new JenkinsException("More than one " + name + " element");
        }
        return ((Element)elements.item(0)).getTextContent();
    }

    public List<IBuildPlan> getPlans(BuildPlanRequest request, IOperationMonitor monitor) throws CoreException {
        try {
            List<HudsonModelJob> jobs = this.client.getJobs(request.getPlanIds(), monitor);
            ArrayList<IBuildPlan> plans = new ArrayList<IBuildPlan>(jobs.size());
            for (HudsonModelJob job : jobs) {
                IBuildPlan plan = this.parseJob(job);
                plans.add(plan);
            }
            return plans;
        }
        catch (JenkinsException e) {
            throw JenkinsCorePlugin.toCoreException(e);
        }
    }

    private IArtifact parseArtifact(HudsonModelRunArtifact hudsonArtifact) {
        IArtifact artifact = this.createArtifact();
        artifact.setName(hudsonArtifact.getFileName());
        artifact.setRelativePath(hudsonArtifact.getRelativePath());
        return artifact;
    }

    private IBuild parseBuild(HudsonModelJob hudsonJob, HudsonModelRun hudsonBuild) {
        HudsonScmChangeLogSet changeSet;
        IBuild build = this.createBuild();
        build.setId(hudsonBuild.getId());
        build.setName(hudsonBuild.getFullDisplayName());
        build.setBuildNumber(hudsonBuild.getNumber());
        build.setLabel(String.valueOf(hudsonBuild.getNumber()));
        build.setDuration(hudsonBuild.getDuration());
        build.setTimestamp(hudsonBuild.getTimestamp().longValue());
        build.setUrl(hudsonBuild.getUrl());
        build.setState(hudsonBuild.isBuilding() ? BuildState.RUNNING : BuildState.STOPPED);
        build.setStatus(this.parseResult((Node)hudsonBuild.getResult()));
        build.setSummary(this.parseActions(build.getCause(), hudsonBuild.getAction()));
        if (hudsonBuild instanceof HudsonModelAbstractBuild) {
            for (HudsonModelUser hudsonUser : ((HudsonModelAbstractBuild)hudsonBuild).getCulprit()) {
                build.getCulprits().add(this.parseUser(hudsonUser));
            }
        }
        for (HudsonModelRunArtifact hudsonArtifact : hudsonBuild.getArtifact()) {
            IArtifact artifact = this.parseArtifact(hudsonArtifact);
            try {
                artifact.setUrl(this.client.getArtifactUrl(hudsonJob, hudsonBuild, hudsonArtifact));
            }
            catch (JenkinsException jenkinsException) {
                // empty catch block
            }
            build.getArtifacts().add(artifact);
        }
        if (hudsonBuild instanceof HudsonModelAbstractBuild && (changeSet = ((HudsonModelAbstractBuild)hudsonBuild).getChangeSet()) != null) {
            build.setChangeSet(this.parseChangeSet(changeSet));
        }
        return build;
    }

    private String parseActions(List<IBuildCause> causes, List<Object> actions) {
        int failCount = 0;
        int skipCount = 0;
        int totalCount = 0;
        LinkedHashSet<String> causeDescriptions = new LinkedHashSet<String>();
        for (Object action : actions) {
            Node node = (Node)action;
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Element child = (Element)children.item(i);
                String tagName = child.getTagName();
                try {
                    if ("cause".equals(tagName)) {
                        IBuildCause cause = this.parseCause(child);
                        causes.add(cause);
                        if (cause.getDescription() != null) {
                            causeDescriptions.add(cause.getDescription());
                        }
                    } else if ("failCount".equals(tagName)) {
                        failCount = Integer.parseInt(child.getTextContent());
                    } else if ("skipCount".equals(tagName)) {
                        skipCount = Integer.parseInt(child.getTextContent());
                    } else if ("totalCount".equals(tagName)) {
                        totalCount = Integer.parseInt(child.getTextContent());
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++i;
            }
        }
        StringBuilder sb = new StringBuilder();
        for (String string : causeDescriptions) {
            this.append(sb, string);
        }
        if (failCount != 0 || totalCount != 0 || skipCount != 0) {
            this.append(sb, NLS.bind((String)"{0} tests: {1} failed, {2} skipped", (Object[])new Object[]{totalCount, failCount, skipCount}));
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    private void append(StringBuilder sb, String text) {
        if (text != null) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(text);
        }
    }

    private IBuildCause parseCause(Node node) {
        IBuildCause cause = this.createBuildCause();
        String userName = null;
        String upstreamBuild = null;
        String upstreamProject = null;
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element child = (Element)children.item(i);
            String tagName = child.getTagName();
            if ("shortDescription".equals(tagName)) {
                cause.setDescription(child.getTextContent());
            } else if ("userName".equals(tagName)) {
                userName = child.getTextContent();
            } else if ("upstreamProject".equals(tagName)) {
                upstreamProject = child.getTextContent();
            } else if ("upstreamBuild".equals(tagName)) {
                upstreamBuild = child.getTextContent();
            }
            ++i;
        }
        if (userName != null) {
            IUser user = this.createUser();
            user.setId(userName);
            cause.setUser(user);
        }
        if (upstreamProject != null && upstreamBuild != null) {
            IBuildReference reference = this.createBuildReference();
            reference.setPlan(upstreamProject);
            reference.setBuild(upstreamBuild);
            cause.setBuild(reference);
        }
        return cause;
    }

    private IChange parseChange(Node node) {
        IChange change = this.createChange();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element child = (Element)children.item(i);
            String tagName = child.getTagName();
            if ("addedPath".equals(tagName)) {
                artifact = this.createChangeArtifact();
                artifact.setFile(child.getTextContent());
                artifact.setEditType(EditType.ADD);
                change.getArtifacts().add(artifact);
            } else if ("author".equals(tagName)) {
                change.setAuthor(this.parseUser(child));
            } else if ("comment".equals(tagName)) {
                change.setMessage(child.getTextContent());
            } else if ("date".equals(tagName)) {
                change.setDate(this.parseDate(child));
            } else if ("file".equals(tagName)) {
                change.getArtifacts().add(this.parseArtifact(child));
            } else if ("id".equals(tagName)) {
                change.setRevision(child.getTextContent());
            } else if ("modifiedPath".equals(tagName)) {
                artifact = this.createChangeArtifact();
                artifact.setFile(child.getTextContent());
                artifact.setEditType(EditType.EDIT);
                change.getArtifacts().add(artifact);
            } else if ("msg".equals(tagName)) {
                if (change.getMessage() == null) {
                    change.setMessage(child.getTextContent());
                }
            } else if ("node".equals(tagName)) {
                change.setRevision(child.getTextContent());
            } else if ("rev".equals(tagName)) {
                change.setRevision(child.getTextContent());
            } else if ("path".equals(tagName)) {
                change.getArtifacts().add(this.parseArtifact(child));
            } else if ("revision".equals(tagName)) {
                change.setRevision(child.getTextContent());
            } else if ("user".equals(tagName) && change.getAuthor() == null) {
                IUser user = this.createUser();
                user.setId(child.getTextContent());
                change.setAuthor(user);
            }
            ++i;
        }
        return change;
    }

    private IUser parseUser(Node node) {
        if (node != null) {
            IUser user = this.createUser();
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Element child = (Element)children.item(i);
                String tagName = child.getTagName();
                if ("absoluteUrl".equals(tagName)) {
                    user.setUrl(child.getTextContent());
                } else if ("fullName".equals(tagName)) {
                    user.setName(child.getTextContent());
                    user.setId(child.getTextContent());
                }
                ++i;
            }
            return user;
        }
        return null;
    }

    private IChangeArtifact parseArtifact(Node node) {
        IChangeArtifact artifact = this.createChangeArtifact();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element child = (Element)children.item(i);
            String tagName = child.getTagName();
            if ("editType".equals(tagName)) {
                artifact.setEditType(this.parseEditType(child));
            } else if ("file".equals(tagName)) {
                artifact.setFile(child.getTextContent());
            } else if ("fullName".equals(tagName)) {
                artifact.setFile(child.getTextContent());
            } else if ("prevrevision".equals(tagName)) {
                artifact.setPrevRevision(child.getTextContent());
            } else if ("revision".equals(tagName)) {
                artifact.setRevision(child.getTextContent());
            }
            ++i;
        }
        return artifact;
    }

    private EditType parseEditType(Element node) {
        if (node != null) {
            String text = node.getTextContent();
            if ("add".equals(text)) {
                return EditType.ADD;
            }
            if ("edit".equals(text)) {
                return EditType.EDIT;
            }
            if ("delete".equals(text)) {
                return EditType.DELETE;
            }
        }
        return null;
    }

    private long parseDate(Element node) {
        if (node != null) {
            String[] patterns = new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm:ss Z", "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"};
            String text = node.getTextContent();
            String[] stringArray = patterns;
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                String pattern = stringArray[n2];
                try {
                    return new SimpleDateFormat(pattern).parse(text).getTime();
                }
                catch (ParseException parseException) {
                    ++n2;
                }
            }
        }
        return 0L;
    }

    private IChangeSet parseChangeSet(HudsonScmChangeLogSet hudsonChangeSet) {
        IChangeSet changeSet = this.createChangeSet();
        changeSet.setKind(hudsonChangeSet.getKind());
        for (Object item : hudsonChangeSet.getItem()) {
            changeSet.getChanges().add(this.parseChange((Node)item));
        }
        return changeSet;
    }

    private long parseDuration(Node node) {
        if (node != null) {
            String text = node.getTextContent();
            try {
                return (long)(Double.parseDouble(text) * 1000.0);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    private IHealthReport parseHealthReport(HudsonModelHealthReport hudsonHealthReport) {
        IHealthReport healthReport = this.createHealthReport();
        healthReport.setHealth(hudsonHealthReport.getScore());
        healthReport.setDescription(hudsonHealthReport.getDescription());
        return healthReport;
    }

    public IBuildPlan parseJob(HudsonModelJob job) throws JenkinsException {
        IBuildPlan plan = this.createBuildPlan();
        String jobUrl = job.getUrl();
        if (this.jenkinsUrlUtil.isNestedJob(jobUrl)) {
            plan.setId(jobUrl);
        } else {
            plan.setId(job.getName());
        }
        plan.setName(this.jenkinsUrlUtil.getDisplayName(jobUrl));
        plan.setDescription(job.getDescription());
        plan.setUrl(job.getUrl());
        this.updateStateAndStatus(job, plan);
        this.updateHealth(job, plan);
        if (job.getLastBuild() != null) {
            IBuild build = this.createBuild();
            build.setId(String.valueOf(job.getLastBuild().getNumber()));
            build.setLabel(String.valueOf(job.getLastBuild().getNumber()));
            build.setBuildNumber(job.getLastBuild().getNumber());
            build.setUrl(job.getLastBuild().getUrl());
            plan.setLastBuild(build);
        }
        this.parseJobActions(plan.getParameterDefinitions(), job.getAction());
        return plan;
    }

    private void parseJobActions(List<IParameterDefinition> parameterDefinitions, List<Object> actions) {
        for (Object action : actions) {
            Node node = (Node)action;
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Element child = (Element)children.item(i);
                String tagName = child.getTagName();
                if ("parameterDefinition".equals(tagName)) {
                    try {
                        IParameterDefinition parameterDefinition = this.parseParameter(child);
                        parameterDefinitions.add(parameterDefinition);
                    }
                    catch (JenkinsException jenkinsException) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
    }

    private IParameterDefinition parseParameter(Element element) throws JenkinsException {
        String tagName = element.getTagName();
        if ("hudson.model.ChoiceParameterDefinition".equals(tagName) || "ChoiceParameterDefinition".equals(this.getElementContent(element, "type", false))) {
            Element option;
            IChoiceParameterDefinition definition = BuildFactory.eINSTANCE.createChoiceParameterDefinition();
            definition.setName(this.getElementContent(element, "name", true));
            definition.setDescription(this.getElementContent(element, "description", false));
            NodeList options = element.getElementsByTagName("string");
            int i = 0;
            while (i < options.getLength()) {
                option = (Element)options.item(i);
                definition.getOptions().add(option.getTextContent());
                ++i;
            }
            options = element.getElementsByTagName("choice");
            i = 0;
            while (i < options.getLength()) {
                option = (Element)options.item(i);
                definition.getOptions().add(option.getTextContent());
                ++i;
            }
            definition.setDefaultValue(this.getDefaultValue(element));
            return definition;
        }
        if ("hudson.model.BooleanParameterDefinition".equals(tagName) || "BooleanParameterDefinition".equals(this.getElementContent(element, "type", false))) {
            IBooleanParameterDefinition definition = IBuildFactory.INSTANCE.createBooleanParameterDefinition();
            definition.setName(this.getElementContent(element, "name", true));
            definition.setDescription(this.getElementContent(element, "description", false));
            String defaultValue = this.getDefaultValue(element);
            if (defaultValue != null) {
                definition.setDefaultValue(Boolean.parseBoolean(defaultValue));
            }
            return definition;
        }
        if ("hudson.model.StringParameterDefinition".equals(tagName) || "StringParameterDefinition".equals(this.getElementContent(element, "type", false))) {
            IStringParameterDefinition definition = IBuildFactory.INSTANCE.createStringParameterDefinition();
            definition.setName(this.getElementContent(element, "name", true));
            definition.setDescription(this.getElementContent(element, "description", false));
            definition.setDefaultValue(this.getDefaultValue(element));
            return definition;
        }
        if ("hudson.model.PasswordParameterDefinition".equals(tagName) || "PasswordParameterDefinition".equals(this.getElementContent(element, "type", false))) {
            IPasswordParameterDefinition definition = IBuildFactory.INSTANCE.createPasswordParameterDefinition();
            definition.setName(this.getElementContent(element, "name", true));
            definition.setDescription(this.getElementContent(element, "description", false));
            definition.setDefaultValue(this.getDefaultValue(element));
            return definition;
        }
        if ("hudson.model.RunParameterDefinition".equals(tagName) || "RunParameterDefinition".equals(this.getElementContent(element, "type", false))) {
            IBuildParameterDefinition definition = IBuildFactory.INSTANCE.createBuildParameterDefinition();
            definition.setName(this.getElementContent(element, "name", true));
            definition.setDescription(this.getElementContent(element, "description", false));
            definition.setBuildPlanId(this.getElementContent(element, "projectName", false));
            return definition;
        }
        if ("hudson.model.FileParameterDefinition".equals(tagName) || "FileParameterDefinition".equals(this.getElementContent(element, "type", false))) {
            IFileParameterDefinition definition = IBuildFactory.INSTANCE.createFileParameterDefinition();
            definition.setName(this.getElementContent(element, "name", true));
            definition.setDescription(this.getElementContent(element, "description", false));
            return definition;
        }
        throw new JenkinsException(NLS.bind((String)"Unexpected parameter ''{0}'' with type ''{1}''", (Object)tagName, (Object)this.getElementContent(element, "type", false)));
    }

    private BuildStatus parseResult(Node node) {
        if (node != null) {
            String text = node.getTextContent();
            if ("FAILURE".equals(text)) {
                return BuildStatus.FAILED;
            }
            try {
                return BuildStatus.valueOf((String)text);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    private ITestResult parseTestResult(HudsonTasksJunitTestResult hudsonTestReport) {
        ITestResult testResult = this.createTestResult();
        testResult.setFailCount(hudsonTestReport.getFailCount());
        testResult.setIgnoredCount(hudsonTestReport.getSkipCount());
        testResult.setPassCount(hudsonTestReport.getPassCount());
        testResult.setDuration(this.parseDuration((Node)hudsonTestReport.getDuration()));
        for (HudsonTasksJunitSuiteResult hudsonSuite : hudsonTestReport.getSuite()) {
            ITestSuite testSuite = this.createTestSuite();
            testSuite.setLabel(hudsonSuite.getName());
            testSuite.setDuration(this.parseDuration((Node)hudsonSuite.getDuration()));
            testSuite.setOutput(hudsonSuite.getStdout());
            testSuite.setErrorOutput(hudsonSuite.getStderr());
            for (HudsonTasksJunitCaseResult hudsonCase : hudsonSuite.getCase()) {
                ITestCase testCase = this.createTestCase();
                testCase.setLabel(hudsonCase.getName());
                testCase.setClassName(hudsonCase.getClassName());
                testCase.setDuration(this.parseDuration((Node)hudsonCase.getDuration()));
                testCase.setSkipped(hudsonCase.isSkipped());
                testCase.setMessage(hudsonCase.getErrorDetails());
                testCase.setStackTrace(hudsonCase.getErrorStackTrace());
                switch (hudsonCase.getStatus()) {
                    case PASSED: {
                        testCase.setStatus(TestCaseResult.PASSED);
                        break;
                    }
                    case SKIPPED: {
                        testCase.setStatus(TestCaseResult.SKIPPED);
                        break;
                    }
                    case FAILED: {
                        testCase.setStatus(TestCaseResult.FAILED);
                        break;
                    }
                    case FIXED: {
                        testCase.setStatus(TestCaseResult.FIXED);
                        break;
                    }
                    case REGRESSION: {
                        testCase.setStatus(TestCaseResult.REGRESSION);
                    }
                }
                testCase.setSuite(testSuite);
            }
            testSuite.setResult(testResult);
        }
        return testResult;
    }

    private ITestResult parseTestResult(HudsonTasksTestAggregatedTestResultAction hudsonTestReport) {
        ITestResult testResult = this.createTestResult();
        testResult.setFailCount(hudsonTestReport.getFailCount());
        testResult.setIgnoredCount(hudsonTestReport.getSkipCount());
        testResult.setPassCount(hudsonTestReport.getTotalCount() - hudsonTestReport.getFailCount() - hudsonTestReport.getSkipCount());
        for (HudsonTasksTestAggregatedTestResultActionChildReport child : hudsonTestReport.getChildReport()) {
            ITestResult childResult = this.parseTestResult((HudsonTasksJunitTestResult)child.getResult());
            testResult.getSuites().addAll(childResult.getSuites());
        }
        return testResult;
    }

    private IUser parseUser(HudsonModelUser hudsonUser) {
        IUser user = this.createUser();
        user.setId(hudsonUser.getId());
        user.setName(hudsonUser.getFullName());
        user.setUrl(hudsonUser.getAbsoluteUrl());
        return user;
    }

    public BuildServerConfiguration refreshConfiguration(IOperationMonitor monitor) throws CoreException {
        try {
            this.client.getJobs(null, monitor);
        }
        catch (JenkinsException e) {
            throw JenkinsCorePlugin.toCoreException(e);
        }
        return this.getConfiguration();
    }

    public void runBuild(RunBuildRequest request, IOperationMonitor monitor) throws CoreException {
        try {
            HudsonModelJob job = this.createJobParameter(request.getPlan());
            this.client.runBuild(job, request.getParameters(), monitor);
        }
        catch (JenkinsException e) {
            throw JenkinsCorePlugin.toCoreException(e);
        }
    }

    public void abortBuild(IBuild build, IOperationMonitor monitor) throws CoreException {
        try {
            HudsonModelJob job = this.createJobParameter(build.getPlan());
            HudsonModelBuild modelBuild = this.createBuildParameter(build);
            this.client.abortBuild(job, modelBuild, monitor);
        }
        catch (JenkinsException e) {
            throw JenkinsCorePlugin.toCoreException(e);
        }
    }

    protected void updateHealth(HudsonModelJob job, IBuildPlan plan) {
        String testResult = null;
        String buildResult = null;
        String result = null;
        List<HudsonModelHealthReport> husonHealthReports = job.getHealthReport();
        if (husonHealthReports.size() > 0) {
            plan.setHealth(husonHealthReports.get(0).getScore());
            for (HudsonModelHealthReport hudsonHealthReport : husonHealthReports) {
                String description;
                plan.getHealthReports().add(this.parseHealthReport(hudsonHealthReport));
                if (hudsonHealthReport.getScore() < plan.getHealth()) {
                    plan.setHealth(hudsonHealthReport.getScore());
                }
                if ((description = hudsonHealthReport.getDescription()) == null) continue;
                if (hudsonHealthReport.getDescription().startsWith("Test Result: ")) {
                    if (testResult != null) continue;
                    testResult = description.substring(13);
                    continue;
                }
                if (hudsonHealthReport.getDescription().startsWith("Build stability: ")) {
                    if (buildResult != null) continue;
                    buildResult = description.substring(17);
                    continue;
                }
                if (result != null) continue;
                int i = description.indexOf(": ");
                result = i != -1 ? description.substring(i + 2) : description;
            }
            if (testResult != null) {
                plan.setSummary(testResult);
            } else if (buildResult != null) {
                plan.setSummary(buildResult);
            } else {
                plan.setSummary(result);
            }
        } else {
            plan.setHealth(-1);
        }
    }

    protected void updateStateAndStatus(HudsonModelJob job, IBuildPlan plan) {
        HudsonModelBallColor color = job.getColor();
        if (color == null) {
            plan.setStatus(null);
            plan.setState(null);
        } else {
            switch (color) {
                case BLUE: 
                case GREEN: {
                    plan.setStatus(BuildStatus.SUCCESS);
                    plan.setState(BuildState.STOPPED);
                    break;
                }
                case BLUE_ANIME: 
                case GREEN_ANIME: {
                    plan.setStatus(BuildStatus.SUCCESS);
                    plan.setState(BuildState.RUNNING);
                    break;
                }
                case RED: {
                    plan.setStatus(BuildStatus.FAILED);
                    plan.setState(BuildState.STOPPED);
                    break;
                }
                case RED_ANIME: {
                    plan.setStatus(BuildStatus.FAILED);
                    plan.setState(BuildState.RUNNING);
                    break;
                }
                case YELLOW: {
                    plan.setStatus(BuildStatus.UNSTABLE);
                    plan.setState(BuildState.STOPPED);
                    break;
                }
                case YELLOW_ANIME: {
                    plan.setStatus(BuildStatus.UNSTABLE);
                    plan.setState(BuildState.RUNNING);
                    break;
                }
                case GREY: {
                    plan.setStatus(BuildStatus.DISABLED);
                    plan.setState(BuildState.STOPPED);
                    break;
                }
                case GREY_ANIME: {
                    plan.setStatus(BuildStatus.DISABLED);
                    plan.setState(BuildState.RUNNING);
                    break;
                }
                case DISABLED: {
                    plan.setStatus(BuildStatus.DISABLED);
                    plan.setState(BuildState.STOPPED);
                    break;
                }
                case DISABLED_ANIME: {
                    plan.setStatus(BuildStatus.DISABLED);
                    plan.setState(BuildState.RUNNING);
                    break;
                }
                case ABORTED: {
                    plan.setStatus(BuildStatus.ABORTED);
                    plan.setState(BuildState.STOPPED);
                    break;
                }
                case ABORTED_ANIME: {
                    plan.setStatus(BuildStatus.ABORTED);
                    plan.setState(BuildState.RUNNING);
                    break;
                }
                case NOTBUILT: {
                    plan.setStatus(BuildStatus.NOT_BUILT);
                    plan.setState(BuildState.STOPPED);
                    break;
                }
                case NOTBUILT_ANIME: {
                    plan.setStatus(BuildStatus.NOT_BUILT);
                    plan.setState(BuildState.RUNNING);
                    break;
                }
                default: {
                    plan.setStatus(null);
                    plan.setState(null);
                }
            }
        }
        EnumSet<BuildState> flags = EnumSet.noneOf(BuildState.class);
        if (plan.getState() != null) {
            flags.add(plan.getState());
        }
        if (job.isInQueue()) {
            flags.add(BuildState.QUEUED);
        }
        if (job.isBuildable()) {
            flags.add(BuildState.BUILDABLE);
        }
        plan.getFlags().addAll(flags);
    }

    public IStatus validate(IOperationMonitor monitor) throws CoreException {
        try {
            JenkinsServerInfo info = this.client.validate(monitor);
            JenkinsStatus status = new JenkinsStatus(0, "org.eclipse.mylyn.jenkins.core", NLS.bind((String)Messages.JenkinsServerBehaviour_Validation_succesful, (Object)info.getVersion()));
            status.setInfo(info);
            return status;
        }
        catch (JenkinsException e) {
            throw JenkinsCorePlugin.toCoreException(e);
        }
    }
}

