/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.pom;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.m2e.core.ui.internal.actions.OpenPomAction;
import org.eclipse.m2e.core.ui.internal.util.XmlUtils;
import org.eclipse.m2e.editor.internal.Messages;
import org.eclipse.m2e.editor.pom.PomTemplateContext;
import org.eclipse.m2e.editor.pom.XMLEditorUtility;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PomHyperlinkDetector
implements IHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        try {
            IRegion lineInfo = document.getLineInformationOfOffset(region.getOffset());
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
        if (line.length() == 0) {
            return null;
        }
        ArrayList hyperlinks = new ArrayList();
        int offset = region.getOffset();
        XmlUtils.performOnCurrentElement((IDocument)document, (int)offset, (node, structured) -> {
            if (textViewer instanceof ISourceViewer var6_7 && (links = PomHyperlinkDetector.openExternalMarkerDefinition((ISourceViewer)sourceViwer, offset)).length > 0) {
                hyperlinks.addAll(Arrays.asList(links));
            }
            if ((link = this.openPropertyDefinition(node, textViewer, offset)) != null) {
                hyperlinks.add(link);
            }
            if ((link = this.openDPManagement(node, textViewer, offset)) != null) {
                hyperlinks.add(link);
            }
            if ((link = this.openModule(node, textViewer, offset)) != null) {
                hyperlinks.add(link);
            }
            if ((link = this.openPOMbyID(node, textViewer)) != null) {
                hyperlinks.add(link);
            }
        });
        if (!hyperlinks.isEmpty()) {
            return hyperlinks.toArray(new IHyperlink[0]);
        }
        return null;
    }

    static ManagedArtifactRegion findManagedArtifactRegion(Node current, ITextViewer textViewer, int offset) {
        while (current != null && !(current instanceof Element)) {
            current = current.getParentNode();
        }
        if (current != null) {
            Node artNode = null;
            Node groupNode = null;
            if ("artifactId".equals(current.getNodeName())) {
                artNode = current;
            }
            if ("groupId".equals(current.getNodeName())) {
                groupNode = current;
            }
            if (artNode == null && groupNode == null) {
                return null;
            }
            Node root = current.getParentNode();
            boolean isDependency = false;
            boolean isPlugin = false;
            if (root != null) {
                String name = root.getNodeName();
                if ("dependency".equals(name)) {
                    isDependency = true;
                }
                if ("plugin".equals(name)) {
                    isPlugin = true;
                }
            } else {
                return null;
            }
            if (!isDependency && !isPlugin) {
                return null;
            }
            NodeList childs = root.getChildNodes();
            int i = 0;
            while (i < childs.getLength()) {
                Node child = childs.item(i);
                if (child instanceof Element var11_12) {
                    if ("version".equals(el.getNodeName())) {
                        return null;
                    }
                    if (artNode == null && "artifactId".equals(el.getNodeName())) {
                        artNode = el;
                    }
                    if (groupNode == null && "groupId".equals(el.getNodeName())) {
                        groupNode = el;
                    }
                }
                ++i;
            }
            if (groupNode != null && artNode != null) {
                assert (groupNode instanceof IndexedRegion);
                assert (artNode instanceof IndexedRegion);
                IndexedRegion groupReg = (IndexedRegion)groupNode;
                IndexedRegion artReg = (IndexedRegion)artNode;
                int startOffset = Math.min(groupReg.getStartOffset(), artReg.getStartOffset());
                int length = Math.max(groupReg.getEndOffset(), artReg.getEndOffset()) - startOffset;
                String groupId = XmlUtils.getTextValue((Node)groupNode);
                String artifactId = XmlUtils.getTextValue((Node)artNode);
                MavenProject prj = XmlUtils.extractMavenProject((ITextViewer)textViewer);
                if (prj != null) {
                    return new ManagedArtifactRegion(startOffset, length, groupId, artifactId, isDependency, isPlugin, prj);
                }
            }
        }
        return null;
    }

    public static IHyperlink createHyperlink(final ManagedArtifactRegion region) {
        return new IHyperlink(){

            public IRegion getHyperlinkRegion() {
                return region;
            }

            public String getHyperlinkText() {
                return NLS.bind((String)Messages.PomHyperlinkDetector_link_managed, (Object)(region.groupId + ":" + region.artifactId));
            }

            public String getTypeLabel() {
                return "pom-dependency-plugin-management";
            }

            public void open() {
                File file;
                InputLocation openLocation;
                MavenProject mavprj = region.project;
                if (mavprj != null && (openLocation = PomHyperlinkDetector.findLocationForManagedArtifact(region, mavprj)) != null && (file = XmlUtils.fileForInputLocation((InputLocation)openLocation, (MavenProject)mavprj)) != null) {
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toURI());
                    XMLEditorUtility.openXmlEditor(fileStore, openLocation.getLineNumber(), openLocation.getColumnNumber(), openLocation.getSource().getModelId());
                }
            }
        };
    }

    private IHyperlink openDPManagement(Node current, ITextViewer textViewer, int offset) {
        ManagedArtifactRegion region = PomHyperlinkDetector.findManagedArtifactRegion(current, textViewer, offset);
        if (region != null) {
            return PomHyperlinkDetector.createHyperlink(region);
        }
        return null;
    }

    static InputLocation findLocationForManagedArtifact(ManagedArtifactRegion region, MavenProject mavprj) {
        PluginManagement pm;
        Build build;
        DependencyManagement dm;
        Model mdl = mavprj.getModel();
        InputLocation openLocation = null;
        if (region.isDependency && (dm = mdl.getDependencyManagement()) != null) {
            List list = dm.getDependencies();
            String id = String.valueOf(region.groupId) + ":" + region.artifactId + ":";
            if (list != null) {
                for (Dependency dep : list) {
                    InputLocation location;
                    if (!dep.getManagementKey().startsWith(id) || (location = dep.getLocation((Object)"artifactId")) == null) continue;
                    openLocation = location;
                    break;
                }
            }
        }
        if (region.isPlugin && (build = mdl.getBuild()) != null && (pm = build.getPluginManagement()) != null) {
            List list = pm.getPlugins();
            String id = Plugin.constructKey((String)region.groupId, (String)region.artifactId);
            if (list != null) {
                for (Plugin plg : list) {
                    InputLocation location;
                    if (!id.equals(plg.getKey()) || (location = plg.getLocation((Object)"artifactId")) == null) continue;
                    openLocation = location;
                    break;
                }
            }
        }
        return openLocation;
    }

    static ExpressionRegion findExpressionRegion(Node current, ITextViewer viewer, int offset) {
        if (current instanceof Text var3_4 && (value = node.getNodeValue()) != null && node instanceof IndexedRegion var7_7) {
            int index = offset - reg.getStartOffset();
            String before = value.substring(0, Math.min(index + 1, value.length()));
            String after = value.substring(Math.min(index + 1, value.length()));
            int start = before.lastIndexOf("${");
            if (before.lastIndexOf("}") > start) {
                start = -1;
            }
            int end = after.indexOf("}");
            if (after.indexOf("${") != -1 && after.indexOf("${") < end) {
                end = -1;
            }
            if (start > -1 && end > -1) {
                int startOffset = reg.getStartOffset() + start;
                String expr = String.valueOf(before.substring(start)) + after.substring(0, end + 1);
                int length = expr.length();
                String prop = String.valueOf(before.substring(start + 2)) + after.substring(0, end);
                MavenProject prj = XmlUtils.extractMavenProject((ITextViewer)viewer);
                if (prj != null) {
                    return new ExpressionRegion(startOffset, length, prop, prj);
                }
            }
        }
        return null;
    }

    public static IHyperlink createHyperlink(final ExpressionRegion region) {
        return new IHyperlink(){

            public IRegion getHyperlinkRegion() {
                return region;
            }

            public String getHyperlinkText() {
                return NLS.bind((String)Messages.PomHyperlinkDetector_open_property, (Object)region.property);
            }

            public String getTypeLabel() {
                return "pom-property-expression";
            }

            public void open() {
                MavenProject mavprj = region.project;
                if (mavprj != null) {
                    File file;
                    Model mdl = mavprj.getModel();
                    InputLocation location = null;
                    if (mdl.getProperties().containsKey(region.property)) {
                        location = mdl.getLocation((Object)"properties").getLocation((Object)region.property);
                    } else if (region.property != null && region.property.startsWith("project.")) {
                        if ("project.version".equals(region.property)) {
                            location = mdl.getLocation((Object)"version");
                        } else if ("project.name".equals(region.property)) {
                            location = mdl.getLocation((Object)"name");
                        }
                    }
                    if (location != null && (file = XmlUtils.fileForInputLocation((InputLocation)location, (MavenProject)mavprj)) != null) {
                        IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toURI());
                        XMLEditorUtility.openXmlEditor(fileStore, location.getLineNumber(), location.getColumnNumber(), location.getSource().getModelId());
                    }
                }
            }
        };
    }

    public static boolean canCreateHyperLink(ExpressionRegion region) {
        if ("project.version".equals(region.property) || "project.name".equals(region.property)) {
            return true;
        }
        return region.project != null && region.project.getModel().getProperties().containsKey(region.property);
    }

    public static boolean canCreateHyperLink(ManagedArtifactRegion region) {
        return region.project != null && PomHyperlinkDetector.findLocationForManagedArtifact(region, region.project) != null;
    }

    static IHyperlink[] openExternalMarkerDefinition(ISourceViewer sourceViewer, int offset) {
        MarkerRegion[] regions;
        ArrayList<IHyperlink> toRet = new ArrayList<IHyperlink>();
        MarkerRegion[] markerRegionArray = regions = PomHyperlinkDetector.findMarkerRegions(sourceViewer, offset);
        int n = regions.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerRegion reg = markerRegionArray[n2];
            if (reg.isDefinedInParent()) {
                toRet.add(PomHyperlinkDetector.createHyperlink(reg));
            }
            ++n2;
        }
        return toRet.toArray(new IHyperlink[0]);
    }

    /*
     * WARNING - void declaration
     */
    static MarkerRegion[] findMarkerRegions(ISourceViewer sourceViewer, int offset) {
        ArrayList<MarkerRegion> toRet = new ArrayList<MarkerRegion>();
        IAnnotationModel model = sourceViewer.getAnnotationModel();
        if (model != null) {
            Iterator it = model.getAnnotationIterator();
            while (it.hasNext()) {
                void marker;
                Position pos;
                MarkerAnnotation markerAnnotation;
                Annotation ann = (Annotation)it.next();
                Annotation annotation = ann;
                if (!(annotation instanceof MarkerAnnotation) || (markerAnnotation = (MarkerAnnotation)annotation) != (MarkerAnnotation)annotation || !(pos = sourceViewer.getAnnotationModel().getPosition(ann)).includes(offset)) continue;
                toRet.add(new MarkerRegion(pos.getOffset(), pos.getLength(), (MarkerAnnotation)marker));
            }
        }
        return toRet.toArray(new MarkerRegion[0]);
    }

    public static IHyperlink createHyperlink(final MarkerRegion mark) {
        return new IHyperlink(){

            public IRegion getHyperlinkRegion() {
                return new Region(mark.getOffset(), mark.getLength());
            }

            public String getTypeLabel() {
                return "marker-error-defined-in-parent";
            }

            public String getHyperlinkText() {
                return NLS.bind((String)"Open definition in parent for {0}", (Object)mark.getAnnotation().getText());
            }

            public void open() {
                IMarker marker = mark.getAnnotation().getMarker();
                String loc = marker.getAttribute("causeResourcePath", null);
                if (loc != null) {
                    IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(loc));
                    int row = marker.getAttribute("causeLineNumber", 0);
                    int column = marker.getAttribute("causeColumnStart", 0);
                    String name = marker.getAttribute("causeResourceId", null);
                    XMLEditorUtility.openXmlEditor(fileStore, row, column, name);
                }
            }
        };
    }

    private IHyperlink openPropertyDefinition(Node current, ITextViewer viewer, int offset) {
        ExpressionRegion region = PomHyperlinkDetector.findExpressionRegion(current, viewer, offset);
        if (region != null && PomHyperlinkDetector.canCreateHyperLink(region)) {
            return PomHyperlinkDetector.createHyperlink(region);
        }
        return null;
    }

    private IHyperlink openModule(Node current, ITextViewer textViewer, int offset) {
        IFileStore fileStore;
        String path;
        while (current != null && !(current instanceof Element)) {
            current = current.getParentNode();
        }
        if (current == null) {
            return null;
        }
        String pathUp = XmlUtils.pathUp((Node)current, (int)2);
        if (!"modules/module".equals(pathUp)) {
            return null;
        }
        ITextFileBuffer buf = FileBuffers.getTextFileBufferManager().getTextFileBuffer(textViewer.getDocument());
        if (buf == null) {
            return null;
        }
        IFileStore folder = buf.getFileStore().getParent();
        final String fPath = path = XmlUtils.getTextValue((Node)current);
        while (folder != null && path.startsWith("../")) {
            folder = folder.getParent();
            path = path.substring("../".length());
        }
        if (folder == null) {
            return null;
        }
        IFileStore modulePom = folder.getChild(path);
        if (!modulePom.getName().endsWith("xml")) {
            modulePom = modulePom.getChild("pom.xml");
        }
        if (!(fileStore = modulePom).fetchInfo().exists()) {
            return null;
        }
        assert (current instanceof IndexedRegion);
        final IndexedRegion region = (IndexedRegion)current;
        return new IHyperlink(){

            public IRegion getHyperlinkRegion() {
                return new Region(region.getStartOffset(), region.getEndOffset() - region.getStartOffset());
            }

            public String getHyperlinkText() {
                return NLS.bind((String)Messages.PomHyperlinkDetector_open_module, (Object)fPath);
            }

            public String getTypeLabel() {
                return "pom-module";
            }

            public void open() {
                XMLEditorUtility.openXmlEditor(fileStore);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private IHyperlink openPOMbyID(Node current, ITextViewer viewer) {
        void parent;
        Element element;
        Node node;
        while (current != null && !(current instanceof Element)) {
            current = current.getParentNode();
        }
        if (current == null) {
            return null;
        }
        if ((current = current.getParentNode()) == null || !((node = current) instanceof Element) || (element = (Element)node) != (Element)node) {
            return null;
        }
        String parentName = parent.getNodeName();
        if ("dependency".equals(parentName) || "parent".equals(parentName) || "plugin".equals(parentName) || "reportPlugin".equals(parentName) || "extension".equals(parentName)) {
            final Element groupId = XmlUtils.findChild((Element)parent, (String)"groupId");
            final Element artifactId = XmlUtils.findChild((Element)parent, (String)"artifactId");
            final Element version = XmlUtils.findChild((Element)parent, (String)"version");
            final MavenProject prj = XmlUtils.extractMavenProject((ITextViewer)viewer);
            return new IHyperlink(){

                public IRegion getHyperlinkRegion() {
                    int max = groupId != null ? ((IndexedRegion)groupId).getEndOffset() : Integer.MIN_VALUE;
                    int min = groupId != null ? ((IndexedRegion)groupId).getStartOffset() : Integer.MAX_VALUE;
                    max = Math.max(max, artifactId != null ? ((IndexedRegion)artifactId).getEndOffset() : Integer.MIN_VALUE);
                    min = Math.min(min, artifactId != null ? ((IndexedRegion)artifactId).getStartOffset() : Integer.MAX_VALUE);
                    max = Math.max(max, version != null ? ((IndexedRegion)version).getEndOffset() : Integer.MIN_VALUE);
                    min = Math.min(min, version != null ? ((IndexedRegion)version).getStartOffset() : Integer.MAX_VALUE);
                    return new Region(min, max - min);
                }

                public String getHyperlinkText() {
                    return NLS.bind((String)Messages.PomHyperlinkDetector_hyperlink_pattern, (Object)XmlUtils.getTextValue((Node)groupId), (Object)XmlUtils.getTextValue((Node)artifactId));
                }

                public String getTypeLabel() {
                    return "pom";
                }

                public void open() {
                    new Job(Messages.PomHyperlinkDetector_job_name){

                        protected IStatus run(IProgressMonitor monitor) {
                            String versionString;
                            String gridString = groupId == null ? "org.apache.maven.plugins" : XmlUtils.getTextValue((Node)groupId);
                            String artidString = artifactId == null ? null : XmlUtils.getTextValue((Node)artifactId);
                            String string = versionString = version == null ? null : XmlUtils.getTextValue((Node)version);
                            if (prj != null && gridString != null && artidString != null && (versionString == null || versionString.contains("${"))) {
                                versionString = PomTemplateContext.extractVersion(prj, null, versionString, gridString, artidString, PomTemplateContext.EXTRACT_STRATEGY_DEPENDENCY);
                            }
                            if (versionString == null) {
                                return Status.OK_STATUS;
                            }
                            OpenPomAction.openEditor((String)gridString, (String)artidString, (String)versionString, (MavenProject)prj, (IProgressMonitor)monitor);
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            };
        }
        return null;
    }

    public static class ExpressionRegion
    implements IRegion {
        final String property;
        private final int length;
        private final int offset;
        final MavenProject project;

        public ExpressionRegion(int startOffset, int length, String prop, MavenProject project) {
            this.offset = startOffset;
            this.length = length;
            this.property = prop;
            this.project = project;
            assert (project != null);
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    public static class ManagedArtifactRegion
    implements IRegion {
        private final int length;
        private final int offset;
        final MavenProject project;
        final String groupId;
        final String artifactId;
        final boolean isPlugin;
        final boolean isDependency;

        public ManagedArtifactRegion(int startOffset, int length, String groupId, String artifactId, boolean isDependency, boolean isPlugin, MavenProject project) {
            this.offset = startOffset;
            this.length = length;
            this.project = project;
            assert (project != null);
            this.artifactId = artifactId;
            this.groupId = groupId;
            this.isDependency = isDependency;
            this.isPlugin = isPlugin;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }
    }

    public static class MarkerRegion
    implements IRegion {
        private final MarkerAnnotation ann;
        final int offset;
        final int length;

        public MarkerRegion(int offset, int length, MarkerAnnotation applicable) {
            this.offset = offset;
            this.length = length;
            this.ann = applicable;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public MarkerAnnotation getAnnotation() {
            return this.ann;
        }

        public boolean isDefinedInParent() {
            IMarker mark = this.ann.getMarker();
            String isElsewhere = mark.getAttribute("causeResourcePath", null);
            return isElsewhere != null;
        }
    }
}

