/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.changelog.core.IFormatterChangeLogContrib;
import org.eclipse.linuxtools.changelog.core.IParserChangeLogContrib;
import org.eclipse.linuxtools.internal.changelog.core.ChangelogPlugin;
import org.eclipse.linuxtools.internal.changelog.core.Messages;

public final class ChangeLogExtensionManager {
    private static final ChangeLogExtensionManager EXM = new ChangeLogExtensionManager();
    private IConfigurationElement cachedPrefFormatter = null;
    private IConfigurationElement[] cachedInFileFormateters = null;
    private IExtensionPoint parserExtensions = null;
    private IExtensionPoint formatterExtensions = null;
    private IConfigurationElement formatterConfigElementToUse = null;

    private ChangeLogExtensionManager() {
        this.getParserContributions();
        this.getFormatterContributions();
    }

    public static ChangeLogExtensionManager getExtensionManager() {
        return EXM;
    }

    private void getFormatterContributions() {
        this.formatterExtensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.changelog.core", "formatterContribution");
    }

    private void getParserContributions() {
        this.parserExtensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.linuxtools.changelog.core", "parserContribution");
    }

    public IParserChangeLogContrib getParserContributor(String editorName) {
        if (this.parserExtensions != null) {
            IConfigurationElement[] elements = this.parserExtensions.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                if (elements[i].getName().equals("parser") && elements[i].getAttribute("editor").equals(editorName)) {
                    try {
                        IConfigurationElement bob = elements[i];
                        return (IParserChangeLogContrib)bob.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        ChangelogPlugin.getDefault().getLog().log(Status.error((String)e.getMessage(), (Throwable)e));
                    }
                }
                ++i;
            }
        }
        return null;
    }

    public IConfigurationElement getFormatterConfigElement() {
        return this.formatterConfigElementToUse;
    }

    public IFormatterChangeLogContrib getFormatterContributor(String entryFilePath, String formatterName) {
        int lastDir = entryFilePath.lastIndexOf(47);
        String fileName = lastDir >= 0 && lastDir + 1 <= entryFilePath.length() ? entryFilePath.substring(lastDir + 1, entryFilePath.length()) : entryFilePath;
        this.formatterConfigElementToUse = null;
        if (this.formatterExtensions != null) {
            int i;
            IConfigurationElement[] elements = this.formatterExtensions.getConfigurationElements();
            if (this.cachedInFileFormateters == null) {
                LinkedList<IConfigurationElement> inFileFormatters = new LinkedList<IConfigurationElement>();
                i = 0;
                while (i < elements.length) {
                    IConfigurationElement formatterConfigElement = elements[i];
                    if (formatterConfigElement.getName().equals("formatter") && formatterConfigElement.getAttribute("inFile").equalsIgnoreCase("true")) {
                        inFileFormatters.add(elements[i]);
                    }
                    ++i;
                }
                this.cachedInFileFormateters = inFileFormatters.toArray(new IConfigurationElement[0]);
            }
            IConfigurationElement[] iConfigurationElementArray = this.cachedInFileFormateters;
            int n = this.cachedInFileFormateters.length;
            i = 0;
            while (i < n) {
                IConfigurationElement formatterConfigElement = iConfigurationElementArray[i];
                IConfigurationElement[] patternElementTmp = formatterConfigElement.getChildren();
                if (patternElementTmp != null) {
                    IConfigurationElement patternElement = patternElementTmp[0];
                    if (patternElement.getAttribute("pattern") == null) {
                        ChangelogPlugin.getDefault().getLog().log(Status.error((String)Messages.getString("ChangeLog.ErrNonPattern"), (Throwable)new Exception(Messages.getString("ChangeLog.ErrNonPattern"))));
                    } else {
                        String filePattern = patternElement.getAttribute("pattern");
                        try {
                            Pattern pattern = Pattern.compile(filePattern);
                            Matcher fileMatcher = pattern.matcher(fileName);
                            if (fileMatcher.matches()) {
                                this.formatterConfigElementToUse = formatterConfigElement;
                                break;
                            }
                        }
                        catch (PatternSyntaxException e) {
                            ChangelogPlugin.getDefault().getLog().log(Status.error((String)e.getMessage(), (Throwable)e));
                        }
                    }
                }
                ++i;
            }
            if (this.formatterConfigElementToUse == null) {
                if (this.cachedPrefFormatter == null || !this.cachedPrefFormatter.getAttribute("name").equals(formatterName)) {
                    int i2 = 0;
                    while (i2 < elements.length) {
                        IConfigurationElement formatterConfigElement = elements[i2];
                        if (formatterConfigElement.getName().equals("formatter") && formatterConfigElement.getAttribute("inFile").equalsIgnoreCase("false")) {
                            if (!formatterConfigElement.getAttribute("name").equals(formatterName)) break;
                            this.cachedPrefFormatter = formatterConfigElement;
                            break;
                        }
                        ++i2;
                    }
                }
                this.formatterConfigElementToUse = this.cachedPrefFormatter;
                if (this.formatterConfigElementToUse == null) {
                    ChangelogPlugin.getDefault().getLog().log(Status.error((String)Messages.getString("ChangeLog.ErrRetrieveFormatter"), (Throwable)new Exception(Messages.getString("ChangeLog.ErrRetrieveFormatter"))));
                    return null;
                }
            }
        }
        try {
            return (IFormatterChangeLogContrib)this.formatterConfigElementToUse.createExecutableExtension("class");
        }
        catch (CoreException e) {
            ChangelogPlugin.getDefault().getLog().log(Status.error((String)e.getMessage(), (Throwable)e));
            e.printStackTrace();
            return null;
        }
    }
}

