/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceMember;
import org.eclipse.jpt.common.core.internal.utility.jdt.JavaResourceTypeBinding;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.jdt.Attribute;
import org.eclipse.jpt.common.core.utility.jdt.TypeBinding;

abstract class SourceAttribute<A extends Attribute>
extends SourceMember<A>
implements JavaResourceAttribute {
    private int modifiers;
    private JavaResourceTypeBinding typeBinding;

    protected SourceAttribute(JavaResourceType parent, A attribute) {
        super((JavaResourceModel)parent, attribute);
    }

    @Override
    protected void initialize(IBinding binding) {
        super.initialize(binding);
        this.modifiers = this.buildModifiers(binding);
        this.typeBinding = this.buildTypeBinding(this.getJdtTypeBinding(binding));
    }

    protected void resolveTypes(IBinding binding) {
        this.syncTypeBinding(this.getJdtTypeBinding(binding));
    }

    @Override
    protected void synchronizeWith(IBinding binding) {
        super.synchronizeWith(binding);
        this.setModifiers(this.buildModifiers(binding));
        this.syncTypeBinding(this.getJdtTypeBinding(binding));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public JavaResourceType getParent() {
        return (JavaResourceType)super.getParent();
    }

    @Override
    public JavaResourceType getResourceType() {
        return this.getParent();
    }

    @Override
    public String getName() {
        return ((Attribute)this.annotatedElement).getAttributeName();
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    private void setModifiers(int astModifiers) {
        int old = this.modifiers;
        this.modifiers = astModifiers;
        this.firePropertyChanged("modifiers", old, astModifiers);
    }

    private int buildModifiers(IBinding binding) {
        return binding == null ? 0 : binding.getModifiers();
    }

    @Override
    public TypeBinding getTypeBinding() {
        return this.typeBinding;
    }

    protected void syncTypeBinding(ITypeBinding binding) {
        if (this.typeBinding.isEquivalentTo(binding)) {
            return;
        }
        JavaResourceTypeBinding old = this.typeBinding;
        this.typeBinding = this.buildTypeBinding(binding);
        this.firePropertyChanged("typeBinding", old, this.typeBinding);
    }

    protected JavaResourceTypeBinding buildTypeBinding(ITypeBinding binding) {
        return new JavaResourceTypeBinding(binding);
    }

    protected abstract ITypeBinding getJdtTypeBinding(IBinding var1);
}

