/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.manipulation.ICleanUpFixCore;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.fix.IProposableFix;
import org.eclipse.jdt.internal.corext.refactoring.code.InlineMethodRefactoring;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;

public class InlineMethodFixCore
implements IProposableFix,
ICleanUpFixCore {
    private final String fName;
    private final ICompilationUnit fCompilationUnit;
    private final InlineMethodRefactoring fRefactoring;

    private InlineMethodFixCore(String name, CompilationUnit compilationUnit, InlineMethodRefactoring refactoring) {
        this.fName = name;
        this.fCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        this.fRefactoring = refactoring;
    }

    public static InlineMethodFixCore create(String name, CompilationUnit compilationUnit, MethodInvocation methodInvocation) {
        ICompilationUnit cu = (ICompilationUnit)compilationUnit.getJavaElement();
        InlineMethodRefactoring refactoring = InlineMethodRefactoring.create((ITypeRoot)cu, compilationUnit, methodInvocation.getStartPosition(), methodInvocation.getLength());
        try {
            RefactoringStatus status = refactoring.checkAllConditions((IProgressMonitor)new NullProgressMonitor());
            if (!status.isOK()) {
                return null;
            }
        }
        catch (CoreException | OperationCanceledException throwable) {
            return null;
        }
        InlineMethodFixCore fix = new InlineMethodFixCore(name, compilationUnit, refactoring);
        return fix;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CompilationUnitChange createChange(IProgressMonitor progressMonitor) throws CoreException {
        Change change;
        CompositeChange change2 = (CompositeChange)this.fRefactoring.createChange(progressMonitor);
        CompilationUnitChange compilationUnitChange = new CompilationUnitChange(this.fName, this.fCompilationUnit);
        Change[] changes = change2.getChildren();
        if (changes.length == 1 && (change = changes[0]) instanceof TextChange) {
            void textChange;
            TextChange textChange2 = (TextChange)change;
            TextChange cfr_ignored_0 = (TextChange)change;
            compilationUnitChange.setEdit(textChange.getEdit());
            return compilationUnitChange;
        }
        return null;
    }

    @Override
    public String getDisplayString() {
        return this.fName;
    }

    @Override
    public String getAdditionalProposalInfo() {
        return null;
    }

    @Override
    public IStatus getStatus() {
        return null;
    }
}

