/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.internal.ui.palette.editparts.PinnablePaletteStackFigure;

public class PaletteContainerFlowLayout
extends FlowLayout {
    public PaletteContainerFlowLayout() {
    }

    public PaletteContainerFlowLayout(boolean isHorizontal) {
        this.setHorizontal(isHorizontal);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Dimension prefSize = super.calculatePreferredSize(container, wHint, hHint);
        Dimension expandedPaneSize = null;
        for (IFigure child : container.getChildren()) {
            if (!(child instanceof PinnablePaletteStackFigure) || !((PinnablePaletteStackFigure)child).isExpanded()) continue;
            if (wHint > -1) {
                wHint = Math.max(0, wHint - container.getInsets().getWidth());
            }
            if (hHint > -1) {
                hHint = Math.max(0, hHint - container.getInsets().getHeight());
            }
            if (this.isHorizontal()) {
                hHint = -1;
            } else {
                wHint = -1;
            }
            expandedPaneSize = ((PinnablePaletteStackFigure)child).getExpandedContainerPreferredSize(wHint, hHint);
            break;
        }
        if (expandedPaneSize != null) {
            prefSize.height += this.transposer.t(expandedPaneSize).height;
            prefSize.union(this.getBorderPreferredSize(container));
        }
        return prefSize;
    }

    protected Dimension getChildSize(IFigure child, int wHint, int hHint) {
        if (child instanceof PinnablePaletteStackFigure) {
            return ((PinnablePaletteStackFigure)child).getHeaderPreferredSize(wHint, hHint);
        }
        return child.getPreferredSize(wHint, hHint);
    }

    protected void layoutRow(IFigure parent) {
        int majorAdjustment = 0;
        int minorAdjustment = 0;
        int correctMajorAlignment = this.majorAlignment;
        int correctMinorAlignment = this.minorAlignment;
        majorAdjustment = this.data.area.width - this.data.rowWidth + this.getMinorSpacing();
        switch (correctMajorAlignment) {
            case 1: {
                majorAdjustment = 0;
                break;
            }
            case 0: {
                majorAdjustment /= 2;
                break;
            }
        }
        int expandedPaneHeight = 0;
        int j = 0;
        while (j < this.data.rowCount) {
            if (this.fill) {
                this.data.bounds[j].height = this.data.rowHeight;
            } else {
                minorAdjustment = this.data.rowHeight - this.data.bounds[j].height;
                switch (correctMinorAlignment) {
                    case 1: {
                        minorAdjustment = 0;
                        break;
                    }
                    case 0: {
                        minorAdjustment /= 2;
                        break;
                    }
                }
                this.data.bounds[j].y += minorAdjustment;
            }
            this.data.bounds[j].x += majorAdjustment;
            IFigure child = this.data.row[j];
            this.setBoundsOfChild(parent, this.data.row[j], this.transposer.t(this.data.bounds[j]));
            if (child instanceof PinnablePaletteStackFigure && ((PinnablePaletteStackFigure)child).isExpanded()) {
                int wHint = -1;
                int hHint = -1;
                if (this.isHorizontal()) {
                    wHint = parent.getClientArea().width;
                } else {
                    hHint = parent.getClientArea().height;
                }
                expandedPaneHeight = ((PinnablePaletteStackFigure)child).getExpandedContainerPreferredSize((int)wHint, (int)hHint).height;
                child.setBounds(new Rectangle(this.data.area.x, this.data.area.y + this.data.rowY, this.data.area.width, this.data.rowHeight + expandedPaneHeight));
            }
            ++j;
        }
        this.data.rowY += this.getMajorSpacing() + this.data.rowHeight + expandedPaneHeight;
        this.initRow();
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        if (child instanceof PinnablePaletteStackFigure && ((PinnablePaletteStackFigure)child).isExpanded()) {
            parent.getClientArea(Rectangle.SINGLETON);
            bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
            ((PinnablePaletteStackFigure)child).setHeaderBoundsLayoutHint(bounds);
        } else {
            super.setBoundsOfChild(parent, child, bounds);
        }
    }
}

