/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORevisionDelta;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.lm.LMFactory;
import org.eclipse.emf.cdo.lm.LMPackage;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.ModuleType;
import org.eclipse.emf.cdo.lm.Process;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.modules.ModuleDefinition;
import org.eclipse.emf.cdo.lm.modules.ModulesFactory;
import org.eclipse.emf.cdo.lm.server.bundle.OM;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.security.Realm;
import org.eclipse.emf.cdo.security.Role;
import org.eclipse.emf.cdo.security.User;
import org.eclipse.emf.cdo.server.CDOServerUtil;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.ITransaction;
import org.eclipse.emf.cdo.server.security.SecurityManagerUtil;
import org.eclipse.emf.cdo.server.spi.security.InternalSecurityManager;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.spi.server.InternalCommitContext;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.jvm.IJVMAcceptor;
import org.eclipse.net4j.jvm.IJVMConnector;
import org.eclipse.net4j.jvm.JVMUtil;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.RunnableWithException;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.PasswordCredentials;
import org.eclipse.net4j.util.security.PasswordCredentialsProvider;
import org.eclipse.net4j.util.security.SecurityUtil;

public abstract class AbstractLifecycleManager
extends Lifecycle
implements LMPackage.Literals {
    private static final String ACCEPTOR_NAME = "local";
    private static final boolean SECURITY_AVAILABLE;
    private static final boolean CREATE_TEST_USER;
    private IManagedContainer container;
    private IJVMAcceptor acceptor;
    private IJVMConnector connector;
    private String systemName;
    private InternalRepository systemRepository;
    private CDOSession systemSession;
    private String moduleDefinitionPath;
    private final Map<String, InternalRepository> moduleRepositories = new HashMap<String, InternalRepository>();
    private final Map<String, CDOSession> moduleSessions = new HashMap<String, CDOSession>();
    private final IRepository.WriteAccessHandler writeAccessHandler = new IRepository.WriteAccessHandler(){

        public void handleTransactionBeforeCommitting(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) throws RuntimeException {
            AbstractLifecycleManager.this.handleCommit(commitContext);
        }

        public void handleTransactionAfterCommitted(ITransaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) {
        }
    };
    private Consumer<Process> processInitializer;
    private SecuritySupport securitySupport = SecuritySupport.UNAVAILABLE;

    static {
        boolean securityAvailable;
        CREATE_TEST_USER = OMPlatform.INSTANCE.isProperty("AbstractLifecycleManager.CREATE_TEST_USER");
        try {
            securityAvailable = CommonPlugin.loadClass((String)"org.eclipse.emf.cdo.server.security", (String)"org.eclipse.emf.cdo.server.security.ISecurityManager") != null;
        }
        catch (Throwable ex) {
            securityAvailable = false;
        }
        SECURITY_AVAILABLE = securityAvailable;
    }

    public IManagedContainer getContainer() {
        return this.container;
    }

    public final IJVMConnector getConnector() {
        return this.connector;
    }

    public InternalRepository getSystemRepository() {
        return this.systemRepository;
    }

    public void setSystemRepository(InternalRepository repository) {
        this.checkInactive();
        this.container = repository.getContainer();
        this.systemRepository = repository;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.checkInactive();
        this.systemName = systemName;
    }

    public Consumer<Process> getProcessInitializer() {
        return this.processInitializer;
    }

    public void setProcessInitializer(Consumer<Process> processInitializer) {
        this.processInitializer = processInitializer;
    }

    public String getModuleDefinitionPath() {
        return this.moduleDefinitionPath == null ? "module.md" : this.moduleDefinitionPath;
    }

    public void setModuleDefinitionPath(String moduleDefinitionPath) {
        this.checkInactive();
        this.moduleDefinitionPath = CDOURIUtil.sanitizePath((String)moduleDefinitionPath);
    }

    public final Map<String, InternalRepository> getModuleRepositories() {
        return this.moduleRepositories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CDOSession getModuleSession(final String moduleName) {
        Map<String, CDOSession> map = this.moduleSessions;
        synchronized (map) {
            InternalRepository repository;
            CDOSession session = this.moduleSessions.get(moduleName);
            if (session == null && (repository = this.moduleRepositories.get(moduleName)) != null) {
                session = this.openModuleSession(repository);
                session.addListener((IListener)new LifecycleEventAdapter(){

                    protected void onDeactivated(ILifecycle lifecycle) {
                        if (AbstractLifecycleManager.this.isActive()) {
                            AbstractLifecycleManager.this.moduleSessions.remove(moduleName);
                        }
                    }
                });
                this.moduleSessions.put(moduleName, session);
            }
            return session;
        }
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.systemRepository, "systemRepository");
        this.checkState(this.systemName, "systemName");
        if (SECURITY_AVAILABLE) {
            String moduleDefinitionPath = this.getModuleDefinitionPath();
            this.securitySupport = new SecuritySupport.Available(this.systemRepository, moduleDefinitionPath);
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.acceptor = JVMUtil.getAcceptor((IManagedContainer)this.container, (String)ACCEPTOR_NAME);
        this.connector = JVMUtil.getConnector((IManagedContainer)this.container, (String)ACCEPTOR_NAME);
        CDONet4jSessionConfiguration sessionConfiguration = this.createSessionConfiguration(this.systemRepository.getName());
        this.systemSession = sessionConfiguration.openNet4jSession();
        ArrayList moduleInfos = new ArrayList();
        this.initSystemRepository(this.systemSession, (moduleName, moduleTypeName) -> {
            boolean bl = moduleInfos.add(Pair.create((Object)moduleName, (Object)moduleTypeName));
        });
        for (Pair info : moduleInfos) {
            String moduleName2 = (String)info.getElement1();
            String moduleTypeName2 = (String)info.getElement2();
            this.addModule(moduleName2, moduleTypeName2);
        }
        this.systemRepository.addHandler((IRepository.Handler)this.writeAccessHandler);
    }

    protected void doDeactivate() throws Exception {
        this.systemRepository.removeHandler((IRepository.Handler)this.writeAccessHandler);
        LifecycleUtil.deactivate((Object)this.systemSession);
        AbstractLifecycleManager.deactivate(this.moduleSessions);
        AbstractLifecycleManager.deactivate(this.moduleRepositories);
        LifecycleUtil.deactivate((Object)this.connector);
        LifecycleUtil.deactivate((Object)this.acceptor);
        super.doDeactivate();
    }

    protected void initSystemRepository(CDOSession session, BiConsumer<String, String> moduleInfoComsumer) throws Exception {
        try (CDOTransaction transaction = session.openTransaction();){
            System system = null;
            CDOResource resource = transaction.getOrCreateResource("/system");
            EList contents = resource.getContents();
            if (contents.isEmpty()) {
                OM.LOG.info("Initializing system resource");
                Process process = LMFactory.eINSTANCE.createProcess();
                process.setModuleDefinitionPath(this.getModuleDefinitionPath());
                process.setInitialModuleVersion(Version.createOSGi((int)0, (int)1, (int)0));
                this.initProcess(process);
                system = LMFactory.eINSTANCE.createSystem();
                system.setName(this.systemName);
                system.setProcess(process);
                contents.add((Object)system);
                transaction.setCommitComment("<initialize system>");
                transaction.commit();
            } else {
                String name;
                EObject root = (EObject)contents.get(0);
                if (root instanceof System && !Objects.equals(name = (system = (System)root).getName(), this.systemName)) {
                    throw new IllegalStateException("System name '" + name + "' does not match configured name '" + this.systemName + "'");
                }
            }
            if (system == null) {
                throw new IllegalStateException("System resource does not contain a system");
            }
            for (Module module : system.getModules()) {
                String moduleName = module.getName();
                ModuleType moduleType = module.getType();
                String moduleTypeName = moduleType == null ? null : moduleType.getName();
                moduleInfoComsumer.accept(moduleName, moduleTypeName);
            }
        }
    }

    protected void initProcess(Process process) {
        if (this.processInitializer != null) {
            this.processInitializer.accept(process);
        } else {
            Map<String, Boolean> dropTypes;
            List<String> moduleTypes = this.getInitialModuleTypes();
            if (!ObjectUtil.isEmpty(moduleTypes)) {
                moduleTypes.forEach(arg_0 -> ((Process)process).addModuleType(arg_0));
            }
            if (!ObjectUtil.isEmpty(dropTypes = this.getInitialDropTypes())) {
                dropTypes.forEach((arg_0, arg_1) -> ((Process)process).addDropType(arg_0, arg_1));
            }
        }
    }

    protected List<String> getInitialModuleTypes() {
        return Collections.emptyList();
    }

    protected Map<String, Boolean> getInitialDropTypes() {
        return Collections.emptyMap();
    }

    protected void handleCommit(IStoreAccessor.CommitContext commitContext) {
        InternalCDORevisionDelta[] dirtyObjectDeltas = commitContext.getDirtyObjectDeltas();
        if (dirtyObjectDeltas != null) {
            ArrayList<ModuleInfo> newModules = new ArrayList<ModuleInfo>();
            int i = 0;
            while (i < dirtyObjectDeltas.length) {
                InternalCDORevisionDelta revisionDelta = dirtyObjectDeltas[i];
                EClass eClass = revisionDelta.getEClass();
                if (eClass == SYSTEM) {
                    AbstractLifecycleManager.handleListDelta(commitContext, revisionDelta, SYSTEM__MODULES, addedModule -> this.handleModuleAddition((InternalCDORevision)addedModule, newModules::add), removeModuleDelta -> this.handleModuleDeletion(commitContext, revisionDelta, (CDORemoveFeatureDelta)removeModuleDelta));
                } else if (eClass == MODULE) {
                    CDOFeatureDelta featureDelta = revisionDelta.getFeatureDelta((EStructuralFeature)MODULE__NAME);
                    if (featureDelta != null) {
                        throw new CDOException("Renaming modules is not supported");
                    }
                } else if (eClass == STREAM) {
                    AbstractLifecycleManager.handleListDelta(commitContext, revisionDelta, STREAM__CONTENTS, addedContent -> this.handleBaselineAddition(commitContext, (InternalCDORevision)addedContent), removeFeatureDelta -> this.handleBaselineDeletion(commitContext, (CDORevisionDelta)revisionDelta, (CDORemoveFeatureDelta)removeFeatureDelta));
                }
                ++i;
            }
            this.createNewModuleInfos(commitContext, newModules);
        }
    }

    protected void handleModuleAddition(InternalCDORevision addedModule, Consumer<ModuleInfo> newModulesInfoConsumer) {
        String moduleName = (String)addedModule.get((EStructuralFeature)MODULE__NAME, 0);
        if (!this.isValidModuleName(moduleName)) {
            throw new CDOException("Module name is invalid: " + moduleName);
        }
        if (this.moduleRepositories.containsKey(moduleName)) {
            throw new CDOException("Module name is not unique: " + moduleName);
        }
        CDOID moduleTypeID = (CDOID)addedModule.getValue((EStructuralFeature)MODULE__TYPE);
        CDOID initialStreamID = null;
        CDOList streams = addedModule.getListOrNull((EStructuralFeature)MODULE__STREAMS);
        if (streams != null && !streams.isEmpty()) {
            initialStreamID = (CDOID)streams.get(0);
        }
        newModulesInfoConsumer.accept(new ModuleInfo(moduleName, moduleTypeID, initialStreamID));
    }

    protected void handleModuleDeletion(IStoreAccessor.CommitContext commitContext, InternalCDORevisionDelta systemRevisionDelta, CDORemoveFeatureDelta removeModuleDelta) {
        CDOID systemID = systemRevisionDelta.getID();
        int index = removeModuleDelta.getIndex();
        InternalCDORevision systemRevision = (InternalCDORevision)commitContext.getOldRevisions().get(systemID);
        CDOID removedID = (CDOID)systemRevision.get((EStructuralFeature)SYSTEM__MODULES, index);
        InternalCDORevision[] internalCDORevisionArray = ((InternalCommitContext)commitContext).getDetachedRevisions();
        int n = internalCDORevisionArray.length;
        int n2 = 0;
        while (n2 < n) {
            InternalCDORevision revision = internalCDORevisionArray[n2];
            if (revision.getID() == removedID) {
                String moduleName = (String)revision.get((EStructuralFeature)MODULE__NAME, 0);
                CDOSession session = this.moduleSessions.remove(moduleName);
                LifecycleUtil.deactivate((Object)session);
                InternalRepository repository = this.moduleRepositories.remove(moduleName);
                LifecycleUtil.deactivate((Object)repository);
                break;
            }
            ++n2;
        }
    }

    protected void handleBaselineAddition(IStoreAccessor.CommitContext commitContext, InternalCDORevision addedContent) {
    }

    protected void handleBaselineDeletion(IStoreAccessor.CommitContext commitContext, CDORevisionDelta revisionDelta, CDORemoveFeatureDelta removeFeatureDelta) {
    }

    protected void createNewModuleInfos(IStoreAccessor.CommitContext commitContext, List<ModuleInfo> newModules) {
        for (ModuleInfo newModule : newModules) {
            try {
                String moduleTypeName;
                Version initialModuleVersion;
                String moduleName = newModule.getModuleName();
                CDOID moduleTypeID = newModule.getModuleTypeID();
                CDOID initialStreamID = newModule.getInitialStreamID();
                try (CDOView systemView = this.systemSession.openView();){
                    CDOResource systemResource = systemView.getResource("/system");
                    System system = (System)systemResource.getContents().get(0);
                    Process process = system.getProcess();
                    initialModuleVersion = process.getInitialModuleVersion();
                    ModuleType moduleType = moduleTypeID == null ? null : (ModuleType)systemView.getObject(moduleTypeID);
                    moduleTypeName = moduleType == null ? null : moduleType.getName();
                }
                this.createNewModule(moduleName, moduleTypeName);
                CDOSession moduleSession = this.getModuleSession(moduleName);
                try (CDOTransaction moduleTransaction = moduleSession.openTransaction();){
                    if (moduleTransaction.hasResource(this.moduleDefinitionPath)) continue;
                    ModuleDefinition moduleDefinition = ModulesFactory.eINSTANCE.createModuleDefinition();
                    moduleDefinition.setName(moduleName);
                    moduleDefinition.setVersion(initialModuleVersion);
                    CDOResource moduleDefinitionResource = moduleTransaction.createResource(this.moduleDefinitionPath);
                    moduleDefinitionResource.getContents().add((Object)moduleDefinition);
                    moduleTransaction.commit();
                    long creationTime = moduleSession.getRepositoryInfo().getCreationTime();
                    commitContext.modify(context -> {
                        for (CDOIDAndVersion newObject : context.getChangeSetData().getNewObjects()) {
                            if (newObject.getID() != initialStreamID) continue;
                            InternalCDORevision streamRevision = (InternalCDORevision)newObject;
                            streamRevision.set((EStructuralFeature)STREAM__START_TIME_STAMP, 0, (Object)creationTime);
                        }
                    });
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    protected void createNewModule(String moduleName, String moduleTypeName) throws Exception {
        this.addModule(moduleName, moduleTypeName);
    }

    protected boolean isValidModuleName(String moduleName) {
        if (moduleName == null) {
            return false;
        }
        String trimmed = moduleName.trim();
        if (!Objects.equals(trimmed, moduleName)) {
            return false;
        }
        return trimmed.length() != 0;
    }

    protected void addModule(String moduleName, String moduleTypeName) throws Exception {
        RunnableWithException.forkAndWait(() -> {
            OM.LOG.info("Adding module " + moduleName + " to system " + this.systemName);
            InternalRepository moduleRepository = this.createModuleRepository(moduleName);
            CDOServerUtil.addRepository((IManagedContainer)this.container, (IRepository)moduleRepository);
            this.securitySupport.addModuleRepository(moduleRepository, moduleName, moduleTypeName);
            this.moduleRepositories.put(moduleName, moduleRepository);
        });
    }

    protected abstract InternalRepository createModuleRepository(String var1) throws CoreException;

    protected CDONet4jSession openModuleSession(InternalRepository moduleRepository) {
        CDONet4jSessionConfiguration configuration = this.createSessionConfiguration(moduleRepository.getName());
        configuration.setSignalTimeout(Integer.MAX_VALUE);
        CDONet4jSession session = configuration.openNet4jSession();
        session.options().setCommitTimeout(Integer.MAX_VALUE);
        return session;
    }

    protected CDONet4jSessionConfiguration createSessionConfiguration(String repositoryName) {
        CDONet4jSessionConfiguration configuration = CDONet4jUtil.createNet4jSessionConfiguration();
        configuration.setConnector((IConnector)this.connector);
        configuration.setRepositoryName(repositoryName);
        IPasswordCredentials credentials = this.securitySupport.getCredentials();
        if (credentials != null) {
            configuration.setCredentialsProvider((IPasswordCredentialsProvider)new PasswordCredentialsProvider(credentials));
        }
        return configuration;
    }

    private <R> R executeAgainstModuleSession(IStoreAccessor.CommitContext commitContext, CDOID moduleID, final Function<CDOSession, R> function) {
        CDORevision module = commitContext.getRevision(moduleID);
        String moduleName = (String)module.data().get((EStructuralFeature)MODULE__NAME, 0);
        final CDOSession moduleSession = this.getModuleSession(moduleName);
        final Throwable[] exception = new Throwable[1];
        final AtomicReference result = new AtomicReference();
        Thread thread = new Thread(function.getClass().getName()){

            @Override
            public void run() {
                try {
                    Object value = function.apply(moduleSession);
                    result.set(value);
                }
                catch (Error | RuntimeException ex) {
                    exception[0] = ex;
                }
            }
        };
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException ex) {
            thread.interrupt();
            throw WrappedException.wrap((Exception)ex);
        }
        if (exception[0] instanceof RuntimeException) {
            throw (RuntimeException)exception[0];
        }
        if (exception[0] instanceof Error) {
            throw (Error)exception[0];
        }
        return (R)result.get();
    }

    private static void handleListDelta(IStoreAccessor.CommitContext commitContext, InternalCDORevisionDelta revisionDelta, EReference reference, Consumer<InternalCDORevision> additionConsumer, Consumer<CDORemoveFeatureDelta> removalConsumer) {
        CDOListFeatureDelta listDelta = (CDOListFeatureDelta)revisionDelta.getFeatureDelta((EStructuralFeature)reference);
        if (listDelta != null) {
            for (CDOFeatureDelta featureDelta : listDelta.getListChanges()) {
                if (removalConsumer != null && featureDelta instanceof CDORemoveFeatureDelta) {
                    CDORemoveFeatureDelta removeDelta = (CDORemoveFeatureDelta)featureDelta;
                    removalConsumer.accept(removeDelta);
                    continue;
                }
                if (additionConsumer == null || !(featureDelta instanceof CDOAddFeatureDelta)) continue;
                CDOAddFeatureDelta addDelta = (CDOAddFeatureDelta)featureDelta;
                CDOID id = (CDOID)addDelta.getValue();
                InternalCDORevision revision = (InternalCDORevision)commitContext.getRevision(id);
                additionConsumer.accept(revision);
            }
        }
    }

    private static void deactivate(Map<String, ?> map) {
        for (Object value : map.values()) {
            LifecycleUtil.deactivate(value);
        }
        map.clear();
    }

    public static CDOBranchRef getBranch(CDORevision floatingBaseline) {
        String branchPath = null;
        EClass eClass = floatingBaseline.getEClass();
        if (eClass == STREAM) {
            branchPath = (String)floatingBaseline.data().get((EStructuralFeature)STREAM__MAINTENANCE_BRANCH, 0);
            if (branchPath == null) {
                branchPath = (String)floatingBaseline.data().get((EStructuralFeature)STREAM__DEVELOPMENT_BRANCH, 0);
            }
        } else if (eClass == CHANGE) {
            branchPath = (String)floatingBaseline.data().get((EStructuralFeature)CHANGE__BRANCH, 0);
        }
        if (branchPath == null) {
            return null;
        }
        return new CDOBranchRef(branchPath);
    }

    @Deprecated
    protected List<String> initSystemRepository(CDOSession session) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void handleModuleAddition(InternalCDORevision addedModule, List<Pair<String, CDOID>> newModules) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void createNewModules(IStoreAccessor.CommitContext commitContext, List<Pair<String, CDOID>> newModules) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void createNewModule(String moduleName) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected void addModule(String moduleName) throws Exception {
        throw new UnsupportedOperationException();
    }

    public static abstract class Factory
    extends org.eclipse.net4j.util.factory.Factory {
        public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.lm.server.lifecycleManagers";

        protected Factory(String type) {
            super(PRODUCT_GROUP, type);
        }

        public abstract AbstractLifecycleManager create(String var1) throws ProductCreationException;

        public static AbstractLifecycleManager get(IManagedContainer container, String type, String description) {
            return (AbstractLifecycleManager)((Object)container.getElementOrNull(PRODUCT_GROUP, type, description));
        }
    }

    public static final class ModuleInfo {
        private final String moduleName;
        private final CDOID moduleTypeID;
        private final CDOID initialStreamID;

        private ModuleInfo(String moduleName, CDOID moduleTypeID, CDOID initialStreamID) {
            this.moduleName = moduleName;
            this.moduleTypeID = moduleTypeID;
            this.initialStreamID = initialStreamID;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        public CDOID getModuleTypeID() {
            return this.moduleTypeID;
        }

        public CDOID getInitialStreamID() {
            return this.initialStreamID;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ModuleInfo[moduleName=");
            builder.append(this.moduleName);
            builder.append(", moduleTypeID=");
            builder.append(this.moduleTypeID);
            builder.append(", initialStreamID=");
            builder.append(this.initialStreamID);
            builder.append("]");
            return builder.toString();
        }
    }

    private static interface SecuritySupport {
        public static final SecuritySupport UNAVAILABLE = new SecuritySupport(){

            @Override
            public IPasswordCredentials getCredentials() {
                return null;
            }

            @Override
            public void addModuleRepository(InternalRepository moduleRepository, String moduleName, String moduleTypeName) {
            }
        };

        public IPasswordCredentials getCredentials();

        public void addModuleRepository(InternalRepository var1, String var2, String var3);

        public static final class Available
        implements SecuritySupport {
            private static final String USER_NAME = "Lifecycle Manager";
            private static final String ROLE_NAME = "Lifecycle Management";
            private static final char[] KEY = new char[]{'c', 'd', 'o', ' ', 'r', 'o', 'c', 'k', 's', ' ', '(', 'e', 's', ')'};
            private final InternalSecurityManager securityManager;
            private final IPasswordCredentials credentials;

            public Available(InternalRepository systemRepository, String moduleDefinitionPath) {
                this.securityManager = (InternalSecurityManager)SecurityManagerUtil.getSecurityManager((IRepository)systemRepository);
                if (this.securityManager != null) {
                    byte[] bytes;
                    String uuid = systemRepository.getUUID();
                    try {
                        bytes = SecurityUtil.pbeEncrypt((byte[])uuid.getBytes(), (char[])KEY, (String)"PBEWithMD5AndDES", (byte[])SecurityUtil.DEFAULT_SALT, (int)20);
                    }
                    catch (Exception ex) {
                        OM.LOG.error((Throwable)ex);
                        bytes = new String(KEY).getBytes();
                    }
                    String hex = HexUtil.bytesToHex((byte[])bytes);
                    this.credentials = new PasswordCredentials(USER_NAME, SecurityUtil.toCharArray((String)hex));
                    this.securityManager.modify(realm -> {
                        User stepper;
                        Role administrationRole;
                        User lmUser;
                        Role lmRole = realm.getRole(ROLE_NAME);
                        if (lmRole == null) {
                            lmRole = SecurityManagerUtil.addResourceRole((Realm)realm, (String)ROLE_NAME, (String)"/system", (boolean)true);
                            SecurityManagerUtil.addResourcePermissions((Role)lmRole, (String)moduleDefinitionPath, (boolean)false);
                        }
                        if ((lmUser = realm.getUser(this.credentials.getUserID())) == null) {
                            Role normalObjectsWriter;
                            lmUser = realm.addUser(this.credentials);
                            lmUser.getRoles().add((Object)lmRole);
                            Role allObjectsReader = realm.getRole("All Objects Reader");
                            if (allObjectsReader != null) {
                                lmUser.getRoles().add((Object)allObjectsReader);
                            }
                            if ((normalObjectsWriter = realm.getRole("Normal Objects Writer")) != null) {
                                lmUser.getRoles().add((Object)normalObjectsWriter);
                            }
                        }
                        if ((administrationRole = realm.getRole("Administration")) != null) {
                            SecurityManagerUtil.addResourcePermissions((Role)administrationRole, (String)"/system", (boolean)false);
                        }
                        if (CREATE_TEST_USER && (stepper = realm.getUser("Stepper")) == null) {
                            stepper = realm.addUser((IPasswordCredentials)new PasswordCredentials("Stepper", "xxx"));
                            stepper.getRoles().add((Object)lmRole);
                            stepper.getRoles().add((Object)realm.getRole("Administration"));
                        }
                    });
                } else {
                    this.credentials = null;
                }
            }

            @Override
            public IPasswordCredentials getCredentials() {
                return this.credentials;
            }

            @Override
            public void addModuleRepository(InternalRepository moduleRepository, String moduleName, String moduleTypeName) {
                if (this.securityManager != null) {
                    HashMap<String, String> authorizationContext = new HashMap<String, String>();
                    authorizationContext.put("moduleName", moduleName);
                    if (moduleTypeName != null) {
                        authorizationContext.put("moduleTypeName", moduleTypeName);
                    }
                    this.securityManager.addSecondaryRepository(moduleRepository, authorizationContext);
                }
            }
        }
    }
}

