/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.ILabelUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.LabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDeltaVisitor;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelProxy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class TreeModelLabelProvider
extends ColumnLabelProvider
implements ITreeModelLabelProvider,
IModelChangedListener {
    private IInternalTreeModelViewer fViewer;
    private List<ILabelUpdate> fComplete;
    private Map<ImageDescriptor, Image> fImageCache = new HashMap<ImageDescriptor, Image>();
    private Map<FontData, Font> fFontCache = new HashMap<FontData, Font>();
    private Map<RGB, Color> fColorCache = new HashMap<RGB, Color>();
    private ListenerList<ILabelUpdateListener> fLabelListeners = new ListenerList();
    private Map<IElementLabelProvider, List<ILabelUpdate>> fPendingUpdates = new HashMap<IElementLabelProvider, List<ILabelUpdate>>();
    private Runnable fPendingUpdatesRunnable;
    private List<ILabelUpdate> fUpdatesInProgress = new ArrayList<ILabelUpdate>();
    private CancelPendingUpdatesVisitor fCancelPendingUpdatesVisitor = new CancelPendingUpdatesVisitor();

    public TreeModelLabelProvider(IInternalTreeModelViewer viewer) {
        this.fViewer = viewer;
        this.fViewer.addModelChangedListener(this);
    }

    @Override
    public Image getImage(ImageDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Image image = this.fImageCache.get(descriptor);
        if (image == null) {
            image = new Image((Device)this.getDisplay(), descriptor.getImageData());
            this.fImageCache.put(descriptor, image);
        }
        return image;
    }

    private Display getDisplay() {
        return this.fViewer.getDisplay();
    }

    @Override
    public Font getFont(FontData fontData) {
        if (fontData == null) {
            return null;
        }
        Font font = this.fFontCache.get(fontData);
        if (font == null) {
            font = new Font((Device)this.getDisplay(), fontData);
            this.fFontCache.put(fontData, font);
        }
        return font;
    }

    @Override
    public Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        Color color = this.fColorCache.get(rgb);
        if (color == null) {
            color = new Color((Device)this.getDisplay(), rgb);
            this.fColorCache.put(rgb, color);
        }
        return color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Assert.isTrue((this.fViewer.getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        this.fViewer.removeModelChangedListener(this);
        this.fViewer = null;
        List<ILabelUpdate> complete = null;
        TreeModelLabelProvider treeModelLabelProvider = this;
        synchronized (treeModelLabelProvider) {
            complete = this.fComplete;
            this.fComplete = null;
        }
        if (complete != null) {
            for (ILabelUpdate iLabelUpdate : complete) {
                iLabelUpdate.cancel();
            }
        }
        for (ILabelUpdate iLabelUpdate : this.fUpdatesInProgress) {
            iLabelUpdate.cancel();
        }
        if (this.fPendingUpdatesRunnable != null) {
            this.fPendingUpdatesRunnable = null;
        }
        for (List list : this.fPendingUpdates.values()) {
            for (ILabelUpdate update : list) {
                update.cancel();
            }
        }
        this.fPendingUpdates.clear();
        for (Image image : this.fImageCache.values()) {
            image.dispose();
        }
        this.fImageCache.clear();
        for (Font font : this.fFontCache.values()) {
            font.dispose();
        }
        this.fFontCache.clear();
        for (Color color : this.fColorCache.values()) {
            color.dispose();
        }
        this.fColorCache.clear();
        super.dispose();
    }

    private boolean isDisposed() {
        return this.fViewer == null;
    }

    public void update(ViewerCell cell) {
    }

    @Override
    public boolean update(TreePath elementPath) {
        Assert.isTrue((this.fViewer.getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        this.cancelPathUpdates(elementPath);
        String[] visibleColumns = this.fViewer.getVisibleColumns();
        Object element = elementPath.getLastSegment();
        IElementLabelProvider presentation = ViewerAdapterService.getLabelProvider(element);
        if (presentation != null) {
            List<ILabelUpdate> updates = this.fPendingUpdates.get(presentation);
            if (updates == null) {
                updates = new LinkedList<ILabelUpdate>();
                this.fPendingUpdates.put(presentation, updates);
            }
            updates.add(new LabelUpdate(this.fViewer.getInput(), elementPath, this, visibleColumns, this.fViewer.getPresentationContext()));
            this.fPendingUpdatesRunnable = new Runnable(){

                @Override
                public void run() {
                    if (TreeModelLabelProvider.this.isDisposed()) {
                        return;
                    }
                    TreeModelLabelProvider.this.startRequests(this);
                }
            };
            this.fViewer.getDisplay().asyncExec(this.fPendingUpdatesRunnable);
            return true;
        }
        return false;
    }

    private void cancelPathUpdates(TreePath elementPath) {
        Assert.isTrue((this.fViewer.getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        for (ILabelUpdate currentUpdate : this.fUpdatesInProgress) {
            if (!elementPath.equals((Object)currentUpdate.getElementPath())) continue;
            currentUpdate.cancel();
        }
    }

    void setElementData(TreePath path, int numColumns, String[] labels, ImageDescriptor[] images, FontData[] fontDatas, RGB[] foregrounds, RGB[] backgrounds, boolean checked, boolean grayed) {
        this.fViewer.setElementData(path, numColumns, labels, images, fontDatas, foregrounds, backgrounds);
        this.fViewer.setElementChecked(path, checked, grayed);
    }

    private void startRequests(Runnable runnable) {
        if (runnable != this.fPendingUpdatesRunnable) {
            return;
        }
        if (!this.fPendingUpdates.isEmpty()) {
            List<ILabelUpdate> list = null;
            for (Map.Entry<IElementLabelProvider, List<ILabelUpdate>> entry : this.fPendingUpdates.entrySet()) {
                list = entry.getValue();
                for (ILabelUpdate update : list) {
                    this.updateStarted(update);
                }
                entry.getKey().update(list.toArray(new ILabelUpdate[list.size()]));
            }
        }
        this.fPendingUpdates.clear();
        this.fPendingUpdatesRunnable = null;
    }

    private void cancelElementUpdates(Object element, boolean searchFullPath) {
        block0: for (ILabelUpdate currentUpdate : this.fUpdatesInProgress) {
            if (searchFullPath) {
                if (element.equals(this.fViewer.getInput())) {
                    currentUpdate.cancel();
                    continue;
                }
                TreePath updatePath = currentUpdate.getElementPath();
                int i = 0;
                while (i < updatePath.getSegmentCount()) {
                    if (element.equals(updatePath.getSegment(i))) {
                        currentUpdate.cancel();
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            if (!element.equals(currentUpdate.getElement())) continue;
            currentUpdate.cancel();
        }
    }

    private IPresentationContext getPresentationContext() {
        return this.fViewer.getPresentationContext();
    }

    synchronized void complete(ILabelUpdate update) {
        if (this.fViewer == null) {
            return;
        }
        if (this.fComplete == null) {
            this.fComplete = new LinkedList<ILabelUpdate>();
            this.fViewer.getDisplay().asyncExec(() -> {
                if (this.isDisposed()) {
                    return;
                }
                List<ILabelUpdate> updates = null;
                TreeModelLabelProvider treeModelLabelProvider = this;
                synchronized (treeModelLabelProvider) {
                    updates = this.fComplete;
                    this.fComplete = null;
                }
                for (ILabelUpdate itrUpdate : updates) {
                    if (itrUpdate.isCanceled()) {
                        this.updateComplete(itrUpdate);
                        continue;
                    }
                    ((LabelUpdate)itrUpdate).performUpdate();
                }
            });
        }
        this.fComplete.add(update);
    }

    @Override
    public void addLabelUpdateListener(ILabelUpdateListener listener) {
        this.fLabelListeners.add((Object)listener);
    }

    @Override
    public void removeLabelUpdateListener(ILabelUpdateListener listener) {
        this.fLabelListeners.remove((Object)listener);
    }

    void updateStarted(ILabelUpdate update) {
        Assert.isTrue((this.fViewer.getDisplay().getThread() == Thread.currentThread() ? 1 : 0) != 0);
        boolean begin = this.fUpdatesInProgress.isEmpty();
        this.fUpdatesInProgress.add(update);
        if (begin) {
            if (DebugUIPlugin.DEBUG_UPDATE_SEQUENCE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace("LABEL SEQUENCE BEGINS");
            }
            this.notifyUpdate(0, null);
        }
        if (DebugUIPlugin.DEBUG_UPDATE_SEQUENCE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            DebugUIPlugin.trace("\tBEGIN - " + String.valueOf(update));
        }
        this.notifyUpdate(2, update);
    }

    void updateComplete(ILabelUpdate update) {
        this.fUpdatesInProgress.remove(update);
        if (DebugUIPlugin.DEBUG_UPDATE_SEQUENCE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
            DebugUIPlugin.trace("\tEND - " + String.valueOf(update));
        }
        this.notifyUpdate(3, update);
        if (this.fUpdatesInProgress.isEmpty()) {
            if (DebugUIPlugin.DEBUG_UPDATE_SEQUENCE && DebugUIPlugin.DEBUG_TEST_PRESENTATION_ID(this.getPresentationContext())) {
                DebugUIPlugin.trace("LABEL SEQUENCE ENDS");
            }
            this.notifyUpdate(1, null);
        }
    }

    private void notifyUpdate(final int type, final ILabelUpdate update) {
        if (!this.fLabelListeners.isEmpty()) {
            Iterator iterator = this.fLabelListeners.iterator();
            while (iterator.hasNext()) {
                ILabelUpdateListener iLabelUpdateListener;
                final ILabelUpdateListener listener = iLabelUpdateListener = (ILabelUpdateListener)iterator.next();
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        switch (type) {
                            case 0: {
                                listener.labelUpdatesBegin();
                                break;
                            }
                            case 1: {
                                listener.labelUpdatesComplete();
                                break;
                            }
                            case 2: {
                                listener.labelUpdateStarted(update);
                                break;
                            }
                            case 3: {
                                listener.labelUpdateComplete(update);
                                break;
                            }
                        }
                    }

                    public void handleException(Throwable exception) {
                        DebugUIPlugin.log(exception);
                    }
                });
            }
        }
    }

    @Override
    public void modelChanged(IModelDelta delta, IModelProxy proxy) {
        delta.accept(this.fCancelPendingUpdatesVisitor);
    }

    class CancelPendingUpdatesVisitor
    implements IModelDeltaVisitor {
        CancelPendingUpdatesVisitor() {
        }

        @Override
        public boolean visit(IModelDelta delta, int depth) {
            if ((delta.getFlags() & 0x400) > 0) {
                TreeModelLabelProvider.this.cancelElementUpdates(delta.getElement(), true);
                return false;
            }
            if ((delta.getFlags() & 0x800) > 0) {
                TreeModelLabelProvider.this.cancelElementUpdates(delta.getElement(), false);
                return true;
            }
            return true;
        }
    }
}

