/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.Preferences;
import org.eclipse.debug.internal.ui.AbstractDebugCheckboxSelectionDialog;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchCategoryFilter;
import org.eclipse.debug.internal.ui.preferences.BooleanFieldEditor2;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class LaunchConfigurationsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ProgressMonitorPart fMonitor;
    private Button fMigrateNow;
    private List<FieldEditor> fFieldEditors;
    private Button fDeleteConfigs;
    private Table fTable;

    public LaunchConfigurationsPreferencePage() {
        this.setPreferenceStore(DebugUIPlugin.getDefault().getPreferenceStore());
        this.setTitle(DebugPreferencesMessages.LaunchConfigurationsPreferencePage_1);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.debug.ui.launch_configuration_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        this.fFieldEditors = new ArrayList<FieldEditor>();
        Composite comp = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 768);
        Group group = SWTFactory.createGroup(comp, DebugPreferencesMessages.LaunchingPreferencePage_32, 1, 1, 768);
        Composite spacer = SWTFactory.createComposite((Composite)group, group.getFont(), 1, 1, 768);
        BooleanFieldEditor edit = new BooleanFieldEditor("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_CLOSED", DebugPreferencesMessages.LaunchingPreferencePage_33, 0, spacer);
        this.fFieldEditors.add((FieldEditor)edit);
        edit = new BooleanFieldEditor("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_DELETED", DebugPreferencesMessages.LaunchingPreferencePage_34, 0, spacer);
        this.fFieldEditors.add((FieldEditor)edit);
        edit = new BooleanFieldEditor("org.eclipse.debug.ui.PREF_FILTER_WORKING_SETS", DebugPreferencesMessages.LaunchConfigurationsPreferencePage_3, 0, spacer);
        this.fFieldEditors.add((FieldEditor)edit);
        this.fDeleteConfigs = SWTFactory.createCheckButton(comp, DebugPreferencesMessages.LaunchConfigurationsPreferencePage_2, null, false, 3);
        this.createTypeFiltering((Composite)group);
        group = SWTFactory.createGroup(comp, DebugPreferencesMessages.LaunchingPreferencePage_35, 1, 1, 768);
        Label label = new Label((Composite)group, 16448);
        GridData gd = new GridData(768);
        gd.widthHint = 350;
        label.setLayoutData((Object)gd);
        label.setText(DebugPreferencesMessages.LaunchingPreferencePage_26);
        label.setFont(parent.getFont());
        this.fMigrateNow = SWTFactory.createPushButton((Composite)group, DebugPreferencesMessages.LaunchingPreferencePage_27, null);
        gd = new GridData(1);
        this.fMigrateNow.setLayoutData((Object)gd);
        this.fMigrateNow.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                LaunchConfigurationsPreferencePage.this.handleMigrateNowSelected();
            }
        });
        this.initFieldEditors();
        this.fTable.setEnabled(this.getPreferenceStore().getBoolean("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_TYPES"));
        return comp;
    }

    private Composite createTypeFiltering(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 768);
        BooleanFieldEditor2 editor = new BooleanFieldEditor2("org.eclipse.debug.ui.PREF_FILTER_LAUNCH_TYPES", DebugPreferencesMessages.LaunchConfigurationsPreferencePage_0, 0, comp);
        editor.setPropertyChangeListener(event -> {
            boolean newvalue = false;
            newvalue = event.getNewValue() instanceof Boolean ? (Boolean)event.getNewValue() : Boolean.parseBoolean(event.getNewValue().toString());
            if (newvalue) {
                this.fTable.setEnabled(true);
            } else {
                this.fTable.setEnabled(false);
            }
        });
        this.fFieldEditors.add((FieldEditor)editor);
        this.fTable = new Table(comp, 2080);
        GridData gd = new GridData(768);
        gd.heightHint = 155;
        this.fTable.setLayoutData((Object)gd);
        CheckboxTableViewer tviewer = new CheckboxTableViewer(this.fTable);
        tviewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        tviewer.setContentProvider((IContentProvider)new TableContentProvider());
        tviewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        tviewer.addFilter((ViewerFilter)new LaunchCategoryFilter("org.eclipse.ui.externaltools.builder"));
        tviewer.setInput((Object)this.getLaunchConfigurationTypes());
        this.fTable.setFont(parent.getFont());
        return comp;
    }

    private ILaunchConfigurationType[] getLaunchConfigurationTypes() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
    }

    private void handleMigrateNowSelected() {
        try {
            ILaunchManager lmanager = DebugPlugin.getDefault().getLaunchManager();
            Object[] configurations = lmanager.getMigrationCandidates();
            ArrayList<ILaunchConfiguration> pub = new ArrayList<ILaunchConfiguration>();
            Object[] objectArray = configurations;
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = objectArray[n2];
                if (DebugUITools.isPrivate(configuration)) {
                    configuration.migrate();
                } else {
                    pub.add(configuration);
                }
                ++n2;
            }
            if (pub.isEmpty()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)DebugPreferencesMessages.LaunchingPreferencePage_29, (String)DebugPreferencesMessages.LaunchingPreferencePage_30);
                return;
            }
            LaunchConfigurationMigrationSelectionDialog listd = new LaunchConfigurationMigrationSelectionDialog(this.getShell(), new AdaptableList(pub));
            listd.setTitle(DebugPreferencesMessages.LaunchingPreferencePage_28);
            listd.setInitialSelections(configurations);
            if (listd.open() == 0) {
                this.fMonitor = new ProgressMonitorPart(this.fMigrateNow.getParent(), (Layout)new GridLayout());
                Object[] objs = listd.getResult();
                this.fMonitor.beginTask(DebugPreferencesMessages.LaunchingPreferencePage_31, objs.length);
                Object[] objectArray2 = objs;
                int n3 = objs.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object obj = objectArray2[n4];
                    if (obj instanceof ILaunchConfiguration) {
                        ((ILaunchConfiguration)obj).migrate();
                    }
                    this.fMonitor.worked(1);
                    ++n4;
                }
                this.fMonitor.done();
                this.fMonitor.dispose();
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
    }

    public void init(IWorkbench workbench) {
    }

    private void initFieldEditors() {
        for (FieldEditor editor : this.fFieldEditors) {
            editor.setPreferenceStore(this.getPreferenceStore());
            editor.load();
        }
        this.fDeleteConfigs.setSelection(Platform.getPreferencesService().getBoolean(DebugPlugin.getUniqueIdentifier(), "org.eclipse.debug.core.PREF_DELETE_CONFIGS_ON_PROJECT_DELETE", true, null));
        TableItem[] items = this.fTable.getItems();
        String[] stringArray = this.getPreferenceStore().getString("org.eclipse.debug.ui.PREF_FILTER_TYPE_LIST").split("\\,");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            TableItem[] tableItemArray = items;
            int n3 = items.length;
            int n4 = 0;
            while (n4 < n3) {
                TableItem item = tableItemArray[n4];
                ILaunchConfigurationType type = (ILaunchConfigurationType)item.getData();
                if (type.getIdentifier().equals(t)) {
                    item.setChecked(true);
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void performDefaults() {
        this.fDeleteConfigs.setSelection(Preferences.getDefaultBoolean((String)DebugPlugin.getUniqueIdentifier(), (String)"org.eclipse.debug.core.PREF_DELETE_CONFIGS_ON_PROJECT_DELETE", (boolean)true));
        for (FieldEditor editor : this.fFieldEditors) {
            editor.loadDefault();
            if (!(editor instanceof BooleanFieldEditor2)) continue;
            this.fTable.setEnabled(((BooleanFieldEditor2)editor).getBooleanValue());
        }
    }

    public boolean performOk() {
        for (FieldEditor editor : this.fFieldEditors) {
            editor.store();
        }
        Preferences.setBoolean((String)DebugPlugin.getUniqueIdentifier(), (String)"org.eclipse.debug.core.PREF_DELETE_CONFIGS_ON_PROJECT_DELETE", (boolean)this.fDeleteConfigs.getSelection(), null);
        Object types = "";
        TableItem[] tableItemArray = this.fTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                ILaunchConfigurationType type = (ILaunchConfigurationType)item.getData();
                types = (String)types + type.getIdentifier() + ",";
            }
            ++n2;
        }
        this.getPreferenceStore().setValue("org.eclipse.debug.ui.PREF_FILTER_TYPE_LIST", (String)types);
        return super.performOk();
    }

    class LaunchConfigurationMigrationSelectionDialog
    extends AbstractDebugCheckboxSelectionDialog {
        private Object fInput;

        public LaunchConfigurationMigrationSelectionDialog(Shell parentShell, Object input) {
            super(parentShell);
            this.fInput = input;
            this.setShellStyle(this.getShellStyle() | 0x10);
        }

        @Override
        protected String getDialogSettingsId() {
            return "org.eclipse.debug.ui.MIGRATION_SELECTION_DIALOG";
        }

        @Override
        protected String getHelpContextId() {
            return "org.eclipse.debug.ui.select_launch_configuration_migration_dialog";
        }

        @Override
        protected Object getViewerInput() {
            return this.fInput;
        }

        @Override
        protected String getViewerLabel() {
            return DebugPreferencesMessages.LaunchingPreferencePage_0;
        }

        @Override
        protected IContentProvider getContentProvider() {
            return new WorkbenchContentProvider();
        }

        @Override
        protected IBaseLabelProvider getLabelProvider() {
            return DebugUITools.newDebugModelPresentation();
        }
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return LaunchConfigurationsPreferencePage.this.getLaunchConfigurationTypes();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

