/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.dialogs;

import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.DriverValidator;
import org.eclipse.datatools.connectivity.drivers.IDriverValuesProvider;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.DriversProvider;
import org.eclipse.datatools.connectivity.drivers.models.OverrideTemplateDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.DriverTreeContentProvider;
import org.eclipse.datatools.connectivity.internal.ui.DriverTreeFilter;
import org.eclipse.datatools.connectivity.internal.ui.DriverTreeLabelProvider;
import org.eclipse.datatools.help.ContextProviderDelegate;
import org.eclipse.datatools.help.HelpUtil;
import org.eclipse.help.IContext;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewDriverDialog
extends TitleAreaDialog {
    public static final String MEMENTO_ROOT = "Drivers New Driver_Dialog_Root";
    public static final String MEMENTO_DIALOG_SIZE_HEIGHT = "Dialog_Size_Height";
    public static final String MEMENTO_DIALOG_SIZE_WIDTH = "Dialog_Size_Width";
    public static final String MEMENTO_DIALOG_EDIT_IMMEDIATELY = "Edit Immediately";
    private Shell shell;
    private TreeViewer mTreeViewer;
    private Text mDriverNameText;
    private Button mEditImmediatelyButton;
    private Button mOKButton;
    private DriverTreeFilter mViewerFilter;
    private TemplateDescriptor mDriverTemplateDescriptor = null;
    private IPropertySet mPropertySet = null;
    private String mDriverName;
    private boolean mEditImmediately = true;
    private String mErrorMessage = null;
    private ContextProviderDelegate contextProviderDelegate = new ContextProviderDelegate(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName());

    public NewDriverDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x860);
    }

    public NewDriverDialog(Shell parentShell, String category) {
        this(parentShell);
        if (CategoryDescriptor.getCategoryDescriptor((String)category) != null) {
            this.mViewerFilter = new DriverTreeFilter();
            this.mViewerFilter.setCategoryId(category);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setData(HelpUtil.CONTEXT_PROVIDER_KEY, (Object)this);
        HelpUtil.setHelp((Control)this.getShell(), (String)HelpUtil.getContextId((String)"CONTEXT_ID_NEW_DRIVER_DIALOG", (String)ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName()));
        Font font = parent.getFont();
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        contents.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NewDriverDialog.this.saveState();
            }
        });
        Label label = new Label(contents, 16384);
        label.setText(DriverMgmtMessages.getString((String)"NewDriverDialog.label.availableTemplates"));
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setFont(font);
        this.mTreeViewer = new TreeViewer(contents, 2048);
        data = new GridData(1808);
        this.mTreeViewer.getTree().setLayoutData((Object)data);
        this.mTreeViewer.getTree().setFont(font);
        this.mTreeViewer.setContentProvider((IContentProvider)new DriverTreeContentProvider(true));
        this.mTreeViewer.setLabelProvider((IBaseLabelProvider)new DriverTreeLabelProvider());
        if (this.mViewerFilter != null) {
            this.mTreeViewer.addFilter((ViewerFilter)this.mViewerFilter);
        }
        this.mTreeViewer.setInput((Object)DriversProvider.getInstance());
        this.mTreeViewer.expandToLevel(3);
        this.mTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)NewDriverDialog.this.mTreeViewer.getSelection();
                if (selection.getFirstElement() instanceof TemplateDescriptor) {
                    TemplateDescriptor descriptor = (TemplateDescriptor)selection.getFirstElement();
                    String name = descriptor.getDefaultDefinitionName();
                    IDriverValuesProvider driverValsProvider = null;
                    IDriverValuesProvider overrideDriverValsProvider = null;
                    OverrideTemplateDescriptor[] otds = null;
                    if (descriptor != null) {
                        otds = OverrideTemplateDescriptor.getByDriverTemplate((String)descriptor.getId());
                        if (otds != null && otds.length > 0) {
                            overrideDriverValsProvider = otds[0].getValuesProviderClass();
                        }
                        driverValsProvider = descriptor.getValuesProviderClass();
                    }
                    if (driverValsProvider != null) {
                        String driverValsDefaultDefinitionName;
                        String driverValsName = driverValsProvider.createDefaultValue("name");
                        if (driverValsName != null) {
                            name = driverValsName;
                        }
                        if ((driverValsDefaultDefinitionName = driverValsProvider.createDefaultValue("defaultDefinitionName")) != null) {
                            name = driverValsDefaultDefinitionName;
                        }
                    }
                    if (overrideDriverValsProvider != null) {
                        String overrideDriverValsDefaultDefinitionName;
                        String overrideDriverValsName = overrideDriverValsProvider.createDefaultValue("name");
                        if (overrideDriverValsName != null) {
                            name = overrideDriverValsName;
                        }
                        if ((overrideDriverValsDefaultDefinitionName = overrideDriverValsProvider.createDefaultValue("defaultDefinitionName")) != null) {
                            name = overrideDriverValsDefaultDefinitionName;
                        }
                    }
                    NewDriverDialog.this.mDriverNameText.setText(name);
                    NewDriverDialog.this.mDriverTemplateDescriptor = descriptor;
                    if (!NewDriverDialog.this.needEditImmediately(descriptor)) {
                        NewDriverDialog.this.mEditImmediatelyButton.setEnabled(false);
                        NewDriverDialog.this.mEditImmediatelyButton.setSelection(false);
                    } else {
                        NewDriverDialog.this.mEditImmediatelyButton.setEnabled(true);
                        NewDriverDialog.this.mEditImmediatelyButton.setSelection(NewDriverDialog.this.mEditImmediately);
                    }
                }
                NewDriverDialog.this.validateName();
            }
        });
        this.mTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                StructuredSelection selection = (StructuredSelection)NewDriverDialog.this.mTreeViewer.getSelection();
                if (selection.getFirstElement() instanceof TemplateDescriptor && NewDriverDialog.this.mErrorMessage == null) {
                    NewDriverDialog.this.okPressed();
                }
            }
        });
        label = new Label(contents, 0);
        label.setText(DriverMgmtMessages.getString((String)"NewDriverDialog.label.driverNameText"));
        this.mDriverNameText = new Text(contents, 2048);
        this.mDriverNameText.setLayoutData((Object)new GridData(768));
        this.mDriverNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewDriverDialog.this.mDriverName = NewDriverDialog.this.mDriverNameText.getText();
                NewDriverDialog.this.validateName();
            }
        });
        this.mEditImmediatelyButton = new Button(contents, 32);
        this.mEditImmediatelyButton.setText(DriverMgmtMessages.getString((String)"NewDriverDialog.button.edit_immediately"));
        this.mEditImmediatelyButton.setSelection(true);
        this.mEditImmediatelyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NewDriverDialog.this.mEditImmediately = NewDriverDialog.this.mEditImmediatelyButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.setTitle(DriverMgmtMessages.getString((String)"NewDriverDialog.title"));
        this.setMessage(DriverMgmtMessages.getString((String)"NewDriverDialog.message"));
        this.getEditImmediatelyState();
        this.mEditImmediatelyButton.setSelection(this.mEditImmediately);
        return area;
    }

    private void validateName() {
        String errorMessage;
        boolean isOk = false;
        String testName = this.mDriverName;
        DriverInstance obj = DriverManager.getInstance().getDriverInstanceByName(testName);
        if (obj == null) {
            isOk = true;
            this.setErrorMessage(null);
            this.mErrorMessage = null;
        } else {
            isOk = false;
            errorMessage = DriverMgmtMessages.getString((String)"NewDriverDialog.driverExistsWithName");
            this.setErrorMessage(errorMessage);
            this.mErrorMessage = errorMessage;
        }
        if (testName != null && (testName.startsWith(" ") || testName.endsWith(" "))) {
            isOk = false;
            errorMessage = DriverMgmtMessages.getString((String)"NewDriverDialog.driverNameNoSpaces");
            this.setErrorMessage(errorMessage);
            this.mErrorMessage = errorMessage;
        }
        StructuredSelection selection = (StructuredSelection)this.mTreeViewer.getSelection();
        boolean isOkSelection = false;
        isOkSelection = selection.getFirstElement() instanceof TemplateDescriptor;
        this.mOKButton.setEnabled(isOk && isOkSelection);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.mOKButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.mOKButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void configureShell(Shell newShell) {
        IDialogSettings dSection;
        super.configureShell(newShell);
        this.shell = newShell;
        int width = 400;
        int height = 500;
        newShell.setText(DriverMgmtMessages.getString((String)"NewDriverDialog.windowTitle"));
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        if (dset != null && (dSection = dset.getSection(MEMENTO_ROOT)) != null && dSection.get(MEMENTO_DIALOG_SIZE_HEIGHT) != null && dSection.get(MEMENTO_DIALOG_SIZE_HEIGHT).trim().length() > 0) {
            height = dSection.getInt(MEMENTO_DIALOG_SIZE_HEIGHT);
            width = dSection.getInt(MEMENTO_DIALOG_SIZE_WIDTH);
        }
        this.shell.setSize(width, height);
        this.centerDialog(newShell);
    }

    private void centerDialog(Shell newShell) {
        Composite parent = newShell.getParent();
        Rectangle parentSize = parent.getBounds();
        Rectangle newShellSize = newShell.getBounds();
        int x = (parentSize.width - newShellSize.width) / 2 + parentSize.x;
        int y = (parentSize.height - newShellSize.height) / 2 + parentSize.y;
        newShell.setLocation(new Point(x, y));
    }

    public boolean getEditImmediately() {
        return this.mEditImmediately;
    }

    public TemplateDescriptor getDriverTypeDescriptor() {
        return this.mDriverTemplateDescriptor;
    }

    public IPropertySet getNewDriverInstance() {
        return this.mPropertySet;
    }

    protected void okPressed() {
        if (this.mDriverTemplateDescriptor != null) {
            String propId = String.valueOf(DriverMgmtMessages.getString((String)"NewDriverDialog.text.id_prefix")) + this.mDriverName;
            if (this.mPropertySet == null) {
                DriverInstance newDriver = DriverManager.getInstance().createNewDriverInstance(this.mDriverTemplateDescriptor.getId(), this.mDriverName.trim(), null);
                this.mPropertySet = newDriver.getPropertySet();
            }
            this.mPropertySet.setID(propId);
        }
        this.mEditImmediately = this.mEditImmediatelyButton.getSelection();
        super.okPressed();
    }

    protected void cancelPressed() {
        if (this.mPropertySet != null) {
            DriverValidator.removeOldProblemMarkers((String)this.mPropertySet.getName());
        }
        super.cancelPressed();
    }

    public CategoryDescriptor getCategoryDescriptor() {
        if (this.mDriverTemplateDescriptor != null) {
            CategoryDescriptor category = CategoryDescriptor.getCategoryDescriptor((String)this.mDriverTemplateDescriptor.getParentCategory());
            return category;
        }
        return null;
    }

    private void saveState() {
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        if (dset != null) {
            IDialogSettings dSection = dset.getSection(MEMENTO_ROOT);
            if (dSection == null) {
                dSection = dset.addNewSection(MEMENTO_ROOT);
            }
            if (dSection != null) {
                Point size = this.getShell().getSize();
                dSection.put(MEMENTO_DIALOG_SIZE_HEIGHT, size.y);
                dSection.put(MEMENTO_DIALOG_SIZE_WIDTH, size.x);
                dSection.put(MEMENTO_DIALOG_EDIT_IMMEDIATELY, this.mEditImmediately);
            }
        }
    }

    private void getEditImmediatelyState() {
        IDialogSettings dSection;
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        if (dset != null && (dSection = dset.getSection(MEMENTO_ROOT)) != null && dSection.get(MEMENTO_DIALOG_EDIT_IMMEDIATELY) != null) {
            this.mEditImmediately = dSection.getBoolean(MEMENTO_DIALOG_EDIT_IMMEDIATELY);
        }
    }

    protected boolean needEditImmediately(TemplateDescriptor descriptor) {
        return !descriptor.getEmptyJarListIsOKFlag() || descriptor.hasVisibleProperties();
    }

    public IContext getContext(Object target) {
        return this.contextProviderDelegate.getContext(target);
    }

    public int getContextChangeMask() {
        return this.contextProviderDelegate.getContextChangeMask();
    }

    public String getSearchExpression(Object target) {
        return this.contextProviderDelegate.getSearchExpression(target);
    }
}

