/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.jobs.Deadlock;
import org.eclipse.core.internal.jobs.DeadlockDetector;
import org.eclipse.core.internal.jobs.OrderedLock;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.LockListener;

public class LockManager {
    protected volatile LockListener lockListener;
    private DeadlockDetector locks = new DeadlockDetector();
    private final Map<Thread, Deque<LockState[]>> suspendedLocks = new HashMap<Thread, Deque<LockState[]>>();

    public void aboutToRelease() {
        if (this.lockListener == null) {
            return;
        }
        try {
            this.lockListener.aboutToRelease();
        }
        catch (Exception | LinkageError e) {
            LockManager.handleException(e);
        }
    }

    public boolean canBlock() {
        if (this.lockListener == null) {
            return true;
        }
        try {
            return this.lockListener.canBlock();
        }
        catch (Exception | LinkageError e) {
            LockManager.handleException(e);
            return false;
        }
    }

    public boolean aboutToWait(Thread lockOwner) {
        if (this.lockListener == null) {
            return false;
        }
        try {
            return this.lockListener.aboutToWait(lockOwner);
        }
        catch (Exception | LinkageError e) {
            LockManager.handleException(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLockThread(Thread thread, ISchedulingRule lock) {
        DeadlockDetector tempLocks = this.locks;
        if (tempLocks == null) {
            return;
        }
        try {
            DeadlockDetector deadlockDetector = tempLocks;
            synchronized (deadlockDetector) {
                try {
                    tempLocks.lockAcquired(thread, lock);
                }
                catch (Exception e) {
                    throw this.createDebugException(tempLocks, e);
                }
            }
        }
        catch (Exception e) {
            this.handleInternalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLockWaitThread(Thread thread, ISchedulingRule lock) {
        DeadlockDetector tempLocks = this.locks;
        if (tempLocks == null) {
            return;
        }
        try {
            Deadlock found = null;
            DeadlockDetector deadlockDetector = tempLocks;
            synchronized (deadlockDetector) {
                try {
                    found = tempLocks.lockWaitStart(thread, lock);
                }
                catch (Exception e) {
                    throw this.createDebugException(tempLocks, e);
                }
            }
            if (found == null) {
                return;
            }
            ISchedulingRule[] toSuspend = found.getLocks();
            LockState[] suspended = new LockState[toSuspend.length];
            int i = 0;
            while (i < toSuspend.length) {
                suspended[i] = LockState.suspend((OrderedLock)toSuspend[i]);
                ++i;
            }
            Map<Thread, Deque<LockState[]>> map = this.suspendedLocks;
            synchronized (map) {
                this.suspendedLocks.computeIfAbsent(found.getCandidate(), key -> new ArrayDeque()).push(suspended);
            }
        }
        catch (Exception e) {
            this.handleInternalError(e);
        }
    }

    private Exception createDebugException(DeadlockDetector tempLocks, Exception rootException) {
        String debugString = null;
        try {
            debugString = tempLocks.toDebugString();
        }
        catch (Exception exception) {}
        return new Exception(debugString, rootException);
    }

    private static void handleException(Throwable e) {
        MultiStatus status;
        if (e instanceof CoreException) {
            status = new MultiStatus("org.eclipse.core.jobs", 2, "LockManager.handleException", e);
            status.merge(((CoreException)e).getStatus());
        } else {
            status = new Status(4, "org.eclipse.core.jobs", 2, "LockManager.handleException", e);
        }
        RuntimeLog.log((IStatus)status);
    }

    private void handleInternalError(Throwable t) {
        try {
            LockManager.handleException(t);
        }
        catch (Exception exception) {}
        this.locks = null;
    }

    public boolean isEmpty() {
        return this.locks.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLockOwner() {
        Thread current = Thread.currentThread();
        if (current instanceof Worker) {
            return true;
        }
        DeadlockDetector tempLocks = this.locks;
        if (tempLocks == null) {
            return false;
        }
        DeadlockDetector deadlockDetector = tempLocks;
        synchronized (deadlockDetector) {
            return tempLocks.contains(Thread.currentThread());
        }
    }

    public synchronized OrderedLock newLock() {
        return new OrderedLock(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLockCompletely(Thread thread, ISchedulingRule rule) {
        DeadlockDetector tempLocks = this.locks;
        if (tempLocks == null) {
            return;
        }
        try {
            DeadlockDetector deadlockDetector = tempLocks;
            synchronized (deadlockDetector) {
                try {
                    tempLocks.lockReleasedCompletely(thread, rule);
                }
                catch (Exception e) {
                    throw this.createDebugException(tempLocks, e);
                }
            }
        }
        catch (Exception e) {
            this.handleInternalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLockThread(Thread thread, ISchedulingRule lock) {
        DeadlockDetector tempLocks = this.locks;
        if (tempLocks == null) {
            return;
        }
        try {
            DeadlockDetector deadlockDetector = tempLocks;
            synchronized (deadlockDetector) {
                try {
                    tempLocks.lockReleased(thread, lock);
                }
                catch (Exception e) {
                    throw this.createDebugException(tempLocks, e);
                }
            }
        }
        catch (Exception e) {
            this.handleInternalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeLockWaitThread(Thread thread, ISchedulingRule lock) {
        DeadlockDetector tempLocks = this.locks;
        if (tempLocks == null) {
            return;
        }
        try {
            DeadlockDetector deadlockDetector = tempLocks;
            synchronized (deadlockDetector) {
                try {
                    tempLocks.lockWaitStop(thread, lock);
                }
                catch (Exception e) {
                    throw this.createDebugException(tempLocks, e);
                }
            }
        }
        catch (Exception e) {
            this.handleInternalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resumeSuspendedLocks(Thread owner) {
        block3: while (true) {
            LockState[] toResume;
            Map<Thread, Deque<LockState[]>> map = this.suspendedLocks;
            synchronized (map) {
                Deque<LockState[]> prevLocks = this.suspendedLocks.get(owner);
                if (prevLocks == null) {
                    return;
                }
                toResume = prevLocks.pop();
                if (prevLocks.isEmpty()) {
                    this.suspendedLocks.remove(owner);
                }
            }
            LockState[] lockStateArray = toResume;
            int n = toResume.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block3;
                LockState element = lockStateArray[n2];
                if (!element.resume()) {
                    // empty if block
                }
                ++n2;
            }
            break;
        }
    }

    public void setLockListener(LockListener listener) {
        this.lockListener = listener;
    }

    private static class LockState {
        private int depth;
        private OrderedLock lock;

        private LockState() {
        }

        protected static LockState suspend(OrderedLock lock) {
            LockState state = new LockState();
            state.lock = lock;
            state.depth = lock.forceRelease();
            return state;
        }

        public boolean resume() {
            try {
                if (this.lock.acquire(Integer.MAX_VALUE, false)) {
                    this.lock.setDepth(this.depth);
                    return true;
                }
            }
            catch (InterruptedException interruptedException) {}
            return false;
        }
    }
}

