/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;
import org.eclipse.wst.jsdt.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class HandleFactory {
    private String lastPkgFragmentRootPath;
    private PackageFragmentRoot lastPkgFragmentRoot;
    private boolean lastIsFullPath;
    private HashtableOfArrayToObject packageHandles;
    private JavaModel javaModel = JavaModelManager.getJavaModelManager().getJavaModel();

    public Openable createOpenable(String resourcePath, IJavaScriptSearchScope scope) {
        Object[] pkgName;
        PackageFragmentRoot root;
        int separatorIndex = resourcePath.indexOf("|");
        if (separatorIndex > -1) {
            Object[] pkgName2;
            String classFilePath;
            String[] simpleNames;
            int length;
            int rootPathLength;
            if (this.lastPkgFragmentRootPath == null || (rootPathLength = this.lastPkgFragmentRootPath.length()) != resourcePath.length() || !resourcePath.regionMatches(0, this.lastPkgFragmentRootPath, 0, rootPathLength)) {
                String jarPath = resourcePath.substring(0, separatorIndex);
                PackageFragmentRoot root2 = (PackageFragmentRoot)this.getJarPkgFragmentRoot(jarPath, scope);
                if (root2 == null) {
                    return null;
                }
                this.lastPkgFragmentRootPath = jarPath;
                this.lastPkgFragmentRoot = root2;
                this.packageHandles = new HashtableOfArrayToObject(5);
            }
            if ((length = (simpleNames = new Path(classFilePath = resourcePath.substring(separatorIndex + 1)).segments()).length - 1) > 0) {
                pkgName2 = new String[length];
                System.arraycopy(simpleNames, 0, pkgName2, 0, length);
            } else {
                pkgName2 = CharOperation.NO_STRINGS;
            }
            IPackageFragment pkgFragment = (IPackageFragment)this.packageHandles.get(pkgName2);
            if (pkgFragment == null) {
                pkgFragment = this.lastPkgFragmentRoot.getPackageFragment((String[])pkgName2);
                this.packageHandles.put(pkgName2, pkgFragment);
            }
            IClassFile classFile = pkgFragment.getClassFile(simpleNames[length]);
            return (Openable)((Object)classFile);
        }
        if (resourcePath.endsWith("/")) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        if ((root = this.getPkgFragmentRoot(resourcePath)) instanceof LibraryFragmentRoot && !((LibraryFragmentRoot)root).isDirectory()) {
            return (Openable)((Object)((LibraryFragmentRoot)root).getPackageFragment(resourcePath).getClassFile(resourcePath));
        }
        if (root == null) {
            return null;
        }
        this.lastPkgFragmentRoot = root;
        this.lastPkgFragmentRootPath = this.lastIsFullPath ? this.lastPkgFragmentRoot.getLocation().toString() : this.lastPkgFragmentRoot.getPath().toString();
        this.packageHandles = new HashtableOfArrayToObject(5);
        String[] simpleNames = new Path(resourcePath = resourcePath.substring(this.lastPkgFragmentRootPath.length() + 1)).segments();
        int length = simpleNames.length - 1;
        if (length > 0) {
            pkgName = new String[length];
            System.arraycopy(simpleNames, 0, pkgName, 0, length);
        } else {
            pkgName = CharOperation.NO_STRINGS;
        }
        IPackageFragment pkgFragment = (IPackageFragment)this.packageHandles.get(pkgName);
        if (pkgFragment == null) {
            pkgFragment = this.lastPkgFragmentRoot.getPackageFragment((String[])pkgName);
            this.packageHandles.put(pkgName, pkgFragment);
        }
        String simpleName = simpleNames[length];
        if (pkgFragment.isSource() && !Util.isMetadataFileName(simpleName)) {
            IJavaScriptUnit unit = pkgFragment.getJavaScriptUnit(simpleName);
            return (Openable)((Object)unit);
        }
        IClassFile classFile = pkgFragment.getClassFile(simpleName);
        return (Openable)((Object)classFile);
    }

    public IJavaScriptElement createElement(ClassScope scope, IJavaScriptUnit unit, HashSet existingElements, HashMap knownScopes) {
        return this.createElement(scope, scope.referenceContext.sourceStart, unit, existingElements, knownScopes);
    }

    private IJavaScriptElement createElement(Scope scope, int elementPosition, IJavaScriptUnit unit, HashSet existingElements, HashMap knownScopes) {
        IJavaScriptElement newElement = (IJavaScriptElement)knownScopes.get(scope);
        if (newElement != null) {
            return newElement;
        }
        block0 : switch (scope.kind) {
            case 4: {
                newElement = unit;
                break;
            }
            case 3: {
                IJavaScriptElement parentElement = this.createElement(scope.parent, elementPosition, unit, existingElements, knownScopes);
                switch (parentElement.getElementType()) {
                    case 5: {
                        newElement = ((IJavaScriptUnit)parentElement).getType(new String(scope.enclosingSourceType().sourceName));
                        break;
                    }
                    case 7: {
                        newElement = ((IType)parentElement).getType(new String(scope.enclosingSourceType().sourceName));
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        IMember member = (IMember)parentElement;
                        if (member.isBinary()) {
                            return null;
                        }
                        newElement = member.getType(new String(scope.enclosingSourceType().sourceName), 1);
                        if (newElement == null) break;
                        while (!existingElements.add(newElement)) {
                            ++((SourceRefElement)newElement).occurrenceCount;
                        }
                        break;
                    }
                }
                if (newElement == null) break;
                knownScopes.put(scope, newElement);
                break;
            }
            case 2: {
                IType parentType = (IType)this.createElement(scope.parent, elementPosition, unit, existingElements, knownScopes);
                MethodScope methodScope = (MethodScope)scope;
                if (methodScope.isInsideInitializer()) {
                    TypeDeclaration type = methodScope.referenceType();
                    int occurenceCount = 1;
                    int i = 0;
                    int length = type.fields.length;
                    while (i < length) {
                        FieldDeclaration field = type.fields[i];
                        if (field.declarationSourceStart < elementPosition && field.declarationSourceEnd > elementPosition) {
                            switch (field.getKind()) {
                                case 1: {
                                    newElement = parentType.getField(new String(field.name));
                                    break;
                                }
                                case 2: {
                                    newElement = parentType.getInitializer(occurenceCount);
                                }
                            }
                            break block0;
                        }
                        if (field.getKind() == 2) {
                            ++occurenceCount;
                        }
                        ++i;
                    }
                    break;
                }
                AbstractMethodDeclaration method = methodScope.referenceMethod();
                newElement = parentType.getFunction(new String(method.getName()), Util.typeParameterSignatures(method));
                if (newElement == null) break;
                knownScopes.put(scope, newElement);
                break;
            }
            case 1: {
                newElement = this.createElement(scope.parent, elementPosition, unit, existingElements, knownScopes);
            }
        }
        return newElement;
    }

    private IPackageFragmentRoot getJarPkgFragmentRoot(String jarPathString, IJavaScriptSearchScope scope) {
        IJavaScriptProject[] projects;
        Path jarPath = new Path(jarPathString);
        Object target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IPath)jarPath, false);
        if (target instanceof IFile) {
            IFile jarFile = (IFile)target;
            JavaProject javaProject = (JavaProject)this.javaModel.getJavaProject((IResource)jarFile);
            try {
                IIncludePathEntry entry = javaProject.getClasspathEntryFor((IPath)jarPath);
                if (entry != null) {
                    return javaProject.getPackageFragmentRoot((IResource)jarFile);
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        if (scope != null) {
            IPackageFragmentRoot root;
            IPath[] enclosingProjectsAndJars = scope.enclosingProjectsAndJars();
            int length = enclosingProjectsAndJars.length;
            projects = new IJavaScriptProject[length];
            int index = 0;
            int i = 0;
            while (i < length) {
                IPath path = enclosingProjectsAndJars[i];
                if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(path.lastSegment())) {
                    projects[index++] = this.javaModel.getJavaScriptProject(path.segment(0));
                }
                ++i;
            }
            if (index < length) {
                IJavaScriptProject[] iJavaScriptProjectArray = projects;
                projects = new IJavaScriptProject[index];
                System.arraycopy(iJavaScriptProjectArray, 0, projects, 0, index);
            }
            if ((root = this.getJarPkgFragmentRoot((IPath)jarPath, target, projects)) != null) {
                return root;
            }
        }
        try {
            projects = this.javaModel.getJavaScriptProjects();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
        return this.getJarPkgFragmentRoot((IPath)jarPath, target, projects);
    }

    private IPackageFragmentRoot getJarPkgFragmentRoot(IPath jarPath, Object target, IJavaScriptProject[] projects) {
        int i = 0;
        int projectCount = projects.length;
        while (i < projectCount) {
            try {
                JavaProject javaProject = (JavaProject)projects[i];
                IIncludePathEntry classpathEntry = javaProject.getClasspathEntryFor(jarPath);
                if (classpathEntry != null) {
                    if (target instanceof IFile) {
                        return javaProject.getPackageFragmentRoot((IResource)((IFile)target));
                    }
                    return javaProject.getPackageFragmentRoot0(jarPath);
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            ++i;
        }
        return null;
    }

    private PackageFragmentRoot getPkgFragmentRoot(String pathString) {
        Path path = new Path(pathString);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.lastIsFullPath = false;
        int i = 0;
        int max = projects.length;
        while (i < max) {
            try {
                IProject project = projects[i];
                if (project.isAccessible() && project.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
                    IJavaScriptProject javaProject = this.javaModel.getJavaProject((IResource)project);
                    IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                    int j = 0;
                    int rootCount = roots.length;
                    while (j < rootCount) {
                        if (roots[j] instanceof PackageFragmentRoot) {
                            PackageFragmentRoot root = (PackageFragmentRoot)roots[j];
                            if (root.getPath().isPrefixOf((IPath)path) && !Util.isExcluded((IPath)path, root.fullInclusionPatternChars(), root.fullExclusionPatternChars(), false)) {
                                return root;
                            }
                            IPath rootLocation = root.getLocation();
                            if (rootLocation != null && !root.isExternal() && rootLocation.isPrefixOf((IPath)path) && !Util.isExcluded((IPath)path, root.fullInclusionPatternChars(), root.fullExclusionPatternChars(), false)) {
                                this.lastIsFullPath = true;
                                return root;
                            }
                        }
                        ++j;
                    }
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return null;
    }
}

