/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.model;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerFilterDefinition;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.event.ViatraQueryFilterSemantics;
import org.eclipse.viatra.transformation.views.traceability.generic.GenericReferencedQuerySpecification;

public final class EventFilterBuilder {
    private EventFilterBuilder() {
    }

    public static <T extends IPatternMatch> EventFilter<T> createEventFilter(ViewerFilterDefinition filterDefinition, GenericReferencedQuerySpecification specification) {
        if (filterDefinition.singleFilterMatch != null) {
            IPatternMatch singleFilterMatch = filterDefinition.singleFilterMatch;
            IPatternMatch newSingleFilterMatch = specification.createFromBaseMatch(singleFilterMatch);
            return Rules.newSingleMatchFilter((IPatternMatch)newSingleFilterMatch);
        }
        Collection<IPatternMatch> filterMatches = filterDefinition.filterMatches;
        ArrayList<IPatternMatch> newFilterMatches = new ArrayList<IPatternMatch>();
        for (IPatternMatch filterMatch : filterMatches) {
            IPatternMatch newFilterMatch = specification.createFromBaseMatch(filterMatch);
            newFilterMatches.add(newFilterMatch);
        }
        return Rules.newMultiMatchFilter(newFilterMatches, (ViatraQueryFilterSemantics)filterDefinition.semantics);
    }
}

