/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor.hover;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.internal.genericeditor.hover.CompositeInformationControlCreator;

public class CompositeInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2 {
    final LinkedHashMap<ITextHover, IInformationControlCreator> creators;
    LinkedHashMap<ITextHover, AbstractInformationControl> controls;
    private GridLayout layout;

    public CompositeInformationControl(Shell parentShell, LinkedHashMap<ITextHover, IInformationControlCreator> creators) {
        super(parentShell, EditorsUI.getTooltipAffordanceString(), true);
        Assert.isLegal((creators.size() > 1 ? 1 : 0) != 0, (String)"Do not compose a unique hover");
        this.creators = creators;
        this.create();
    }

    public boolean hasContents() {
        for (IInformationControl iInformationControl : this.controls.values()) {
            if (iInformationControl instanceof IInformationControlExtension) {
                if (!((IInformationControlExtension)iInformationControl).hasContents()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public void setInput(Object input) {
        int withContent = 0;
        Map inputs = (Map)input;
        for (Map.Entry entry : inputs.entrySet()) {
            AbstractInformationControl informationControl = this.controls.get(entry.getKey());
            if (informationControl == null) continue;
            if (informationControl instanceof IInformationControlExtension2) {
                ((IInformationControlExtension2)informationControl).setInput(entry.getValue());
            } else {
                String information = entry.getValue().toString();
                if (!information.isEmpty()) {
                    informationControl.setInformation(information);
                }
            }
            if (!informationControl.hasContents()) continue;
            ++withContent;
        }
        if (withContent > 1) {
            this.controls.values().forEach(control -> control.setStatusText(null));
            this.setStatusText(EditorsUI.getTooltipAffordanceString());
        } else {
            this.setStatusText(null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void createContent(Composite parent) {
        this.controls = new LinkedHashMap();
        this.layout = new GridLayout(1, false);
        parent.setLayout((Layout)this.layout);
        for (Map.Entry<ITextHover, IInformationControlCreator> hoverControlCreator : this.creators.entrySet()) {
            IInformationControl informationControl = hoverControlCreator.getValue().createInformationControl(parent.getShell());
            IInformationControl iInformationControl = informationControl;
            if (iInformationControl instanceof AbstractInformationControl) {
                void abstractInformationControl;
                AbstractInformationControl cfr_ignored_0 = (AbstractInformationControl)iInformationControl;
                AbstractInformationControl cfr_ignored_1 = (AbstractInformationControl)iInformationControl;
                List<Control> children = Arrays.asList(abstractInformationControl.getShell().getChildren());
                children.remove(parent);
                if (children.isEmpty()) continue;
                for (Control control : children) {
                    control.setParent(parent);
                }
                this.controls.put(hoverControlCreator.getKey(), (AbstractInformationControl)abstractInformationControl);
                continue;
            }
            GenericEditorPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.ui.genericeditor", "Only text hovers producing an AbstractInformationControl can be aggregated; got a " + informationControl.getClass().getSimpleName()));
            informationControl.dispose();
        }
    }

    public void dispose() {
        this.controls.values().forEach(IInformationControl::dispose);
        this.controls.clear();
        super.dispose();
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.controls.isEmpty()) {
            return null;
        }
        if (this.controls.size() == 1) {
            IInformationControl control = (IInformationControl)this.controls.values().iterator().next();
            if (control instanceof IInformationControlExtension5) {
                return ((IInformationControlExtension5)control).getInformationPresenterControlCreator();
            }
        } else {
            LinkedHashMap<ITextHover, IInformationControlCreator> presenterCreators = new LinkedHashMap<ITextHover, IInformationControlCreator>();
            boolean allNull = true;
            for (Map.Entry<ITextHover, AbstractInformationControl> hover : this.controls.entrySet()) {
                IInformationControlCreator creator = null;
                if (hover.getValue() instanceof IInformationControlExtension5) {
                    creator = ((IInformationControlExtension5)hover.getValue()).getInformationPresenterControlCreator();
                }
                if (creator == null) {
                    creator = this.creators.get(hover.getKey());
                } else {
                    allNull = false;
                }
                if (creator == null) continue;
                presenterCreators.put(hover.getKey(), creator);
            }
            if (allNull) {
                return null;
            }
            return new CompositeInformationControlCreator(presenterCreators);
        }
        return null;
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        return this.computeCompositeSize(ctrl -> ctrl.computeSizeConstraints(widthInChars, heightInChars), () -> super.computeSizeConstraints(widthInChars, heightInChars));
    }

    public Point computeSizeHint() {
        return this.computeCompositeSize(AbstractInformationControl::computeSizeHint, () -> this.getShell().computeSize(-1, -1, true));
    }

    private Point computeCompositeSize(Function<AbstractInformationControl, Point> computeSize, Supplier<Point> getDefault) {
        return this.controls.values().stream().map(computeSize).reduce((size1, size2) -> new Point(size1.x + size2.x, size1.y + size2.y + this.layout.verticalSpacing)).orElseGet(getDefault);
    }
}

