/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.render;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.SharedImages;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.render.RenderedImage;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image.ImageConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.factory.RenderedImageFactory;
import org.eclipse.gmf.runtime.draw2d.ui.render.internal.RenderedImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.ui.edit.internal.part.CommonEditPartOperation;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SVGImageRegistry;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusGraphicsSVG;
import org.eclipse.sirius.diagram.ui.tools.internal.render.SiriusRenderedMapModeGraphics;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.graphics.ImageData;
import org.w3c.dom.Element;

public class SiriusDiagramSVGGenerator
extends DiagramGenerator {
    public static final String ENABLE_EMBEDDED_SVG_IN_SVG_EXPORT = "org.eclipse.sirius.diagram.ui.enableEmbeddedSVGInSVGExport";
    private RenderedImage renderedImage = null;
    private Element svgRoot = null;
    private Rectangle viewBox = null;
    private boolean svgTraceability;
    private IFigure overlayFigure;

    public SiriusDiagramSVGGenerator(DiagramEditPart diagramEditPart, boolean svgTraceability) {
        super(diagramEditPart);
        if (diagramEditPart instanceof DDiagramEditPart) {
            this.overlayFigure = ((DDiagramEditPart)diagramEditPart).getOverlayFigure();
        }
        this.svgTraceability = svgTraceability;
    }

    protected Graphics setUpGraphics(int width, int height) {
        this.viewBox = new Rectangle(0, 0, width, height);
        return SiriusGraphicsSVG.getInstance(this.viewBox, this.svgTraceability);
    }

    protected ImageDescriptor getImageDescriptor(Graphics g) {
        try {
            SiriusGraphicsSVG svgG = (SiriusGraphicsSVG)g;
            this.svgRoot = svgG.getRoot();
            ByteArrayOutputStream os = new ByteArrayOutputStream(5000);
            this.stream(os);
            os.close();
            this.setRenderedImage(RenderedImageFactory.getInstance((byte[])os.toByteArray()));
            return RenderedImageDescriptor.createFromRenderedImage((RenderedImage)this.getRenderedImage());
        }
        catch (IOException ex) {
            Log.error((Plugin)DiagramUIRenderPlugin.getInstance(), (int)4, (String)ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public void stream(OutputStream outputStream) {
        try {
            this.svgRoot.setAttributeNS(null, "viewBox", String.valueOf(String.valueOf(this.viewBox.x)) + " " + String.valueOf(this.viewBox.y) + " " + String.valueOf(this.viewBox.width) + " " + String.valueOf(this.viewBox.height));
            EObject semanticRoot = ((DSemanticDiagram)this.getDiagramEditPart().resolveSemanticElement()).getTarget();
            this.svgRoot.setAttributeNS("http://www.eclipse.org/sirius/diagram/1.1.0", "diagram:semanticRoot", EcoreUtil.getURI((EObject)semanticRoot).toString());
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(this.svgRoot);
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(source, result);
        }
        catch (Exception ex) {
            Log.error((Plugin)DiagramUIRenderPlugin.getInstance(), (int)4, (String)ex.getMessage(), (Throwable)ex);
        }
    }

    public ImageDescriptor createSWTImageDescriptorForParts(List editparts, org.eclipse.swt.graphics.Rectangle sourceRect) {
        ImageDescriptor imageDesc = new ImageDescriptor(){

            public ImageData getImageData() {
                return SharedImages.get((String)"icons/error.gif").getImageData();
            }
        };
        Graphics graphics = null;
        try {
            IMapMode mm = this.getMapMode();
            PrecisionRectangle rect = new PrecisionRectangle();
            rect.setX(sourceRect.x);
            rect.setY(sourceRect.y);
            rect.setWidth(sourceRect.width);
            rect.setHeight(sourceRect.height);
            mm.LPtoDP((Translatable)rect);
            graphics = this.setUpGraphics((int)Math.round(rect.preciseWidth()), (int)Math.round(rect.preciseHeight()));
            SiriusRenderedMapModeGraphics mapModeGraphics = new SiriusRenderedMapModeGraphics(graphics, this.getMapMode());
            this.renderToGraphics((Graphics)mapModeGraphics, new Point(sourceRect.x, sourceRect.y), editparts);
            imageDesc = this.getImageDescriptor(graphics);
        }
        catch (Throwable throwable) {
            if (graphics != null) {
                this.disposeGraphics(graphics);
            }
            throw throwable;
        }
        if (graphics != null) {
            this.disposeGraphics(graphics);
        }
        return imageDesc;
    }

    protected void renderToGraphics(Graphics graphics, Point translateOffset, List editparts) {
        IFigure figure;
        graphics.translate(-translateOffset.x, -translateOffset.y);
        graphics.pushState();
        LinkedList<IGraphicalEditPart> connectionsToPaint = new LinkedList<IGraphicalEditPart>();
        Map decorations = this.findDecorations(editparts);
        ListIterator editPartsItr = editparts.listIterator();
        while (editPartsItr.hasNext()) {
            IGraphicalEditPart iGraphicalEditPart = (IGraphicalEditPart)editPartsItr.next();
            if (iGraphicalEditPart instanceof ConnectionEditPart) {
                connectionsToPaint.add(iGraphicalEditPart);
                continue;
            }
            connectionsToPaint.addAll(this.findConnectionsToPaint(iGraphicalEditPart));
            figure = iGraphicalEditPart.getFigure();
            this.setCurrentId(graphics, (GraphicalEditPart)iGraphicalEditPart);
            this.paintFigure(graphics, figure);
            this.paintDecorations(graphics, figure, decorations);
            this.resetCurrentId(graphics);
        }
        decorations = this.findDecorations(connectionsToPaint);
        for (GraphicalEditPart graphicalEditPart : connectionsToPaint) {
            this.setCurrentId(graphics, graphicalEditPart);
            figure = graphicalEditPart.getFigure();
            this.paintFigure(graphics, figure);
            this.paintDecorations(graphics, figure, decorations);
            this.resetCurrentId(graphics);
        }
        if (this.overlayFigure != null) {
            this.paintFigure(graphics, this.overlayFigure);
        }
        if (SiriusDiagramSVGGenerator.isEmbeddedSVGinSVGExportEnabled() && SVGImageRegistry.hasReferencedImages()) {
            if (graphics instanceof SiriusRenderedMapModeGraphics && ((SiriusRenderedMapModeGraphics)graphics).getGraphics() instanceof SiriusGraphicsSVG) {
                SVGImageRegistry.getURLs().forEach(url -> {
                    Optional<String> uuid = SVGImageRegistry.getUUID(url);
                    if (uuid.isPresent()) {
                        ((SiriusRenderedMapModeGraphics)graphics).drawSymbolSVGImage((String)url, uuid.get());
                    }
                });
            }
            SVGImageRegistry.reset();
        }
    }

    private void resetCurrentId(Graphics gfx) {
        CommonEditPartOperation.setGraphicsTraceabilityId(gfx, null);
    }

    private void setCurrentId(Graphics gfx, GraphicalEditPart part) {
        if (part instanceof IGraphicalEditPart) {
            CommonEditPartOperation.setGraphicsTraceabilityId(gfx, () -> {
                EObject o = ((IGraphicalEditPart)part).resolveSemanticElement();
                if (o instanceof DSemanticDecorator) {
                    return ((DSemanticDecorator)o).getTarget();
                }
                return o;
            });
        }
    }

    public Image createAWTImageForParts(List editparts, org.eclipse.swt.graphics.Rectangle sourceRect) {
        this.createSWTImageDescriptorForParts(editparts, sourceRect);
        if (this.getRenderedImage() != null) {
            try {
                BufferedImage bufImg = (BufferedImage)this.getRenderedImage().getAdapter(BufferedImage.class);
                if (bufImg == null) {
                    bufImg = ImageConverter.convert((org.eclipse.swt.graphics.Image)this.getRenderedImage().getSWTImage());
                }
                return bufImg;
            }
            catch (Error e) {
                Trace.catching((Plugin)DiagramUIRenderPlugin.getInstance(), (String)DiagramUIRenderDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"createAWTImageForParts() failed to generate image", (Throwable)e);
                return ImageConverter.convert((org.eclipse.swt.graphics.Image)SharedImages.get((String)"icons/error.gif"));
            }
            catch (Exception ex) {
                Trace.catching((Plugin)DiagramUIRenderPlugin.getInstance(), (String)DiagramUIRenderDebugOptions.EXCEPTIONS_THROWING, ((Object)((Object)this)).getClass(), (String)"createAWTImageForParts() failed to generate image", (Throwable)ex);
                return ImageConverter.convert((org.eclipse.swt.graphics.Image)SharedImages.get((String)"icons/error.gif"));
            }
        }
        return ImageConverter.convert((org.eclipse.swt.graphics.Image)SharedImages.get((String)"icons/error.gif"));
    }

    public RenderedImage getRenderedImage() {
        return this.renderedImage;
    }

    private void setRenderedImage(RenderedImage renderedImage) {
        this.renderedImage = renderedImage;
    }

    public static boolean isEmbeddedSVGinSVGExportEnabled() {
        return Boolean.valueOf(System.getProperty(ENABLE_EMBEDDED_SVG_IN_SVG_EXPORT, "true"));
    }
}

