/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.layout;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDDiagramEditPart;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManager;
import org.eclipse.sirius.diagram.ui.tools.api.format.SiriusFormatDataManagerForSemanticElementsFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.layout.AbstractCopyPasteFormatAction;
import org.eclipse.sirius.diagram.ui.tools.internal.format.data.extension.FormatDataManagerRegistry;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class PasteStyleAction
extends AbstractCopyPasteFormatAction {
    public PasteStyleAction(IWorkbenchPage workbenchPage, IWorkbenchPart actionWorkbenchPart) {
        super(workbenchPage, actionWorkbenchPart);
        this.setText(Messages.PasteStyleAction_text);
        this.setId("pasteStyleAction");
        this.setToolTipText(Messages.PasteStyleAction_toolTipText_diagram);
        this.setImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pasteStyle.gif"));
        this.setDisabledImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pasteStyleDisabled.gif"));
        this.setHoverImageDescriptor(DiagramUIPlugin.Implementation.getBundledImageDescriptor("icons/pasteStyle.gif"));
    }

    public PasteStyleAction(IWorkbenchPage workbenchPage) {
        this(workbenchPage, null);
    }

    protected String getCommandLabel() {
        return Messages.PasteStyleAction_commandLabel;
    }

    protected Command getCommand() {
        UnexecutableCommand pasteStyleCommand = UnexecutableCommand.INSTANCE;
        if (SiriusFormatDataManagerForSemanticElementsFactory.getInstance().getSiriusFormatDataManager().containsData()) {
            Map<IGraphicalEditPart, List<IGraphicalEditPart>> selectionSortedByCommonParent;
            Option<DDiagram> diagram;
            CompoundCommand doPasteStylesCmd = new CompoundCommand(Messages.PasteStyleAction_restoreStyleCommandLabel);
            DiagramEditPart diagramEditPart = this.getDiagramEditPart();
            if (diagramEditPart instanceof IDDiagramEditPart && (diagram = ((IDDiagramEditPart)diagramEditPart).resolveDDiagram()).some() && PermissionAuthorityRegistry.getDefault().getPermissionAuthority((EObject)diagram.get()).canEditInstance((EObject)diagram.get()) && !(selectionSortedByCommonParent = this.sortSelection(this.getSelectedObjects())).isEmpty()) {
                Iterator<Map.Entry<IGraphicalEditPart, List<IGraphicalEditPart>>> iter = selectionSortedByCommonParent.entrySet().iterator();
                while (iter.hasNext()) {
                    doPasteStylesCmd.add(this.getCommand((DDiagram)diagram.get(), iter.next()));
                }
            }
            pasteStyleCommand = doPasteStylesCmd.unwrap();
        }
        return pasteStyleCommand;
    }

    @Override
    protected String getToolTipForDiagramSelection() {
        return Messages.PasteStyleAction_toolTipText_diagram;
    }

    @Override
    protected String getToolTipForDiagramElementsSelection() {
        return Messages.PasteStyleAction_toolTipText_diagramElements;
    }

    private Command getCommand(DDiagram dDiagram, Map.Entry<IGraphicalEditPart, List<IGraphicalEditPart>> entry) {
        if (entry.getValue().size() == 1) {
            return new ICommandProxy((ICommand)new PasteStyleDataCommand(entry.getValue().get(0).getEditingDomain(), dDiagram, entry.getValue().get(0)));
        }
        return new ICommandProxy((ICommand)new PasteStyleDataCommand(entry.getValue().get(0).getEditingDomain(), dDiagram, entry.getKey(), entry.getValue()));
    }

    private static final class PasteStyleDataCommand
    extends AbstractTransactionalCommand {
        private IGraphicalEditPart containerOrMainEditPartToRestore;
        private List<IGraphicalEditPart> editPartsToRestore;
        private DDiagram dDiagram;

        PasteStyleDataCommand(TransactionalEditingDomain domain, DDiagram dDiagram, IGraphicalEditPart editPartToRestore) {
            super(domain, Messages.PasteStyleDataCommand_label, null);
            this.dDiagram = dDiagram;
            this.containerOrMainEditPartToRestore = editPartToRestore;
        }

        PasteStyleDataCommand(TransactionalEditingDomain domain, DDiagram dDiagram, IGraphicalEditPart editPartContainer, List<IGraphicalEditPart> editPartsToRestore) {
            super(domain, Messages.PasteLayoutDataCommand_label, null);
            this.dDiagram = dDiagram;
            this.containerOrMainEditPartToRestore = editPartContainer;
            this.editPartsToRestore = editPartsToRestore;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            List<SiriusFormatDataManager> formatDataManagers = FormatDataManagerRegistry.getSiriusFormatDataManagers(this.dDiagram);
            if (!formatDataManagers.isEmpty()) {
                if (this.editPartsToRestore == null) {
                    formatDataManagers.get(0).applyStyle(this.containerOrMainEditPartToRestore);
                } else {
                    for (IGraphicalEditPart editPartToRestore : this.editPartsToRestore) {
                        formatDataManagers.get(0).applyStyle(editPartToRestore);
                    }
                }
            }
            return CommandResult.newOKCommandResult();
        }
    }
}

