/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.quickfix;

import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.resource.FileProvider;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.tools.internal.validation.constraints.ImagePathWrappingStatus;
import org.eclipse.sirius.diagram.ui.business.api.image.ImageSelector;
import org.eclipse.sirius.diagram.ui.business.api.image.ImageSelectorService;
import org.eclipse.sirius.diagram.ui.internal.quickfix.AbstractValidationFix;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.ui.IEditorPart;

public class ImageMarkerResolution
extends AbstractValidationFix {
    public String getLabel() {
        return Messages.ImageMarkerResolution_label;
    }

    @Override
    protected void doExecuteFix(IMarker marker, IEditorPart editor, View markedView, Session session) {
        TransactionalEditingDomain transactionalEditingDomain = session.getTransactionalEditingDomain();
        String imageIssueKind = marker.getAttribute("IMAGE_PATH_TARGET_KEY", "");
        String imagePath = marker.getAttribute("IMAGE_PATH", null);
        boolean exists = FileProvider.getDefault().exists((IPath)new Path(imagePath), (Object)session);
        if (!exists) {
            boolean fixSucceeded = false;
            if (ImagePathWrappingStatus.ImagePathTarget.DREPRESENTATION_DESCRIPTOR.toString().equals(imageIssueKind)) {
                String featurename = marker.getAttribute("IMAGE_PATH_FEATURE", "");
                DRepresentationDescriptor representationDescriptor = this.getRepresentationDescriptor(transactionalEditingDomain, marker);
                fixSucceeded = ImageMarkerResolution.fixImagePathInRichText((EObject)representationDescriptor, featurename, imagePath, transactionalEditingDomain);
            } else if (ImagePathWrappingStatus.ImagePathTarget.SEMANTIC_TARGET.toString().equals(imageIssueKind) && markedView.getElement() instanceof DSemanticDecorator) {
                String featurename = marker.getAttribute("IMAGE_PATH_FEATURE", "");
                fixSucceeded = ImageMarkerResolution.fixImagePathInRichText(((DSemanticDecorator)markedView.getElement()).getTarget(), featurename, imagePath, transactionalEditingDomain);
            } else if (ImagePathWrappingStatus.ImagePathTarget.WORKSPACE_IMAGE.toString().equals(imageIssueKind)) {
                fixSucceeded = ImageMarkerResolution.fixWorkspaceImagePath(markedView.getElement(), imagePath, transactionalEditingDomain);
            }
            if (fixSucceeded) {
                this.revalidate(editor, (View)markedView.getDiagram());
            }
        } else {
            this.revalidate(editor, (View)markedView.getDiagram());
        }
    }

    public static boolean fixImagePathInRichText(final EObject eObject, String featurename, final String imagePath, TransactionalEditingDomain ted) {
        EAttribute eAttribute;
        Object stringObj;
        boolean fixSucceeded = false;
        Optional<EAttribute> eAttributeOpt = eObject.eClass().getEAllAttributes().stream().filter(attr -> featurename.equals(attr.getName())).findFirst();
        if (eAttributeOpt.isPresent() && (stringObj = eObject.eGet((EStructuralFeature)(eAttribute = eAttributeOpt.get()))) instanceof String) {
            final String htmlText = (String)stringObj;
            final List<String> selectImages = ImageSelectorService.INSTANCE.getImageSelector().selectImages(eObject, ImageSelector.SelectionMode.MONO_SELECTION, imagePath);
            if (selectImages.size() == 1) {
                final String quote = "\"";
                ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                    protected void doExecute() {
                        String newHtmlText = htmlText.replaceAll(String.valueOf(quote) + imagePath + quote, String.valueOf(quote) + (String)selectImages.get(0) + quote);
                        eObject.eSet((EStructuralFeature)eAttribute, (Object)newHtmlText);
                    }
                });
                fixSucceeded = true;
            }
        }
        return fixSucceeded;
    }

    public static boolean fixWorkspaceImagePath(EObject eObject, String imagePath, TransactionalEditingDomain ted) {
        List<String> selectImages;
        boolean fixSucceeded = false;
        final WorkspaceImage workspaceImage = eObject.eContents().stream().filter(WorkspaceImage.class::isInstance).findFirst().orElse(null);
        if (workspaceImage != null && (selectImages = ImageSelectorService.INSTANCE.getImageSelector().selectImages(eObject, ImageSelector.SelectionMode.MONO_SELECTION, imagePath)).size() == 1) {
            ted.getCommandStack().execute((Command)new RecordingCommand(ted){

                protected void doExecute() {
                    workspaceImage.setWorkspacePath((String)selectImages.get(0));
                }
            });
            fixSucceeded = true;
        }
        return fixSucceeded;
    }

    private DRepresentationDescriptor getRepresentationDescriptor(TransactionalEditingDomain transactionalEditingDomain, IMarker marker) {
        EObject markedDiagramDescriptor;
        ResourceSet set;
        String diagramDescriptorURI = marker.getAttribute("DIAGRAM_DESCRIPTOR_URI", null);
        if (diagramDescriptorURI != null && (set = transactionalEditingDomain.getResourceSet()) != null && (markedDiagramDescriptor = set.getEObject(URI.createURI((String)diagramDescriptorURI), true)) instanceof DRepresentationDescriptor) {
            return (DRepresentationDescriptor)markedDiagramDescriptor;
        }
        return null;
    }
}

