/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.graphical.edit.policies;

import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.OpenEditPolicy;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.diagram.AppliedCompositeFilters;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.GraphicalFilter;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.filter.CompositeFilterDescription;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.diagram.model.business.internal.helper.LayerModelHelper;
import org.eclipse.sirius.diagram.tools.api.command.ChangeLayerActivationCommand;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractGeneratedDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DEdgeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNodeListElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.handler.FilterUpdateTask;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DoubleClickEditPolicy
extends OpenEditPolicy {
    protected org.eclipse.gef.commands.Command getOpenCommand(Request request) {
        EObject element;
        ICommandProxy result = null;
        EditPart editPart = this.getHost();
        Object model = editPart.getModel();
        if (model instanceof View && (element = ((View)model).getElement()) instanceof DDiagramElement) {
            DDiagramElement ddiagramElement = (DDiagramElement)element;
            DiagramElementMapping diagramElementMapping = ddiagramElement.getDiagramElementMapping();
            DDiagram parentDiagram = ddiagramElement.getParentDiagram();
            if (parentDiagram.isIsInShowingMode()) {
                Command cmd = null;
                IDiagramCommandFactory emfCommandFactory = this.getCommandFactory(editPart);
                EditPart targetEditPart = this.getTargetEditPart(request);
                if (targetEditPart instanceof AbstractGeneratedDiagramNameEditPart && !(targetEditPart instanceof DNodeListElementEditPart)) {
                    DDiagramElementQuery query = new DDiagramElementQuery(ddiagramElement);
                    if (query.canHideLabel()) {
                        boolean labelHidden = query.isLabelHidden();
                        if (targetEditPart instanceof AbstractDEdgeNameEditPart) {
                            int visualID = new EditPartQuery((AbstractDEdgeNameEditPart)targetEditPart).getVisualID();
                            labelHidden = query.isLabelHidden(visualID);
                        }
                        cmd = labelHidden || !ddiagramElement.isVisible() ? this.revealElement(parentDiagram, ddiagramElement, emfCommandFactory, true, editPart) : this.hideElement(ddiagramElement, emfCommandFactory, true, editPart);
                    }
                } else {
                    cmd = !ddiagramElement.isVisible() ? this.revealElement(parentDiagram, ddiagramElement, emfCommandFactory, false, editPart) : this.hideElement(ddiagramElement, emfCommandFactory, false, editPart);
                }
                TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                result = new ICommandProxy((ICommand)new GMFCommandWrapper(editingDomain, cmd));
            } else if (diagramElementMapping.getDoubleClickDescription() != null) {
                IDiagramCommandFactory emfCommandFactory = this.getCommandFactory(editPart);
                Command cmd = emfCommandFactory.buildDoubleClickOnElementCommandFromTool(ddiagramElement, diagramElementMapping.getDoubleClickDescription());
                TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
                result = new ICommandProxy((ICommand)new GMFCommandWrapper(editingDomain, cmd));
            }
        }
        return result;
    }

    private Command hideElement(DDiagramElement ddiagramElement, IDiagramCommandFactory emfCommandFactory, boolean hideLabel, EditPart editPart) {
        Command cmd;
        HashSet<DDiagramElement> elementSet = new HashSet<DDiagramElement>();
        elementSet.add(ddiagramElement);
        if (hideLabel) {
            if (editPart instanceof AbstractDEdgeNameEditPart) {
                AbstractDEdgeNameEditPart abstractDEdgeNameEditPart = (AbstractDEdgeNameEditPart)editPart;
                LinkedList<Integer> selectedLabelVisualIds = new LinkedList<Integer>();
                selectedLabelVisualIds.add(new EditPartQuery(abstractDEdgeNameEditPart).getVisualID());
                HashMap<DDiagramElement, LinkedList<Integer>> semanticToLabelsVisualIDToHideMap = new HashMap<DDiagramElement, LinkedList<Integer>>();
                semanticToLabelsVisualIDToHideMap.put(ddiagramElement, selectedLabelVisualIds);
                cmd = emfCommandFactory.buildHideLabelSelectionCommand(elementSet, semanticToLabelsVisualIDToHideMap);
            } else {
                cmd = emfCommandFactory.buildHideLabelCommand(elementSet);
            }
        } else {
            cmd = emfCommandFactory.buildHideCommand(elementSet);
        }
        return cmd;
    }

    private Command revealElement(DDiagram parentDiagram, DDiagramElement ddiagramElement, IDiagramCommandFactory emfCommandFactory, boolean hideLabel, EditPart editPart) {
        CompoundCommand compoundCommand = new CompoundCommand();
        HashSet<DDiagramElement> elementSet = new HashSet<DDiagramElement>();
        elementSet.add(ddiagramElement);
        if (ddiagramElement instanceof DEdge && editPart instanceof DEdgeEditPart) {
            DEdge edge = (DEdge)ddiagramElement;
            EdgeTarget sourceNode = edge.getSourceNode();
            EdgeTarget targetNode = edge.getTargetNode();
            if (sourceNode instanceof DDiagramElement && targetNode instanceof DDiagramElement) {
                elementSet.add((DDiagramElement)sourceNode);
                elementSet.add((DDiagramElement)targetNode);
                this.addAllParentRecursively(elementSet, (DDiagramElement)sourceNode);
                this.addAllParentRecursively(elementSet, (DDiagramElement)targetNode);
            }
        } else {
            this.addAllParentRecursively(elementSet, ddiagramElement);
        }
        if (hideLabel) {
            if (editPart instanceof AbstractDEdgeNameEditPart) {
                AbstractDEdgeNameEditPart abstractDEdgeNameEditPart = (AbstractDEdgeNameEditPart)editPart;
                LinkedList<Integer> selectedLabelVisualIds = new LinkedList<Integer>();
                selectedLabelVisualIds.add(new EditPartQuery(abstractDEdgeNameEditPart).getVisualID());
                HashMap<DDiagramElement, LinkedList<Integer>> semanticToLabelsVisualIDToHideMap = new HashMap<DDiagramElement, LinkedList<Integer>>();
                semanticToLabelsVisualIDToHideMap.put(ddiagramElement, selectedLabelVisualIds);
                for (DDiagramElement dDiagramElement : elementSet) {
                    compoundCommand.append(emfCommandFactory.buildRevealLabelSelectionCommand(dDiagramElement, semanticToLabelsVisualIDToHideMap));
                }
            } else {
                compoundCommand.append(emfCommandFactory.buildRevealLabelCommand(ddiagramElement));
                compoundCommand.append(emfCommandFactory.buildRevealElementsCommand(elementSet));
            }
        } else {
            Map.Entry<String, Command> filterEntry = this.getCommandToDeactivateFiltersHidingElementAndParents(parentDiagram, elementSet);
            Map.Entry<String, Command> layerEntry = this.getCommandToActivateLayerShowingElementAndPArents(parentDiagram, elementSet);
            if (filterEntry != null || layerEntry != null) {
                boolean confirm = this.prepareLayerActivationAndFilterDeactivationCommands(compoundCommand, filterEntry, layerEntry);
                if (confirm) {
                    compoundCommand.append(emfCommandFactory.buildRevealElementsCommand(elementSet));
                }
            } else {
                compoundCommand.append(emfCommandFactory.buildRevealElementsCommand(elementSet));
            }
        }
        return compoundCommand;
    }

    private boolean prepareLayerActivationAndFilterDeactivationCommands(CompoundCommand compoundCommand, Map.Entry<String, Command> filterEntry, Map.Entry<String, Command> layerEntry) {
        String message = "";
        if (filterEntry != null) {
            message = String.valueOf(message) + MessageFormat.format(Messages.DoubleClickEditPolicy_filterConfirmDialogBody, filterEntry.getKey());
        }
        if (layerEntry != null) {
            if (filterEntry != null) {
                message = String.valueOf(message) + "\n";
            }
            message = String.valueOf(message) + MessageFormat.format(Messages.DoubleClickEditPolicy_layerConfirmDialogBody, layerEntry.getKey());
        }
        message = String.valueOf(message) + "\n" + Messages.DoubleClickEditPolicy_confirmDialogAsking;
        boolean confirm = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)Messages.DoubleClickEditPolicy_confirmDialogTitle, (String)message);
        if (confirm) {
            if (layerEntry != null) {
                compoundCommand.append(layerEntry.getValue());
            }
            if (filterEntry != null) {
                compoundCommand.append(filterEntry.getValue());
            }
        }
        return confirm;
    }

    private Map.Entry<String, Command> getCommandToActivateLayerShowingElementAndPArents(DDiagram parentDiagram, Set<DDiagramElement> elementSet) {
        CompoundCommand layerCompoundCommand = new CompoundCommand();
        Optional optionalSession = Session.of((EObject)parentDiagram);
        LinkedHashSet<String> layersToActivateSet = new LinkedHashSet<String>();
        if (optionalSession.isPresent()) {
            DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager((Session)optionalSession.get(), parentDiagram);
            for (DDiagramElement dDiagramElement : elementSet) {
                Collection<Layer> layersToActivate = this.getLayerToActivate(parentDiagram, dDiagramElement, mappingManager);
                for (Layer layerToActivate : layersToActivate) {
                    if (layerToActivate == null) continue;
                    TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)parentDiagram);
                    if (layersToActivateSet.contains(layerToActivate.getName())) continue;
                    layerCompoundCommand.append((Command)new ChangeLayerActivationCommand(domain, parentDiagram, layerToActivate, (IProgressMonitor)new NullProgressMonitor()));
                    layersToActivateSet.add(layerToActivate.getName());
                }
            }
        }
        return layerCompoundCommand.getCommandList().size() > 0 ? new AbstractMap.SimpleEntry<String, CompoundCommand>(layersToActivateSet.stream().collect(Collectors.joining(", ")), layerCompoundCommand) : null;
    }

    private Map.Entry<String, Command> getCommandToDeactivateFiltersHidingElementAndParents(DDiagram parentDiagram, Set<DDiagramElement> elementSet) {
        Set graphicalFilters = elementSet.stream().flatMap(element -> element.getGraphicalFilters().stream()).filter(elmt -> elmt instanceof AppliedCompositeFilters).collect(Collectors.toSet());
        SiriusCommand command = null;
        String filterStrings = null;
        if (graphicalFilters.size() > 0) {
            filterStrings = graphicalFilters.stream().flatMap(elmt -> ((AppliedCompositeFilters)elmt).getCompositeFilterDescriptions().stream()).map(elt -> elt.getName()).collect(Collectors.joining(", "));
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)parentDiagram);
            command = new SiriusCommand(domain, null);
            for (GraphicalFilter graphicalFilter : graphicalFilters) {
                EList compositeFilterDescriptions = ((AppliedCompositeFilters)graphicalFilter).getCompositeFilterDescriptions();
                for (CompositeFilterDescription compositeFilterDescription : compositeFilterDescriptions) {
                    command.getTasks().add(new FilterUpdateTask(parentDiagram, (FilterDescription)compositeFilterDescription, false));
                }
            }
            command.setLabel(MessageFormat.format(Messages.ChangeFilterActivation_deactivateFilter, filterStrings));
        }
        return command != null ? new AbstractMap.SimpleEntry<Object, Object>(filterStrings, command) : null;
    }

    private Collection<Layer> getLayerToActivate(DDiagram parentDiagram, DDiagramElement ddiagramElement, DiagramMappingsManager mappingManager) {
        Collection layers = mappingManager.getActiveParentLayers(ddiagramElement.getDiagramElementMapping());
        EList allLayers = LayerModelHelper.getAllLayers((DiagramDescription)parentDiagram.getDescription());
        Set deactivatedLayers = allLayers.stream().filter(elmt -> !layers.contains(elmt)).collect(Collectors.toSet());
        Collection diagramElementLayers = LayerHelper.getParentLayers((DiagramElementMapping)ddiagramElement.getDiagramElementMapping());
        LinkedHashSet<Layer> keptElementLayers = new LinkedHashSet<Layer>();
        for (Layer deactivatedLayer : deactivatedLayers) {
            for (Layer diagramElementLayer : diagramElementLayers) {
                if (!EqualityHelper.areEquals((EObject)deactivatedLayer, (EObject)diagramElementLayer)) continue;
                keptElementLayers.add(deactivatedLayer);
            }
        }
        return keptElementLayers;
    }

    private void addAllParentRecursively(Set<DDiagramElement> elementSet, DDiagramElement ddiagramElement) {
        EObject eContainer = ddiagramElement.eContainer();
        if (eContainer instanceof DDiagramElement) {
            elementSet.add((DDiagramElement)eContainer);
            this.addAllParentRecursively(elementSet, (DDiagramElement)eContainer);
        }
    }

    private IDiagramCommandFactory getCommandFactory(EditPart editPart) {
        TransactionalEditingDomain transactionalEditingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        DDiagramEditor diagramEditor = (DDiagramEditor)editPart.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
        Object adapter = diagramEditor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        IDiagramCommandFactory emfCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
        return emfCommandFactory;
    }
}

