/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.refactoring;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.photran.core.IFortranAST;
import org.eclipse.photran.internal.core.analysis.binding.Definition;
import org.eclipse.photran.internal.core.analysis.binding.ScopingNode;
import org.eclipse.photran.internal.core.parser.ASTCommonBlockNode;
import org.eclipse.photran.internal.core.parser.ASTCommonBlockObjectNode;
import org.eclipse.photran.internal.core.parser.ASTCommonStmtNode;
import org.eclipse.photran.internal.core.parser.ASTExecutableProgramNode;
import org.eclipse.photran.internal.core.refactoring.Messages;
import org.eclipse.photran.internal.core.refactoring.infrastructure.FortranResourceRefactoring;
import org.eclipse.photran.internal.core.vpg.PhotranVPG;
import org.eclipse.photran.internal.core.vpg.refactoring.VPGRefactoring;

public class RemoveUnusedCommonBlockVariablesRefactoring
extends FortranResourceRefactoring {
    @Override
    protected void doCheckInitialConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        this.ensureProjectHasRefactoringEnabled(status);
        this.removeFixedFormFilesFrom(this.selectedFiles, status);
        this.removeCpreprocessedFilesFrom(this.selectedFiles, status);
        this.ensureImplicitNoneAndVariablesDeclared(status);
    }

    @Override
    protected void doCheckFinalConditions(RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                if (ast != null) {
                    this.makeChangesTo(file, ast, status, pm);
                    this.addChangeFromModifiedAST(file, pm);
                }
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }

    private void makeChangesTo(IFile file, IFortranAST ast, RefactoringStatus status, IProgressMonitor pm) throws VPGRefactoring.PreconditionFailure {
        for (ASTCommonStmtNode node : ast.getRoot().findAll(ASTCommonStmtNode.class)) {
            this.processCommon(node);
        }
    }

    @Override
    protected void doCreateChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
    }

    @Override
    public String getName() {
        return Messages.RemoveUnusedCommonBlockVariablesRefactoring_Name;
    }

    private void esureAllCommonVariablesAreDeclared(IFile file, IFortranAST ast) throws VPGRefactoring.PreconditionFailure {
        for (ASTCommonStmtNode common : ast.getRoot().findAll(ASTCommonStmtNode.class)) {
            this.ensureAllVariblesAreDeclaredInCommon(common);
        }
    }

    private void ensureAllVariblesAreDeclaredInCommon(ASTCommonStmtNode node) throws VPGRefactoring.PreconditionFailure {
        for (ASTCommonBlockNode commonBlockNode : node.getCommonBlockList()) {
            for (ASTCommonBlockObjectNode commonBlockObject : commonBlockNode.getCommonBlockObjectList()) {
                List<Definition> definition = commonBlockObject.getVariableName().resolveBinding();
                if (definition.size() == 0) {
                    this.fail(Messages.bind((String)Messages.RemoveUnusedCommonBlockVariablesRefactoring_NoDeclarationFoundFor, (Object)commonBlockObject.getVariableName()));
                    continue;
                }
                if (definition.size() <= 1) continue;
                this.fail(Messages.bind((String)Messages.RemoveUnusedCommonBlockVariablesRefactoring_MultipleDeclarationsFoundFor, (Object)commonBlockObject.getVariableName()));
            }
        }
    }

    private void ensureAllScopesAreImplicitNone(IFile file, IFortranAST ast) throws VPGRefactoring.PreconditionFailure {
        for (ScopingNode scope : ast.getRoot().getAllContainedScopes()) {
            if (scope instanceof ASTExecutableProgramNode || scope.isImplicitNone()) continue;
            this.fail(Messages.bind((String)Messages.RemoveUnusedCommonBlockVariablesRefactoring_SelectedFilesMustBeImplicitNone, (Object)file.getName()));
        }
    }

    private void processCommon(ASTCommonStmtNode node) throws VPGRefactoring.PreconditionFailure {
        int declaredCommons = node.getCommonBlockList().size();
        for (ASTCommonBlockNode commonBlockNode : node.getCommonBlockList()) {
            boolean remove = true;
            for (ASTCommonBlockObjectNode commonBlockObject : commonBlockNode.getCommonBlockObjectList()) {
                List<Definition> definition = commonBlockObject.getVariableName().resolveBinding();
                if (definition.get(0).findAllReferences(true).size() <= 1) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            commonBlockNode.removeFromTree();
            --declaredCommons;
        }
        if (declaredCommons == 0) {
            node.removeFromTree();
        }
    }

    private void ensureImplicitNoneAndVariablesDeclared(RefactoringStatus status) throws VPGRefactoring.PreconditionFailure {
        try {
            for (IFile file : this.selectedFiles) {
                IFortranAST ast = (IFortranAST)((PhotranVPG)this.vpg).acquirePermanentAST(file);
                this.ensureAllScopesAreImplicitNone(file, ast);
                this.esureAllCommonVariablesAreDeclared(file, ast);
                ((PhotranVPG)this.vpg).releaseAST(file);
            }
        }
        finally {
            ((PhotranVPG)this.vpg).releaseAllASTs();
        }
    }
}

