/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.imports.OverwriteProjectsSelectionDialog;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportHelper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.ScmUrlImportDescription;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.importing.provisional.IBundleImporter;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.wizards.datatransfer.FileSystemStructureProvider;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ZipFileStructureProvider;
import org.osgi.framework.BundleException;

public class PluginImportOperation
extends WorkspaceJob {
    public static final int IMPORT_BINARY = 1;
    public static final int IMPORT_BINARY_WITH_LINKS = 2;
    public static final int IMPORT_WITH_SOURCE = 3;
    public static final int IMPORT_FROM_REPOSITORY = 4;
    private static final String DEFAULT_SOURCE_DIR = "src";
    private static final String DEFAULT_LIBRARY_NAME = ".";
    private static final int MAX_RETRY = 5;
    private static final int RETRY_DELAY = 1000;
    private IPluginModelBase[] fModels;
    private int fImportType;
    private Hashtable<IProject, IClasspathEntry[]> fProjectClasspaths = new Hashtable();
    private Map<String, List<IWorkingSet>> fProjectWorkingSets = new HashMap<String, List<IWorkingSet>>();
    private boolean fForceAutobuild;
    private Map<IBundleImporter, ScmUrlImportDescription[]> fImportDescriptions;
    private SourceLocationManager fAlternateSource;
    private boolean fPluginsAreInUse = false;

    public PluginImportOperation(IPluginModelBase[] models, int importType, boolean forceAutobuild) {
        super(PDEUIMessages.ImportWizard_title);
        this.fModels = models;
        this.fImportType = importType;
        this.fForceAutobuild = forceAutobuild;
    }

    public void setPluginsInUse(boolean pluginsInUse) {
        this.fPluginsAreInUse = pluginsInUse;
    }

    public void setAlternateSource(SourceLocationManager alternate) {
        this.fAlternateSource = alternate;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        int ticks = this.fImportType == 4 ? this.fImportDescriptions.size() + 2 : this.fModels.length + 1;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)ticks);
        MultiStatus multiStatus = new MultiStatus(PDEPlugin.getPluginId(), 0, PDEUIMessages.ImportWizard_operation_multiProblem, null);
        this.deleteConflictingProjects(multiStatus, (IProgressMonitor)subMonitor.split(2));
        if (subMonitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.fImportType == 4) {
            ArrayList<String> namesOfNotImportedProjects = new ArrayList<String>();
            for (Map.Entry<IBundleImporter, ScmUrlImportDescription[]> entry : this.fImportDescriptions.entrySet()) {
                IProject[] importedProjects;
                IBundleImporter importer = entry.getKey();
                ScmUrlImportDescription[] descriptions = entry.getValue();
                if (descriptions.length == 0 || (importedProjects = importer.performImport(descriptions, (IProgressMonitor)subMonitor.split(1))) != null && importedProjects.length == descriptions.length) continue;
                ArrayList<String> namesOfImportedProjects = new ArrayList<String>(importedProjects.length);
                IProject[] iProjectArray = importedProjects;
                int n = importedProjects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject importedProject = iProjectArray[n2];
                    namesOfImportedProjects.add(importedProject.getName());
                    ++n2;
                }
                iProjectArray = descriptions;
                n = descriptions.length;
                n2 = 0;
                while (n2 < n) {
                    IProject description = iProjectArray[n2];
                    String projectName = description.getProject();
                    if (!namesOfImportedProjects.contains(projectName)) {
                        namesOfNotImportedProjects.add(projectName);
                    }
                    ++n2;
                }
            }
            if (!namesOfNotImportedProjects.isEmpty()) {
                UIJob job = UIJob.create((String)PDEUIMessages.PluginImportOperation_WarningDialogJob, m -> {
                    String dialogMessage = namesOfNotImportedProjects.size() == 1 ? PDEUIMessages.PluginImportOperation_WarningDialogMessageSingular : PDEUIMessages.PluginImportOperation_WarningDialogMessagePlural;
                    NotImportedProjectsWarningDialog dialog = new NotImportedProjectsWarningDialog(dialogMessage, namesOfNotImportedProjects);
                    dialog.open();
                });
                try {
                    job.schedule();
                    job.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            IPluginModelBase[] iPluginModelBaseArray = this.fModels;
            int n = this.fModels.length;
            int n3 = 0;
            while (n3 < n) {
                IPluginModelBase model = iPluginModelBaseArray[n3];
                subMonitor.setTaskName(NLS.bind((String)PDEUIMessages.PluginImportOperation_Importing_plugin, (Object)model.getPluginBase().getId()));
                try {
                    this.importPlugin(model, this.fImportType, (IProgressMonitor)subMonitor.split(1));
                }
                catch (CoreException e) {
                    multiStatus.merge(e.getStatus());
                }
                if (subMonitor.isCanceled()) {
                    try {
                        this.setClasspaths((IProgressMonitor)subMonitor.split(1));
                    }
                    catch (JavaModelException javaModelException) {}
                    return Status.CANCEL_STATUS;
                }
                ++n3;
            }
            subMonitor.setTaskName(PDEUIMessages.PluginImportOperation_Set_up_classpaths);
            try {
                this.setClasspaths((IProgressMonitor)subMonitor.split(1));
            }
            catch (JavaModelException e) {
                multiStatus.merge(e.getStatus());
            }
        }
        if (!ResourcesPlugin.getWorkspace().isAutoBuilding() && this.fForceAutobuild) {
            this.runBuildJob();
        }
        return multiStatus;
    }

    private void deleteConflictingProjects(MultiStatus status, IProgressMonitor monitor) {
        Object symbolicName;
        monitor.beginTask("", 5);
        IPluginModelBase[] workspacePlugins = PluginRegistry.getWorkspaceModels();
        HashMap<IPluginModelBase[], ArrayList<IPluginModelBase>> workspacePluginMap = new HashMap<IPluginModelBase[], ArrayList<IPluginModelBase>>();
        IPluginModelBase[] iPluginModelBaseArray = workspacePlugins;
        int n = workspacePlugins.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase plugin = iPluginModelBaseArray[n2];
            if (plugin.getBundleDescription() != null) {
                symbolicName = plugin.getBundleDescription().getSymbolicName();
                ArrayList<IPluginModelBase> pluginsWithSameSymbolicName = (ArrayList<IPluginModelBase>)workspacePluginMap.get(symbolicName);
                if (pluginsWithSameSymbolicName == null) {
                    pluginsWithSameSymbolicName = new ArrayList<IPluginModelBase>();
                    workspacePluginMap.put((IPluginModelBase[])symbolicName, pluginsWithSameSymbolicName);
                }
                pluginsWithSameSymbolicName.add(plugin);
            }
            ++n2;
        }
        monitor.worked(1);
        ArrayList conflictingPlugins = new ArrayList();
        symbolicName = this.fModels;
        int n3 = this.fModels.length;
        n = 0;
        while (n < n3) {
            String symbolicName2;
            ArrayList plugins;
            IPluginModelBase model = symbolicName[n];
            if (model.getBundleDescription() != null && (plugins = (ArrayList)workspacePluginMap.get(symbolicName2 = model.getBundleDescription().getSymbolicName())) != null && !plugins.isEmpty() && !conflictingPlugins.containsAll(plugins)) {
                conflictingPlugins.addAll(plugins);
            }
            ++n;
        }
        monitor.worked(1);
        ArrayList overwriteProjectList = new ArrayList();
        if (!conflictingPlugins.isEmpty()) {
            IWorkingSet[] sets;
            UIJob job = UIJob.create((String)PDEUIMessages.PluginImportOperation_OverwritePluginProjects, m -> {
                Shell shell = Display.getCurrent().getActiveShell();
                OverwriteProjectsSelectionDialog dialog = new OverwriteProjectsSelectionDialog(shell, conflictingPlugins);
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0) {
                    overwriteProjectList.addAll(Arrays.asList(dialog.getResult()));
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            });
            try {
                job.schedule();
                job.join();
            }
            catch (InterruptedException interruptedException) {}
            if (job.getResult() == null || !job.getResult().isOK()) {
                monitor.setCanceled(true);
                return;
            }
            monitor.worked(1);
            IWorkingSetManager wsManager = PlatformUI.getWorkbench().getWorkingSetManager();
            IWorkingSet[] iWorkingSetArray = sets = wsManager.getAllWorkingSets();
            int n4 = sets.length;
            int plugins = 0;
            while (plugins < n4) {
                IAdaptable[] contents;
                IWorkingSet set = iWorkingSetArray[plugins];
                IAdaptable[] iAdaptableArray = contents = set.getElements();
                int n5 = contents.length;
                int n6 = 0;
                while (n6 < n5) {
                    IAdaptable content = iAdaptableArray[n6];
                    IResource resource = (IResource)content.getAdapter(IResource.class);
                    if (resource instanceof IProject) {
                        String id = ((IProject)resource).getName();
                        List<IWorkingSet> workingSets = this.fProjectWorkingSets.get(id);
                        if (workingSets == null) {
                            workingSets = new ArrayList<IWorkingSet>();
                            this.fProjectWorkingSets.put(id, workingSets);
                        }
                        workingSets.add(set);
                    }
                    ++n6;
                }
                ++plugins;
            }
            int i = 0;
            while (i < overwriteProjectList.size()) {
                IPluginModelBase plugin = (IPluginModelBase)overwriteProjectList.get(i);
                monitor.setTaskName(NLS.bind((String)PDEUIMessages.PluginImportOperation_Importing_plugin, (Object)plugin.getPluginBase().getId()));
                IProject project = plugin.getUnderlyingResource().getProject();
                try {
                    if (RepositoryProvider.isShared((IProject)project)) {
                        RepositoryProvider.unmap((IProject)project);
                    }
                    if (!this.safeDeleteCheck(project, monitor)) {
                        status.add(Status.error((String)NLS.bind((String)PDEUIMessages.PluginImportOperation_could_not_delete_project, (Object)project.getName())));
                    }
                    boolean deleteContent = project.getWorkspace().getRoot().getLocation().equals((Object)project.getLocation().removeLastSegments(1));
                    this.deleteProject(project, deleteContent, monitor);
                }
                catch (CoreException ex) {
                    status.add(Status.error((String)NLS.bind((String)PDEUIMessages.PluginImportOperation_could_not_delete_project, (Object)project.getName()), (Throwable)ex));
                }
                ++i;
            }
            monitor.worked(2);
        } else {
            monitor.worked(3);
        }
    }

    private void deleteProject(IProject project, boolean deleteContent, IProgressMonitor monitor) throws CoreException {
        int i = 0;
        while (i < 5) {
            try {
                project.delete(deleteContent, true, monitor);
                i = 5;
            }
            catch (CoreException e) {
                if (i == 4) {
                    throw e;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
    }

    private void setClasspaths(IProgressMonitor monitor) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.fProjectClasspaths.size());
        Enumeration<IProject> keys = this.fProjectClasspaths.keys();
        while (keys.hasMoreElements()) {
            IProject project = keys.nextElement();
            IClasspathEntry[] classpath = this.fProjectClasspaths.get(project);
            subMonitor.subTask(project.getName());
            JavaCore.create((IProject)project).setRawClasspath(classpath, (IProgressMonitor)subMonitor.split(1));
        }
    }

    private void importPlugin(IPluginModelBase model, int importType, IProgressMonitor monitor) throws CoreException {
        File location;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)5);
        IProject project = this.createProject(model, (IProgressMonitor)subMonitor.split(1));
        if (project == null) {
            return;
        }
        if (Platform.inDevelopmentMode() && (location = new File(model.getInstallLocation())).isDirectory()) {
            File classpathFile = new File(location, ".classpath");
            File projectFile = new File(location, ".project");
            if (classpathFile.exists() && classpathFile.isFile() && projectFile.exists() && projectFile.isFile()) {
                PluginImportHelper.importContent(location, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, (IProgressMonitor)subMonitor.split(4));
                return;
            }
        }
        Map<String, IPath> sourceMap = null;
        if (importType == 1 || importType == 3 && !this.canFindSource(model)) {
            sourceMap = this.importAsBinary(project, model, (IProgressMonitor)subMonitor.split(4));
        } else if (importType == 2) {
            sourceMap = this.importAsBinaryWithLinks(project, model, (IProgressMonitor)subMonitor.split(4));
        } else if (importType == 3) {
            this.importAsSource(project, model, (IProgressMonitor)subMonitor.split(4));
        }
        this.setProjectNatures(project, model);
        if (importType == 3 && project.findMember(".api_description") != null) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.api.tools.apiAnalysisNature", null);
        }
        if (project.hasNature("org.eclipse.jdt.core.javanature") && project.findMember(".classpath") == null) {
            this.fProjectClasspaths.put(project, ClasspathComputer.getClasspath((IProject)project, (IPluginModelBase)model, sourceMap, (boolean)true, (boolean)false));
        }
    }

    private Map<String, IPath> importAsBinary(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        File srcFile = new File(model.getInstallLocation());
        if (this.isJARd(model)) {
            PluginImportHelper.copyArchive(srcFile, project.getFile(srcFile.getName()), (IProgressMonitor)subMonitor.split(1));
        } else {
            PluginImportHelper.importContent(new File(model.getInstallLocation()), project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, null, (IProgressMonitor)subMonitor.split(1));
        }
        Map<String, IPath> sourceMap = this.importSourceArchives(project, model, 1, (IProgressMonitor)subMonitor.split(1));
        this.importAdditionalSourceFiles(project, model, (IProgressMonitor)subMonitor.split(1));
        this.importRequiredPluginFiles(project, model, (IProgressMonitor)subMonitor.split(1));
        this.modifyBundleClasspathHeader(project, model);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.pde.core.BinaryRepositoryProvider");
        project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
        return sourceMap;
    }

    private Map<String, IPath> importAsBinaryWithLinks(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        File srcFile = new File(model.getInstallLocation());
        if (srcFile.isFile()) {
            dstFile = project.getFile((IPath)new Path(srcFile.getName()));
            dstFile.createLink(srcFile.toURI(), 0, (IProgressMonitor)subMonitor.split(1));
        } else {
            dstFile = project.getFolder((IPath)new Path(srcFile.getName()));
            dstFile.createLink(srcFile.toURI(), 0, (IProgressMonitor)subMonitor.split(1));
        }
        Map<String, IPath> sourceMap = this.importSourceArchives(project, model, 2, (IProgressMonitor)subMonitor.split(1));
        this.importAdditionalSourceFiles(project, model, (IProgressMonitor)subMonitor.split(1));
        this.importRequiredPluginFiles(project, model, (IProgressMonitor)subMonitor.split(1));
        this.modifyBundleClasspathHeader(project, model);
        RepositoryProvider.map((IProject)project, (String)"org.eclipse.pde.core.BinaryRepositoryProvider");
        project.setPersistentProperty(PDECore.EXTERNAL_PROJECT_PROPERTY, "binary");
        return sourceMap;
    }

    private void importAsSource(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        try {
            WorkspaceBuildModel buildModel;
            SubMonitor subMonitor;
            block16: {
                subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
                buildModel = new WorkspaceBuildModel(PDEProject.getBuildProperties((IProject)project));
                HashMap<IPath, IPath> packageLocations = new HashMap<IPath, IPath>();
                boolean sourceFound = this.extractSourceFolders(project, model, buildModel, packageLocations, (IProgressMonitor)subMonitor.split(1));
                if (!sourceFound) {
                    sourceFound = this.handleInternalSource(model, buildModel, packageLocations);
                }
                this.importAdditionalSourceFiles(project, model, (IProgressMonitor)subMonitor.split(1));
                if (this.isJARd(model)) {
                    SubMonitor iterationMonitor = subMonitor.split(1);
                    Throwable throwable = null;
                    Object var10_14 = null;
                    try (ZipFile zip = new ZipFile(new File(model.getInstallLocation()));){
                        ZipFileStructureProvider provider = new ZipFileStructureProvider(zip);
                        HashMap<IPath, List<Object>> collected = new HashMap<IPath, List<Object>>();
                        PluginImportHelper.collectBinaryFiles((IImportStructureProvider)provider, provider.getRoot(), packageLocations, collected);
                        iterationMonitor.setWorkRemaining(collected.size());
                        for (Map.Entry entry : collected.entrySet()) {
                            IPath currentDestination = (IPath)entry.getKey();
                            IPath destination = project.getFullPath();
                            destination = destination.append(currentDestination);
                            PluginImportHelper.importContent(provider.getRoot(), destination, (IImportStructureProvider)provider, (List)entry.getValue(), (IProgressMonitor)iterationMonitor.split(1));
                        }
                        break block16;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                SubMonitor iterationMonitor = subMonitor.split(1);
                HashMap<IPath, List<Object>> collected = new HashMap<IPath, List<Object>>();
                File srcFile = new File(model.getInstallLocation());
                PluginImportHelper.collectBinaryFiles((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, srcFile, packageLocations, collected);
                iterationMonitor.setWorkRemaining(collected.size());
                for (Map.Entry entry : collected.entrySet()) {
                    IPath currentDestination = (IPath)entry.getKey();
                    IPath destination = project.getFullPath();
                    destination = destination.append(currentDestination);
                    PluginImportHelper.importContent(srcFile, destination, (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, (List)entry.getValue(), (IProgressMonitor)iterationMonitor.split(1));
                }
            }
            if (!PDEProject.getBuildProperties((IProject)project).exists()) {
                this.configureBinIncludes(buildModel, model, project);
                buildModel.save();
            }
            subMonitor.worked(1);
        }
        catch (IOException e) {
            throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
        }
    }

    private IProject createProject(IPluginModelBase model, IProgressMonitor monitor) throws TeamException, CoreException {
        List<IWorkingSet> workingSets;
        monitor.beginTask("", 2);
        IProject project = this.findProject(model.getPluginBase().getId());
        if ((project.exists() || new File(project.getParent().getLocation().toFile(), project.getName()).exists()) && (project = PDEPlugin.getWorkspace().getRoot().getProject(model.getPluginBase().getId())).exists()) {
            File installLocation = new File(model.getInstallLocation());
            String projectName = installLocation.getName();
            int jarIndex = projectName.toLowerCase().lastIndexOf(".jar");
            if (jarIndex >= 0) {
                projectName = projectName.substring(0, jarIndex);
            }
            project = PDEPlugin.getWorkspace().getRoot().getProject(projectName);
            int index = 0;
            while (project.exists()) {
                project = PDEPlugin.getWorkspace().getRoot().getProject(String.valueOf(projectName) + '_' + ++index);
            }
        }
        project.create(monitor);
        if (!project.isOpen()) {
            project.open(monitor);
        }
        if ((workingSets = this.fProjectWorkingSets.get(project.getName())) != null) {
            for (IWorkingSet ws : workingSets) {
                IProject newElement = project;
                IAdaptable[] projectAdaptables = ws.adaptElements(new IAdaptable[]{project});
                if (projectAdaptables.length > 0) {
                    newElement = projectAdaptables[0];
                }
                IAdaptable[] currentElements = ws.getElements();
                IAdaptable[] newElements = new IAdaptable[currentElements.length + 1];
                System.arraycopy(currentElements, 0, newElements, 0, currentElements.length);
                newElements[currentElements.length] = newElement;
                ws.setElements(newElements);
            }
        }
        monitor.worked(1);
        return project;
    }

    private IProject findProject(String id) {
        IResource resource;
        IPluginModelBase model = PluginRegistry.findModel((String)id);
        if (model != null && (resource = model.getUnderlyingResource()) != null && resource.exists()) {
            return resource.getProject();
        }
        return PDEPlugin.getWorkspace().getRoot().getProject(id);
    }

    private boolean safeDeleteCheck(IProject project, IProgressMonitor monitor) {
        if (!this.fPluginsAreInUse) {
            return true;
        }
        IPluginModelBase base = PluginRegistry.findModel((IProject)project);
        if (base != null) {
            IPluginLibrary[] libraries;
            IPluginLibrary[] iPluginLibraryArray = libraries = base.getPluginBase().getLibraries();
            int n = libraries.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginLibrary library = iPluginLibraryArray[n2];
                IResource res = project.findMember(library.getName());
                if (res != null) {
                    try {
                        if (!ResourcesPlugin.getWorkspace().delete(new IResource[]{res}, true, monitor).isOK()) {
                            return false;
                        }
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                }
                ++n2;
            }
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private boolean canFindSource(IPluginModelBase model) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SourceLocationManager getSourceManager(IPluginModelBase model) {
        String[] libraries;
        SourceLocationManager manager;
        int n;
        if (this.fAlternateSource != null) {
            String[] libraries2;
            if (this.fAlternateSource.hasBundleManifestLocation(model.getPluginBase())) {
                return this.fAlternateSource;
            }
            String[] stringArray = libraries2 = this.getLibraryNames(model);
            n = libraries2.length;
            int n2 = 0;
            while (n2 < n) {
                String library = stringArray[n2];
                String zipName = ClasspathUtilCore.getSourceZipName((String)library);
                IPath srcPath = this.fAlternateSource.findSourcePath(model.getPluginBase(), (IPath)new Path(zipName));
                if (srcPath != null) {
                    return this.fAlternateSource;
                }
                ++n2;
            }
        }
        if ((manager = PDECore.getDefault().getSourceLocationManager()).hasBundleManifestLocation(model.getPluginBase())) {
            return manager;
        }
        String[] stringArray = libraries = this.getLibraryNames(model);
        int n3 = libraries.length;
        n = 0;
        while (n < n3) {
            String library = stringArray[n];
            String zipName = ClasspathUtilCore.getSourceZipName((String)library);
            IPath srcPath = manager.findSourcePath(model.getPluginBase(), (IPath)new Path(zipName));
            if (srcPath != null) {
                return manager;
            }
            ++n;
        }
        return null;
    }

    private void runBuildJob() {
        Job buildJob = new Job(PDEUIMessages.CompilersConfigurationBlock_building){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_AUTO_BUILD == family;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PDEPlugin.getWorkspace().build(10, monitor);
                }
                catch (CoreException coreException) {}
                return Status.OK_STATUS;
            }
        };
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.schedule();
    }

    private Map<String, IPath> importSourceArchives(IProject project, IPluginModelBase model, int mode, IProgressMonitor monitor) throws CoreException {
        String[] libraries = this.getLibraryNames(model);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDEUIMessages.ImportWizard_operation_importingSource, (int)libraries.length);
        HashMap<String, IPath> sourceMap = new HashMap<String, IPath>(libraries.length);
        SourceLocationManager manager = this.getSourceManager(model);
        if (manager != null) {
            int i = 0;
            while (i < libraries.length) {
                subMonitor.setWorkRemaining(libraries.length - i);
                String zipName = ClasspathUtilCore.getSourceZipName((String)libraries[i]);
                IPluginBase pluginBase = model.getPluginBase();
                IPath srcPath = manager.findSourcePath(pluginBase, (IPath)new Path(zipName));
                if (srcPath != null) {
                    zipName = srcPath.lastSegment();
                    Path dstPath = new Path(zipName);
                    sourceMap.put(libraries[i], (IPath)dstPath);
                    if (project.findMember((IPath)dstPath) == null) {
                        if (mode == 1) {
                            PluginImportHelper.copyArchive(new File(srcPath.toOSString()), project.getFile((IPath)dstPath), (IProgressMonitor)subMonitor.split(1));
                        } else if (mode == 2) {
                            IFile dstFile = project.getFile((IPath)dstPath);
                            dstFile.createLink(srcPath, 0, (IProgressMonitor)subMonitor.split(1));
                        }
                    }
                }
                ++i;
            }
        }
        return sourceMap;
    }

    private boolean extractSourceFolders(IProject project, IPluginModelBase model, WorkspaceBuildModel buildModel, Map<IPath, IPath> packageLocations, IProgressMonitor monitor) throws CoreException {
        String[] libraries = this.getLibraryNames(model);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDEUIMessages.ImportWizard_operation_importingSource, (int)libraries.length);
        SourceLocationManager manager = this.getSourceManager(model);
        if (manager != null) {
            if (manager.hasBundleManifestLocation(model.getPluginBase())) {
                File srcFile = manager.findSourcePlugin(model.getPluginBase());
                Set sourceRoots = manager.findSourceRoots(model.getPluginBase());
                String[] stringArray = libraries;
                int n = libraries.length;
                int n2 = 0;
                while (n2 < n) {
                    Path sourceDir;
                    String library = stringArray[n2];
                    if (library.equals(DEFAULT_LIBRARY_NAME)) {
                        IFolder destination = project.getFolder(DEFAULT_SOURCE_DIR);
                        if (!destination.exists()) {
                            ArrayList<IPath> excludeFolders = new ArrayList<IPath>(sourceRoots.size());
                            for (String root : sourceRoots) {
                                if (root.equals(DEFAULT_LIBRARY_NAME)) continue;
                                excludeFolders.add((IPath)new Path(root));
                            }
                            HashSet<IPath> collectedPackages = new HashSet<IPath>();
                            PluginImportHelper.extractJavaSourceFromArchive(srcFile, excludeFolders, destination.getFullPath(), collectedPackages, (IProgressMonitor)subMonitor.split(1));
                            this.addBuildEntry(buildModel, "source..", "src/");
                            this.addPackageEntries(collectedPackages, (IPath)new Path(DEFAULT_SOURCE_DIR), packageLocations);
                        }
                    } else if (sourceRoots.contains(this.getSourceDirName(library)) && !project.getFolder((IPath)(sourceDir = new Path(this.getSourceDirName(library)))).exists()) {
                        HashSet<IPath> collectedPackages = new HashSet<IPath>();
                        PluginImportHelper.extractFolderFromArchive(srcFile, (IPath)sourceDir, project.getFullPath(), collectedPackages, (IProgressMonitor)subMonitor.split(1));
                        this.addBuildEntry(buildModel, "source." + library, sourceDir.toString());
                        this.addPackageEntries(collectedPackages, (IPath)sourceDir, packageLocations);
                    }
                    ++n2;
                }
                return true;
            }
            boolean sourceFound = false;
            String[] stringArray = libraries;
            int n = libraries.length;
            int n3 = 0;
            while (n3 < n) {
                String library = stringArray[n3];
                String zipName = ClasspathUtilCore.getSourceZipName((String)library);
                IPath srcPath = manager.findSourcePath(model.getPluginBase(), (IPath)new Path(zipName));
                if (srcPath != null) {
                    sourceFound = true;
                    Path dstPath = new Path(this.getSourceDirName(library));
                    IFolder destination = project.getFolder((IPath)dstPath);
                    if (!destination.exists()) {
                        HashSet<IPath> collectedPackages = new HashSet<IPath>();
                        PluginImportHelper.extractArchive(new File(srcPath.toOSString()), destination.getFullPath(), collectedPackages, (IProgressMonitor)subMonitor.split(1));
                        this.addBuildEntry(buildModel, "source." + library, dstPath.toString());
                        this.addPackageEntries(collectedPackages, (IPath)dstPath, packageLocations);
                    }
                }
                ++n3;
            }
            return sourceFound;
        }
        return false;
    }

    private boolean handleInternalSource(IPluginModelBase model, WorkspaceBuildModel buildModel, Map<IPath, IPath> packageLocations) throws CoreException, ZipException, IOException {
        Path defaultSourcePath = new Path(DEFAULT_SOURCE_DIR);
        try (ZipFile zip = null;){
            IPath prefixPath;
            Object root;
            FileSystemStructureProvider provider;
            if (this.isJARd(model)) {
                zip = new ZipFile(new File(model.getInstallLocation()));
                provider = new ZipFileStructureProvider(zip);
                root = ((ZipFileStructureProvider)provider).getRoot();
                prefixPath = defaultSourcePath;
            } else {
                provider = FileSystemStructureProvider.INSTANCE;
                File rootFile = new File(model.getInstallLocation());
                root = rootFile;
                prefixPath = new Path(rootFile.getPath()).append((IPath)defaultSourcePath);
            }
            ArrayList<Object> collected = new ArrayList<Object>();
            PluginImportHelper.collectResourcesFromFolder((IImportStructureProvider)provider, root, (IPath)defaultSourcePath, collected);
            if (!collected.isEmpty()) {
                HashSet<IPath> packages = new HashSet<IPath>();
                PluginImportHelper.collectJavaPackages((IImportStructureProvider)provider, collected, prefixPath, packages);
                this.addPackageEntries(packages, (IPath)defaultSourcePath, packageLocations);
                this.addBuildEntry(buildModel, "source..", "src/");
                return true;
            }
            return false;
        }
    }

    private void addPackageEntries(Set<IPath> packages, IPath destination, Map<IPath, IPath> packageLocations) {
        block0: for (IPath currentPackage : packages) {
            packageLocations.put(currentPackage, destination);
            while (currentPackage.segmentCount() > 1) {
                if (packageLocations.containsKey(currentPackage = currentPackage.removeLastSegments(1))) continue block0;
                packageLocations.put(currentPackage, destination);
            }
        }
    }

    private void importAdditionalSourceFiles(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        File sourceLocation;
        SourceLocationManager manager = this.getSourceManager(model);
        if (manager != null && (sourceLocation = manager.findSourcePlugin(model.getPluginBase())) != null) {
            if (sourceLocation.isFile()) {
                ZipFile zip = null;
                try {
                    try {
                        zip = new ZipFile(sourceLocation);
                        ZipFileStructureProvider provider = new ZipFileStructureProvider(zip);
                        ArrayList<Object> collected = new ArrayList<Object>();
                        PluginImportHelper.collectNonJavaNonBuildFiles((IImportStructureProvider)provider, provider.getRoot(), collected);
                        PluginImportHelper.importContent(provider.getRoot(), project.getFullPath(), (IImportStructureProvider)provider, collected, monitor);
                    }
                    catch (IOException e) {
                        throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
            } else {
                ArrayList<Object> collected = new ArrayList<Object>();
                PluginImportHelper.collectNonJavaNonBuildFiles((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, sourceLocation, collected);
                PluginImportHelper.importContent(sourceLocation, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, collected, monitor);
            }
        }
    }

    private void importRequiredPluginFiles(IProject project, IPluginModelBase model, IProgressMonitor monitor) throws CoreException {
        if (this.isJARd(model)) {
            ZipFile zip = null;
            try {
                try {
                    zip = new ZipFile(new File(model.getInstallLocation()));
                    ZipFileStructureProvider provider = new ZipFileStructureProvider(zip);
                    ArrayList<Object> collected = new ArrayList<Object>();
                    PluginImportHelper.collectRequiredBundleFiles((IImportStructureProvider)provider, provider.getRoot(), collected);
                    PluginImportHelper.importContent(provider.getRoot(), project.getFullPath(), (IImportStructureProvider)provider, collected, monitor);
                }
                catch (IOException e) {
                    throw new CoreException(Status.error((String)e.getMessage(), (Throwable)e));
                }
            }
            catch (Throwable throwable) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException iOException) {}
            }
        } else {
            ArrayList<Object> collected = new ArrayList<Object>();
            File file = new File(model.getInstallLocation());
            PluginImportHelper.collectRequiredBundleFiles((IImportStructureProvider)FileSystemStructureProvider.INSTANCE, file, collected);
            PluginImportHelper.importContent(file, project.getFullPath(), (IImportStructureProvider)FileSystemStructureProvider.INSTANCE, collected, monitor);
        }
    }

    private String addBuildEntry(WorkspaceBuildModel model, String key, String value) throws CoreException {
        String[] tokens;
        IBuild build = model.getBuild(true);
        IBuildEntry entry = build.getEntry(key);
        if (entry == null) {
            entry = model.getFactory().createEntry(key);
            entry.addToken(value);
            build.add(entry);
        }
        return (tokens = entry.getTokens()).length > 0 ? tokens[0] : "src/";
    }

    private void configureBinIncludes(WorkspaceBuildModel buildModel, IPluginModelBase model, IProject project) throws CoreException {
        IBuild build = buildModel.getBuild(true);
        IBuildEntry entry = build.getEntry("bin.includes");
        HashMap<String, String> libraryDirs = this.getSourceDirectories(build);
        if (entry == null) {
            entry = buildModel.getFactory().createEntry("bin.includes");
            File location = new File(model.getInstallLocation());
            if (location.isDirectory()) {
                File[] files;
                File[] fileArray = files = location.listFiles();
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    String token = file.getName();
                    if (project.findMember(token) != null || build.getEntry("source." + token) != null) {
                        if (file.isDirectory() && libraryDirs.containsKey(token = String.valueOf(token) + "/")) {
                            token = libraryDirs.get(token).toString();
                        }
                        entry.addToken(token);
                    }
                    ++n2;
                }
            } else {
                String[] tokens;
                String[] stringArray = tokens = PluginImportHelper.getTopLevelResources(location);
                int n = tokens.length;
                int n3 = 0;
                while (n3 < n) {
                    String token = stringArray[n3];
                    IResource res = project.findMember(token);
                    if (!(res == null && build.getEntry("source." + token) == null || res instanceof IFolder && libraryDirs.containsKey(token))) {
                        entry.addToken(token);
                    }
                    ++n3;
                }
            }
            buildModel.getBuild().add(entry);
        }
    }

    private HashMap<String, String> getSourceDirectories(IBuild build) {
        IBuildEntry[] entries;
        HashMap<String, String> set = new HashMap<String, String>();
        IBuildEntry[] iBuildEntryArray = entries = build.getBuildEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildEntry entry = iBuildEntryArray[n2];
            String name = entry.getName();
            if (name.startsWith("source.")) {
                String[] tokens;
                name = name.substring(7);
                String[] stringArray = tokens = entry.getTokens();
                int n3 = tokens.length;
                int n4 = 0;
                while (n4 < n3) {
                    String token = stringArray[n4];
                    set.put(token, name);
                    ++n4;
                }
            }
            ++n2;
        }
        return set;
    }

    private void modifyBundleClasspathHeader(IProject project, IPluginModelBase base) {
        IFile file = PDEProject.getManifest((IProject)project);
        if (file.exists()) {
            WorkspaceBundleModel bmodel = new WorkspaceBundleModel(file);
            IBundle bundle = bmodel.getBundle();
            String classpath = bundle.getHeader("Bundle-ClassPath");
            if (classpath == null) {
                bundle.setHeader("Bundle-ClassPath", ClasspathUtilCore.getFilename((IPluginModelBase)base));
            } else {
                try {
                    ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)classpath);
                    StringBuilder buffer = new StringBuilder();
                    ManifestElement[] manifestElementArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ManifestElement element = manifestElementArray[n2];
                        if (buffer.length() > 0) {
                            buffer.append(",");
                            buffer.append(System.lineSeparator());
                            buffer.append(" ");
                        }
                        if (element.getValue().equals(DEFAULT_LIBRARY_NAME)) {
                            buffer.append(ClasspathUtilCore.getFilename((IPluginModelBase)base));
                        } else {
                            buffer.append(element.getValue());
                        }
                        ++n2;
                    }
                    bundle.setHeader("Bundle-ClassPath", buffer.toString());
                }
                catch (BundleException bundleException) {}
            }
            bmodel.save();
        }
    }

    private boolean needsJavaNature(IProject project, IPluginModelBase model) {
        IFile buildProperties;
        if (model.getPluginBase().getLibraries().length > 0) {
            return true;
        }
        BundleDescription desc = model.getBundleDescription();
        if (desc != null) {
            if (desc.getExecutionEnvironments().length > 0) {
                return true;
            }
            if (desc.getExportPackages().length > 0) {
                return true;
            }
        }
        if ((buildProperties = PDEProject.getBuildProperties((IProject)project)).exists()) {
            IBuildEntry buildEntry;
            WorkspaceBuildModel buildModel = new WorkspaceBuildModel(buildProperties);
            buildModel.load();
            IBuild build = buildModel.getBuild();
            if (build != null && (buildEntry = build.getEntry("source..")) != null) {
                return true;
            }
        }
        return false;
    }

    private void setProjectNatures(IProject project, IPluginModelBase model) throws CoreException {
        IProjectDescription desc = project.getDescription();
        if (!desc.hasNature("org.eclipse.pde.PluginNature")) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", null);
        }
        if (!desc.hasNature("org.eclipse.jdt.core.javanature") && this.needsJavaNature(project, model)) {
            CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.jdt.core.javanature", null);
        }
    }

    private String[] getLibraryNames(IPluginModelBase model) {
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        ArrayList<String> list = new ArrayList<String>();
        IPluginLibrary[] iPluginLibraryArray = libraries;
        int n = libraries.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginLibrary library = iPluginLibraryArray[n2];
            list.add(ClasspathUtilCore.expandLibraryName((String)library.getName()));
            ++n2;
        }
        if (libraries.length == 0 && this.isJARd(model)) {
            list.add(DEFAULT_LIBRARY_NAME);
        }
        return list.toArray(new String[list.size()]);
    }

    private String getSourceDirName(String libraryName) {
        int dot = libraryName.lastIndexOf(46);
        return dot != -1 ? String.valueOf(libraryName.substring(0, dot)) + DEFAULT_SOURCE_DIR : libraryName;
    }

    private boolean isJARd(IPluginModelBase model) {
        return new File(model.getInstallLocation()).isFile();
    }

    public void setImportDescriptions(Map<IBundleImporter, ScmUrlImportDescription[]> descriptions) {
        this.fImportDescriptions = descriptions;
    }

    private class NotImportedProjectsWarningDialog
    extends MessageDialog {
        private List<String> fNamesOfNotImportedProjects;

        public NotImportedProjectsWarningDialog(String warningMessage, List<String> namesOfNotImportedProjects) {
            super(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), PDEUIMessages.ImportWizard_title, null, warningMessage, 4, new String[]{IDialogConstants.OK_LABEL}, 0);
            this.fNamesOfNotImportedProjects = namesOfNotImportedProjects;
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            Text projectText = new Text(parent, 2824);
            projectText.setBackground(parent.getDisplay().getSystemColor(22));
            GridData gd = new GridData(768);
            gd.widthHint = this.convertWidthInCharsToPixels(60);
            gd.heightHint = this.convertHeightInCharsToPixels(10);
            projectText.setLayoutData((Object)gd);
            StringBuilder projectListBuffer = new StringBuilder();
            for (String project : this.fNamesOfNotImportedProjects) {
                projectListBuffer.append(project).append('\n');
            }
            projectText.setText(projectListBuffer.toString());
            return composite;
        }
    }
}

