/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection.preserve;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.selection.IMarkerSelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.preserve.Selections;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class PreserveSelectionModel<T>
implements IMarkerSelectionModel {
    private final IUniqueIndexLayer selectionLayer;
    private final IRowDataProvider<T> rowDataProvider;
    private final IRowIdAccessor<T> rowIdAccessor;
    private boolean allowMultiSelection;
    private Selections<T> selections = new Selections();
    private final ReadWriteLock selectionsLock;
    Selections.CellPosition<T> selectionAnchor;
    Selections.CellPosition<T> lastSelectedCell;
    Rectangle lastSelectedRegion;
    T lastSelectedRegionOriginRowObject;

    public PreserveSelectionModel(IUniqueIndexLayer selectionLayer, IRowDataProvider<T> rowDataProvider, IRowIdAccessor<T> rowIdAccessor) {
        this.selectionLayer = selectionLayer;
        this.rowDataProvider = rowDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        this.allowMultiSelection = true;
        this.selectionsLock = new ReentrantReadWriteLock();
    }

    @Override
    public boolean isMultipleSelectionAllowed() {
        return this.allowMultiSelection;
    }

    @Override
    public void setMultipleSelectionAllowed(boolean multipleSelectionAllowed) {
        this.allowMultiSelection = multipleSelectionAllowed;
    }

    @Override
    public void addSelection(int columnPosition, int rowPosition) {
        this.selectionsLock.writeLock().lock();
        try {
            if (!this.allowMultiSelection) {
                this.clearSelection();
            }
            this.internalAddSelection(columnPosition, rowPosition);
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void addSelection(Rectangle range) {
        this.selectionsLock.writeLock().lock();
        try {
            if (!this.allowMultiSelection) {
                this.clearSelection();
            }
            this.performOnKnownCells(range, new SelectionOperation(){

                @Override
                public void run(int columnPosition, int rowPosition) {
                    PreserveSelectionModel.this.internalAddSelection(columnPosition, rowPosition);
                }
            });
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    private void internalAddSelection(int columnPosition, int rowPosition) {
        T rowObject = this.getRowObjectByPosition(rowPosition);
        if (rowObject != null) {
            Serializable rowId = this.rowIdAccessor.getRowId(rowObject);
            this.selections.select(rowId, rowObject, columnPosition);
        }
    }

    @Override
    public void clearSelection() {
        this.selectionsLock.writeLock().lock();
        try {
            this.selections.clear();
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearSelection(int columnPosition, int rowPosition) {
        this.selectionsLock.writeLock().lock();
        try {
            this.internalClearSelection(columnPosition, rowPosition);
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void clearSelection(Rectangle removedSelection) {
        this.selectionsLock.writeLock().lock();
        try {
            this.performOnKnownCells(removedSelection, new SelectionOperation(){

                @Override
                public void run(int columnPosition, int rowPosition) {
                    PreserveSelectionModel.this.internalClearSelection(columnPosition, rowPosition);
                }
            });
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    private void internalClearSelection(int columnPosition, int rowPosition) {
        T rowObject = this.getRowObjectByPosition(rowPosition);
        if (rowObject != null) {
            Serializable rowId = this.rowIdAccessor.getRowId(rowObject);
            this.selections.deselect(rowId, columnPosition);
        }
    }

    private void performOnKnownCells(Rectangle selection, SelectionOperation selectionOperation) {
        int columnCount = this.selectionLayer.getColumnCount();
        int rowCount = this.selectionLayer.getRowCount();
        int startColumnPosition = selection.x;
        int startRowPosition = selection.y;
        if (startColumnPosition < columnCount && startRowPosition < rowCount) {
            int numberOfVisibleColumnsToBeSelected = selection.x + selection.width <= columnCount ? selection.width : columnCount;
            int numberOfVisibleRowsToBeSelected = selection.y + selection.height <= rowCount ? selection.height : rowCount;
            int columnPosition = startColumnPosition;
            while (columnPosition < startColumnPosition + numberOfVisibleColumnsToBeSelected) {
                int rowPosition = startRowPosition;
                while (rowPosition < startRowPosition + numberOfVisibleRowsToBeSelected) {
                    selectionOperation.run(columnPosition, rowPosition);
                    ++rowPosition;
                }
                ++columnPosition;
            }
        }
    }

    @Override
    public boolean isEmpty() {
        this.selectionsLock.readLock().lock();
        try {
            boolean bl = this.selections.isEmpty();
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public List<Rectangle> getSelections() {
        ArrayList<Rectangle> selectedCells = new ArrayList<Rectangle>();
        this.selectionsLock.readLock().lock();
        try {
            for (Selections.CellPosition<T> cellPosition : this.selections.getSelections()) {
                int rowPosition = this.getRowPositionByRowObject(cellPosition.getRowObject());
                if (!this.isRowVisible(rowPosition)) continue;
                Integer columnPosition = cellPosition.getColumnPosition();
                Rectangle selectedCell = new Rectangle(columnPosition.intValue(), rowPosition, 1, 1);
                selectedCells.add(selectedCell);
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return selectedCells;
    }

    private boolean isRowVisible(int rowPosition) {
        return rowPosition != -1;
    }

    @Override
    public boolean isCellPositionSelected(int columnPosition, int rowPosition) {
        this.selectionsLock.readLock().lock();
        try {
            int cellOriginRowPosition;
            ILayerCell cell = this.selectionLayer.getCellByPosition(columnPosition, rowPosition);
            int candidateRowPosition = cellOriginRowPosition = cell.getOriginRowPosition();
            while (candidateRowPosition < cellOriginRowPosition + cell.getRowSpan()) {
                int cellOriginColumnPosition;
                Serializable rowId = this.getRowIdByPosition(candidateRowPosition);
                int candidateColumnPosition = cellOriginColumnPosition = cell.getOriginColumnPosition();
                while (candidateColumnPosition < cellOriginColumnPosition + cell.getColumnSpan()) {
                    if (this.selections.isSelected(rowId, candidateColumnPosition)) {
                        return true;
                    }
                    ++candidateColumnPosition;
                }
                ++candidateRowPosition;
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return false;
    }

    @Override
    public int[] getSelectedColumnPositions() {
        this.selectionsLock.readLock().lock();
        try {
            List<Integer> columnPositions = this.selections.getColumnPositions();
            int[] nArray = ArrayUtil.asIntArray(columnPositions);
            return nArray;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public boolean isColumnPositionSelected(int columnPosition) {
        this.selectionsLock.readLock().lock();
        try {
            for (Selections.Row<T> row : this.selections.getRows()) {
                if (!row.contains(columnPosition)) continue;
                return true;
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return false;
    }

    @Override
    public int[] getFullySelectedColumnPositions(int columnHeight) {
        this.selectionsLock.readLock().lock();
        try {
            ArrayList<Integer> fullySelectedColumnPositions = new ArrayList<Integer>();
            for (Integer selectedColumn : this.selections.getColumnPositions()) {
                if (!this.isColumnPositionFullySelected(selectedColumn, columnHeight)) continue;
                fullySelectedColumnPositions.add(selectedColumn);
            }
            int[] nArray = ArrayUtil.asIntArray(fullySelectedColumnPositions);
            return nArray;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public boolean isColumnPositionFullySelected(int columnPosition, int columnHeight) {
        TreeSet<Integer> selectedRowIndices = new TreeSet<Integer>();
        this.selectionsLock.readLock().lock();
        try {
            Selections.Column selectedRowsInColumn = this.selections.getSelectedRows(columnPosition);
            if (this.hasColumnsSelectedRows(selectedRowsInColumn)) {
                for (Serializable rowId : selectedRowsInColumn.getItems()) {
                    Selections.Row<T> row = this.selections.getSelectedColumns(rowId);
                    T rowObject = row.getRowObject();
                    int rowIndex = this.rowDataProvider.indexOfRowObject(rowObject);
                    selectedRowIndices.add(rowIndex);
                }
            }
            boolean bl = this.hasContinuousSection(selectedRowIndices, columnHeight);
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    private boolean hasColumnsSelectedRows(Selections.Column column) {
        return column != null;
    }

    private boolean hasContinuousSection(TreeSet<Integer> sequence, int minimumLength) {
        int counter = 0;
        Integer previousValue = null;
        for (Integer index : sequence) {
            if (previousValue != null && index != previousValue + 1) {
                counter = 0;
            }
            previousValue = index;
            if (++counter != minimumLength) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getSelectedRowCount() {
        this.selectionsLock.readLock().lock();
        try {
            int n = this.selections.getRows().size();
            return n;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public Set<Range> getSelectedRowPositions() {
        HashSet<Range> visiblySelectedRowPositions = new HashSet<Range>();
        this.selectionsLock.readLock().lock();
        try {
            for (Selections.Row<T> row : this.selections.getRows()) {
                int rowPosition = this.getRowPositionByRowObject(row.getRowObject());
                if (!this.isRowVisible(rowPosition)) continue;
                visiblySelectedRowPositions.add(new Range(rowPosition, rowPosition + 1));
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return visiblySelectedRowPositions;
    }

    @Override
    public boolean isRowPositionSelected(int rowPosition) {
        this.selectionsLock.readLock().lock();
        try {
            Serializable rowId = this.getRowIdByPosition(rowPosition);
            boolean bl = this.selections.isRowSelected(rowId);
            return bl;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public int[] getFullySelectedRowPositions(int rowWidth) {
        this.selectionsLock.readLock().lock();
        try {
            ArrayList<Integer> fullySelectedRows = new ArrayList<Integer>();
            for (Selections.Row<T> selectedRow : this.selections.getRows()) {
                T rowObject = selectedRow.getRowObject();
                int rowPosition = this.getRowPositionByRowObject(rowObject);
                if (!this.isRowVisible(rowPosition) || !this.isRowPositionFullySelected(rowPosition, rowWidth)) continue;
                fullySelectedRows.add(rowPosition);
            }
            Collections.sort(fullySelectedRows);
            int[] nArray = ArrayUtil.asIntArray(fullySelectedRows);
            return nArray;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public boolean isRowPositionFullySelected(int rowPosition, int rowWidth) {
        TreeSet<Integer> selectedColumnPositions = new TreeSet<Integer>();
        this.selectionsLock.readLock().lock();
        try {
            Serializable rowId;
            Selections.Row<T> selectedColumnsInRow;
            T rowObject = this.getRowObjectByPosition(rowPosition);
            if (rowObject != null && this.hasRowSelectedColumns(selectedColumnsInRow = this.selections.getSelectedColumns(rowId = this.rowIdAccessor.getRowId(rowObject)))) {
                for (Integer columnPosition : selectedColumnsInRow.getItems()) {
                    selectedColumnPositions.add(columnPosition);
                }
            }
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
        return this.hasContinuousSection(selectedColumnPositions, rowWidth);
    }

    private boolean hasRowSelectedColumns(Selections.Row<T> row) {
        return row != null;
    }

    private Serializable getRowIdByPosition(int rowPosition) {
        T rowObject = this.getRowObjectByPosition(rowPosition);
        if (rowObject != null) {
            return this.rowIdAccessor.getRowId(rowObject);
        }
        return null;
    }

    private T getRowObjectByPosition(int rowPosition) {
        int rowIndex = this.selectionLayer.getRowIndexByPosition(rowPosition);
        if (rowIndex >= 0) {
            try {
                return this.rowDataProvider.getRowObject(rowIndex);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private int getRowPositionByRowObject(T rowObject) {
        int rowIndex = this.rowDataProvider.indexOfRowObject(rowObject);
        if (rowIndex == -1) {
            return -1;
        }
        return this.selectionLayer.getRowPositionByIndex(rowIndex);
    }

    @Override
    public Point getSelectionAnchor() {
        this.selectionsLock.readLock().lock();
        try {
            Point point = this.createMarkerPoint(this.selectionAnchor);
            return point;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    @Override
    public Point getLastSelectedCell() {
        this.selectionsLock.readLock().lock();
        try {
            Point point = this.createMarkerPoint(this.lastSelectedCell);
            return point;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    private Point createMarkerPoint(Selections.CellPosition<T> cellPosition) {
        if (cellPosition == null) {
            return this.createUndefinedPoint();
        }
        int rowPosition = this.getRowPositionByRowObject(cellPosition.getRowObject());
        return new Point(cellPosition.getColumnPosition().intValue(), rowPosition);
    }

    private Point createUndefinedPoint() {
        return new Point(-1, -1);
    }

    @Override
    public Rectangle getLastSelectedRegion() {
        this.selectionsLock.readLock().lock();
        try {
            if (this.lastSelectedRegion == null) {
                return null;
            }
            this.correctLastSelectedRegion();
            Rectangle rectangle = this.lastSelectedRegion;
            return rectangle;
        }
        finally {
            this.selectionsLock.readLock().unlock();
        }
    }

    private void correctLastSelectedRegion() {
        this.lastSelectedRegion.y = this.getRowPositionByRowObject(this.lastSelectedRegionOriginRowObject);
    }

    @Override
    public void setSelectionAnchor(Point coordinate) {
        this.selectionsLock.writeLock().lock();
        try {
            this.selectionAnchor = new Selections.CellPosition<T>(this.getRowObjectByPosition(coordinate.y), coordinate.x);
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void setLastSelectedCell(Point coordinate) {
        this.selectionsLock.writeLock().lock();
        try {
            this.lastSelectedCell = new Selections.CellPosition<T>(this.getRowObjectByPosition(coordinate.y), coordinate.x);
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void setLastSelectedRegion(Rectangle region) {
        this.selectionsLock.writeLock().lock();
        try {
            if (region != null && this.lastSelectedRegion != null) {
                this.performOnKnownCells(this.lastSelectedRegion, new SelectionOperation(){

                    @Override
                    public void run(int columnPosition, int rowPosition) {
                        PreserveSelectionModel.this.internalClearSelection(columnPosition, rowPosition);
                    }
                });
            }
            this.lastSelectedRegion = region;
            if (region != null) {
                this.lastSelectedRegionOriginRowObject = this.getRowObjectByPosition(region.y);
            }
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void setLastSelectedRegion(int x, int y, int width, int height) {
        this.selectionsLock.writeLock().lock();
        try {
            this.lastSelectedRegion.x = x;
            this.lastSelectedRegion.y = y;
            this.lastSelectedRegion.width = width;
            this.lastSelectedRegion.height = height;
            this.lastSelectedRegionOriginRowObject = this.getRowObjectByPosition(y);
        }
        finally {
            this.selectionsLock.writeLock().unlock();
        }
    }

    @Override
    public void handleLayerEvent(IStructuralChangeEvent event) {
        Collection<StructuralDiff> diffs;
        if (event.isHorizontalStructureChanged() && (diffs = event.getColumnDiffs()) != null) {
            int i;
            for (StructuralDiff structuralDiff : diffs) {
                if (structuralDiff.getDiffType() == null || !structuralDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.DELETE)) continue;
                Range beforePositionRange = structuralDiff.getBeforePositionRange();
                i = beforePositionRange.start;
                while (i < beforePositionRange.end) {
                    this.selections.deselectColumn(i);
                    this.selections.updateColumnsForRemoval(i);
                    ++i;
                }
            }
            for (StructuralDiff structuralDiff : diffs) {
                if (structuralDiff.getDiffType() == null || !structuralDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.ADD)) continue;
                Range afterPositionRange = structuralDiff.getAfterPositionRange();
                i = afterPositionRange.start;
                while (i < afterPositionRange.end) {
                    this.selections.updateColumnsForAddition(i);
                    ++i;
                }
            }
        }
        if (event.isVerticalStructureChanged()) {
            ArrayList<Serializable> keysToRemove = new ArrayList<Serializable>();
            for (Selections.Row row : this.selections.getRows()) {
                int rowIndex = this.rowDataProvider.indexOfRowObject(row.getRowObject());
                if (rowIndex != -1) continue;
                keysToRemove.add((Serializable)row.getId());
            }
            for (Serializable serializable : keysToRemove) {
                this.selections.deselectRow(serializable);
            }
        }
    }

    @Override
    public Class<IStructuralChangeEvent> getLayerEventClass() {
        return IStructuralChangeEvent.class;
    }

    static interface SelectionOperation {
        public void run(int var1, int var2);
    }
}

