/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.integration.navigator;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.ISEIChildList;
import org.eclipse.jst.ws.jaxws.dom.integration.navigator.IWebServiceChildList;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebServiceProject;
import org.eclipse.jst.ws.jaxws.dom.ui.DomItemProviderAdapterFactory;

public class CustomDomItemProviderAdapterFactory
extends DomItemProviderAdapterFactory {
    public static final CustomDomItemProviderAdapterFactory INSTANCE = new CustomDomItemProviderAdapterFactory();

    private CustomDomItemProviderAdapterFactory() {
        this.supportedTypes.add(IWebServiceChildList.class);
        this.supportedTypes.add(ISEIChildList.class);
    }

    protected Adapter createIWebServiceChildListAdapter(final IWebServiceProject wsProj) {
        return new IWebServiceChildList(){

            @Override
            public EList<IWebService> getWSChildList() {
                return wsProj.getWebServices();
            }

            public Notifier getTarget() {
                return wsProj;
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }

            public void notifyChanged(Notification notification) {
            }

            public void setTarget(Notifier newTarget) {
            }
        };
    }

    protected Adapter createISEIChildListAdapter(final IWebServiceProject wsProj) {
        return new ISEIChildList(){

            @Override
            public EList<IServiceEndpointInterface> getSEIChildList() {
                return wsProj.getServiceEndpointInterfaces();
            }

            public Notifier getTarget() {
                return wsProj;
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }

            public void notifyChanged(Notification notification) {
            }

            public void setTarget(Notifier newTarget) {
            }
        };
    }

    public Adapter adapt(Notifier notifier, Object type) {
        if (notifier instanceof IWebServiceProject && type instanceof Class) {
            if (type.equals(IWebServiceChildList.class)) {
                return this.adaptIWebServiceChildList((IWebServiceProject)notifier);
            }
            if (type.equals(ISEIChildList.class)) {
                return this.adaptISEIChildList((IWebServiceProject)notifier);
            }
        }
        return super.adapt(notifier, type);
    }

    protected Adapter adaptISEIChildList(IWebServiceProject wsProject) {
        Adapter adapter2;
        for (Adapter adapter2 : wsProject.eAdapters()) {
            if (!(adapter2 instanceof ISEIChildList)) continue;
            return adapter2;
        }
        adapter2 = this.createISEIChildListAdapter(wsProject);
        this.associate(adapter2, (Notifier)wsProject);
        return adapter2;
    }

    protected Adapter adaptIWebServiceChildList(IWebServiceProject wsProject) {
        Adapter adapter2;
        for (Adapter adapter2 : wsProject.eAdapters()) {
            if (!(adapter2 instanceof IWebServiceChildList)) continue;
            return adapter2;
        }
        adapter2 = this.createIWebServiceChildListAdapter(wsProject);
        this.associate(adapter2, (Notifier)wsProject);
        return adapter2;
    }
}

