/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.classpathdep;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.internal.modulecore.IClasspathDependencyComponent;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class ClasspathDependencyVirtualComponent
extends J2EEModuleVirtualArchiveComponent
implements IClasspathDependencyComponent {
    private final boolean isClassFolder;

    public ClasspathDependencyVirtualComponent(IProject aComponentProject, String location, boolean isClassFolder) {
        super(aComponentProject, location, null);
        this.isClassFolder = isClassFolder;
    }

    public boolean isClassFolder() {
        return this.isClassFolder;
    }

    public IContainer getClassFolder() {
        if (!this.isClassFolder) {
            return null;
        }
        Path path = new Path(this.getName().substring(4));
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer[] allContainers = root.findContainersForLocation((IPath)path);
        if (allContainers == null || allContainers.length == 0 || allContainers[0].getType() == 8) {
            return null;
        }
        return allContainers[0];
    }

    @Override
    public IVirtualReference[] getReferences() {
        if (this.isClassFolder) {
            return NO_REFERENCES;
        }
        return super.getReferences();
    }

    @Override
    public String[] getManifestClasspath() {
        if (this.isClassFolder) {
            return new String[0];
        }
        return super.getManifestClasspath();
    }

    public Object getAdapter(Class clazz) {
        if (this.isClassFolder && clazz.equals(IPath.class)) {
            return this.getClassFolder().getLocation();
        }
        return super.getAdapter(clazz);
    }
}

