/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.core.zafarkhaja.semver.util;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.embedcdt.core.zafarkhaja.semver.util.UnexpectedElementException;

public class Stream<E>
implements Iterable<E> {
    private final E[] elements;
    private int offset = 0;

    public Stream(E[] elements) {
        this.elements = (Object[])elements.clone();
    }

    public E consume() {
        if (this.offset >= this.elements.length) {
            return null;
        }
        return this.elements[this.offset++];
    }

    public <T extends ElementType<E>> E consume(T ... expected) {
        E lookahead = this.lookahead(1);
        T[] TArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            T type = TArray[n2];
            if (type.isMatchedBy(lookahead)) {
                return this.consume();
            }
            ++n2;
        }
        throw new UnexpectedElementException(lookahead, this.offset, (ElementType<?>[])expected);
    }

    public void pushBack() {
        if (this.offset > 0) {
            --this.offset;
        }
    }

    public E lookahead() {
        return this.lookahead(1);
    }

    public E lookahead(int position) {
        int idx = this.offset + position - 1;
        if (idx < this.elements.length) {
            return this.elements[idx];
        }
        return null;
    }

    public int currentOffset() {
        return this.offset;
    }

    public <T extends ElementType<E>> boolean positiveLookahead(T ... expected) {
        T[] TArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            T type = TArray[n2];
            if (type.isMatchedBy(this.lookahead(1))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public <T extends ElementType<E>> boolean positiveLookaheadBefore(ElementType<E> before, T ... expected) {
        int i = 1;
        while (i <= this.elements.length) {
            E lookahead = this.lookahead(i);
            if (before.isMatchedBy(lookahead)) break;
            T[] TArray = expected;
            int n = expected.length;
            int n2 = 0;
            while (n2 < n) {
                T type = TArray[n2];
                if (type.isMatchedBy(lookahead)) {
                    return true;
                }
                ++n2;
            }
            ++i;
        }
        return false;
    }

    public <T extends ElementType<E>> boolean positiveLookaheadUntil(int until, T ... expected) {
        int i = 1;
        while (i <= until) {
            T[] TArray = expected;
            int n = expected.length;
            int n2 = 0;
            while (n2 < n) {
                T type = TArray[n2];
                if (type.isMatchedBy(this.lookahead(i))) {
                    return true;
                }
                ++n2;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int index;
            {
                this.index = Stream.this.offset;
            }

            @Override
            public boolean hasNext() {
                return this.index < Stream.this.elements.length;
            }

            @Override
            public E next() {
                if (this.index >= Stream.this.elements.length) {
                    throw new NoSuchElementException();
                }
                return Stream.this.elements[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public E[] toArray() {
        return Arrays.copyOfRange(this.elements, this.offset, this.elements.length);
    }

    public static interface ElementType<E> {
        public boolean isMatchedBy(E var1);
    }
}

