/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ti.goals;

import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.ast.ASTNode;

public class PossiblePosition {
    private final IResource resource;
    private final int offset;
    private final int length;
    private final ASTNode node;

    public PossiblePosition(IResource resource, int offset, int length) {
        this.resource = resource;
        this.offset = offset;
        this.length = length;
        this.node = null;
    }

    public PossiblePosition(IResource resource, int offset, int length, ASTNode node) {
        this.resource = resource;
        this.offset = offset;
        this.length = length;
        this.node = node;
    }

    public IResource getResource() {
        return this.resource;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public ASTNode getNode() {
        return this.node;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.offset;
        result = 31 * result + this.length;
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PossiblePosition other = (PossiblePosition)obj;
        if (this.offset != other.offset) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.node == null ? other.node != null : !this.node.equals(other.node)) {
            return false;
        }
        return !(this.resource == null ? other.resource != null : !this.resource.equals((Object)other.resource));
    }
}

