/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.keyverifier;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.config.hosts.KnownHostHashValue;
import org.apache.sshd.client.keyverifier.ModifiedServerKeyAcceptor;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.config.keys.AuthorizedKeyEntry;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class KnownHostsServerKeyVerifier
extends ModifiableFileWatcher
implements ServerKeyVerifier,
ModifiedServerKeyAcceptor {
    public static final String STRICT_CHECKING_OPTION = "StrictHostKeyChecking";
    public static final String KNOWN_HOSTS_FILE_OPTION = "UserKnownHostsFile";
    protected final Object updateLock = new Object();
    private final ServerKeyVerifier delegate;
    private final AtomicReference<Supplier<? extends Collection<HostEntryPair>>> keysSupplier = new AtomicReference<Supplier<Collection<HostEntryPair>>>(this.getKnownHostSupplier(null, this.getPath()));
    private ModifiedServerKeyAcceptor modKeyAcceptor;

    public KnownHostsServerKeyVerifier(ServerKeyVerifier delegate, Path file) {
        this(delegate, file, IoUtils.EMPTY_LINK_OPTIONS);
    }

    public KnownHostsServerKeyVerifier(ServerKeyVerifier delegate, Path file, LinkOption ... options) {
        super(file, options);
        this.delegate = Objects.requireNonNull(delegate, "No delegate");
    }

    public ServerKeyVerifier getDelegateVerifier() {
        return this.delegate;
    }

    public ModifiedServerKeyAcceptor getModifiedServerKeyAcceptor() {
        return this.modKeyAcceptor;
    }

    public void setModifiedServerKeyAcceptor(ModifiedServerKeyAcceptor acceptor) {
        this.modKeyAcceptor = acceptor;
    }

    @Override
    public boolean verifyServerKey(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        try {
            if (this.checkReloadRequired()) {
                Path file = this.getPath();
                if (this.exists()) {
                    this.updateReloadAttributes();
                    this.keysSupplier.set(GenericUtils.memoizeLock(this.getKnownHostSupplier(clientSession, file)));
                } else {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("verifyServerKey({})[{}] missing known hosts file {}", new Object[]{clientSession, remoteAddress, file});
                    }
                    this.keysSupplier.set(GenericUtils.memoizeLock(Collections::emptyList));
                }
            }
        }
        catch (Throwable t) {
            return this.acceptIncompleteHostKeys(clientSession, remoteAddress, serverKey, t);
        }
        Collection<HostEntryPair> knownHosts = this.keysSupplier.get().get();
        return this.acceptKnownHostEntries(clientSession, remoteAddress, serverKey, knownHosts);
    }

    protected Supplier<Collection<HostEntryPair>> getKnownHostSupplier(ClientSession clientSession, Path file) {
        return () -> {
            try {
                return this.reloadKnownHosts(clientSession, file);
            }
            catch (Exception e) {
                this.log.warn("verifyServerKey({}) Could not reload known hosts file {}", new Object[]{clientSession, file, e});
                return Collections.emptyList();
            }
        };
    }

    protected void setLoadedHostsEntries(Collection<HostEntryPair> keys) {
        this.keysSupplier.set(() -> keys);
    }

    protected List<HostEntryPair> reloadKnownHosts(ClientSession session, Path file) throws IOException, GeneralSecurityException {
        List<KnownHostEntry> entries = KnownHostEntry.readKnownHostEntries(file, new OpenOption[0]);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("reloadKnownHosts({}) loaded {} entries", (Object)file, (Object)entries.size());
        }
        this.updateReloadAttributes();
        if (GenericUtils.isEmpty(entries)) {
            return Collections.emptyList();
        }
        ArrayList<HostEntryPair> keys = new ArrayList<HostEntryPair>(entries.size());
        PublicKeyEntryResolver resolver = this.getFallbackPublicKeyEntryResolver();
        for (KnownHostEntry entry : entries) {
            try {
                PublicKey key = this.resolveHostKey(session, entry, resolver);
                if (key == null) continue;
                keys.add(new HostEntryPair(entry, key));
            }
            catch (Throwable t) {
                this.warn("reloadKnownHosts({}) failed ({}) to load key of {}: {}", file, t.getClass().getSimpleName(), entry, t.getMessage(), t);
            }
        }
        return keys;
    }

    protected PublicKey resolveHostKey(ClientSession session, KnownHostEntry entry, PublicKeyEntryResolver resolver) throws IOException, GeneralSecurityException {
        if (entry == null) {
            return null;
        }
        AuthorizedKeyEntry authEntry = ValidateUtils.checkNotNull(entry.getKeyEntry(), "No key extracted from %s", (Object)entry);
        PublicKey key = authEntry.resolvePublicKey(session, resolver);
        if (this.log.isDebugEnabled()) {
            this.log.debug("resolveHostKey({}) loaded {}-{}", new Object[]{entry, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key)});
        }
        return key;
    }

    protected PublicKeyEntryResolver getFallbackPublicKeyEntryResolver() {
        return PublicKeyEntryResolver.IGNORING;
    }

    protected boolean acceptKnownHostEntries(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey, Collection<HostEntryPair> knownHosts) {
        HostEntryPair match = this.findKnownHostEntry(clientSession, remoteAddress, knownHosts);
        if (match == null) {
            return this.acceptUnknownHostKey(clientSession, remoteAddress, serverKey);
        }
        KnownHostEntry entry = match.getHostEntry();
        PublicKey expected = match.getServerKey();
        if (KeyUtils.compareKeys(expected, serverKey)) {
            return this.acceptKnownHostEntry(clientSession, remoteAddress, serverKey, entry);
        }
        try {
            if (!this.acceptModifiedServerKey(clientSession, remoteAddress, entry, expected, serverKey)) {
                return false;
            }
        }
        catch (Throwable t) {
            this.warn("acceptKnownHostEntries({})[{}] failed ({}) to accept modified server key: {}", clientSession, remoteAddress, t.getClass().getSimpleName(), t.getMessage(), t);
            return false;
        }
        Path file = this.getPath();
        try {
            this.updateModifiedServerKey(clientSession, remoteAddress, match, serverKey, file, knownHosts);
        }
        catch (Throwable t) {
            this.handleModifiedServerKeyUpdateFailure(clientSession, remoteAddress, match, serverKey, file, knownHosts, t);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateModifiedServerKey(ClientSession clientSession, SocketAddress remoteAddress, HostEntryPair match, PublicKey actual, Path file, Collection<HostEntryPair> knownHosts) throws Exception {
        String matchLine;
        KnownHostEntry entry = match.getHostEntry();
        String newLine = this.prepareModifiedServerKeyLine(clientSession, remoteAddress, entry, matchLine = ValidateUtils.checkNotNullAndNotEmpty(entry.getConfigLine(), "No entry config line"), match.getServerKey(), actual);
        if (GenericUtils.isEmpty(newLine)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("updateModifiedServerKey({})[{}] no replacement generated for {}", new Object[]{clientSession, remoteAddress, matchLine});
            }
            return;
        }
        if (matchLine.equals(newLine)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("updateModifiedServerKey({})[{}] unmodified updated line for {}", new Object[]{clientSession, remoteAddress, matchLine});
            }
            return;
        }
        ArrayList<String> lines = new ArrayList<String>();
        Object object = this.updateLock;
        synchronized (object) {
            int matchingIndex = -1;
            try (BufferedReader rdr = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                String line = rdr.readLine();
                while (line != null) {
                    if (matchingIndex >= 0) {
                        lines.add(line);
                    } else if (GenericUtils.isEmpty(line = GenericUtils.trimToEmpty(line))) {
                        lines.add(line);
                    } else {
                        int pos = line.indexOf(35);
                        if (pos == 0) {
                            lines.add(line);
                        } else {
                            if (pos > 0) {
                                line = line.substring(0, pos);
                                line = line.trim();
                            }
                            if (!matchLine.equals(line)) {
                                lines.add(line);
                            } else {
                                lines.add(newLine);
                                matchingIndex = lines.size();
                            }
                        }
                    }
                    line = rdr.readLine();
                }
            }
            ValidateUtils.checkTrue(matchingIndex >= 0, "No match found for line=%s", (Object)matchLine);
            try (BufferedWriter w = Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]);){
                for (String l : lines) {
                    w.append(l).append(IoUtils.EOL);
                }
            }
            HostEntryPair hostEntryPair = match;
            synchronized (hostEntryPair) {
                match.setServerKey(actual);
                entry.setConfigLine(newLine);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("updateModifiedServerKey({}) replaced '{}' with '{}'", new Object[]{file, matchLine, newLine});
        }
        this.resetReloadAttributes();
    }

    protected String prepareModifiedServerKeyLine(ClientSession clientSession, SocketAddress remoteAddress, KnownHostEntry entry, String curLine, PublicKey expected, PublicKey actual) throws Exception {
        if (entry == null || GenericUtils.isEmpty(curLine)) {
            return curLine;
        }
        int pos = curLine.indexOf(32);
        if (curLine.charAt(0) == '@') {
            ++pos;
            while (pos < curLine.length() && curLine.charAt(pos) == ' ') {
                ++pos;
            }
            pos = pos < curLine.length() ? curLine.indexOf(32, pos) : -1;
        }
        ValidateUtils.checkTrue(pos > 0 && pos < curLine.length() - 1, "Missing encoded key in line=%s", (Object)curLine);
        StringBuilder sb = new StringBuilder(curLine.length());
        sb.append(curLine.substring(0, pos));
        PublicKeyEntry.appendPublicKeyEntry(sb.append(' '), actual);
        return sb.toString();
    }

    protected void handleModifiedServerKeyUpdateFailure(ClientSession clientSession, SocketAddress remoteAddress, HostEntryPair match, PublicKey serverKey, Path file, Collection<HostEntryPair> knownHosts, Throwable reason) {
        this.warn("acceptKnownHostEntries({})[{}] failed ({}) to update modified server key of {}: {}", clientSession, remoteAddress, reason.getClass().getSimpleName(), match, reason.getMessage(), reason);
    }

    protected boolean acceptKnownHostEntry(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey, KnownHostEntry entry) {
        if (entry == null) {
            return this.acceptUnknownHostKey(clientSession, remoteAddress, serverKey);
        }
        if ("revoked".equals(entry.getMarker())) {
            this.log.debug("acceptKnownHostEntry({})[{}] key={}-{} marked as {}", new Object[]{clientSession, remoteAddress, KeyUtils.getKeyType(serverKey), KeyUtils.getFingerPrint(serverKey), entry.getMarker()});
            return false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("acceptKnownHostEntry({})[{}] matched key={}-{}", new Object[]{clientSession, remoteAddress, KeyUtils.getKeyType(serverKey), KeyUtils.getFingerPrint(serverKey)});
        }
        return true;
    }

    protected HostEntryPair findKnownHostEntry(ClientSession clientSession, SocketAddress remoteAddress, Collection<HostEntryPair> knownHosts) {
        if (GenericUtils.isEmpty(knownHosts)) {
            return null;
        }
        Collection<SshdSocketAddress> candidates = this.resolveHostNetworkIdentities(clientSession, remoteAddress);
        boolean debugEnabled = this.log.isDebugEnabled();
        if (debugEnabled) {
            this.log.debug("findKnownHostEntry({})[{}] host network identities: {}", new Object[]{clientSession, remoteAddress, candidates});
        }
        if (GenericUtils.isEmpty(candidates)) {
            return null;
        }
        for (HostEntryPair match : knownHosts) {
            KnownHostEntry entry = match.getHostEntry();
            for (SshdSocketAddress host : candidates) {
                try {
                    if (!entry.isHostMatch(host.getHostName(), host.getPort())) continue;
                    if (debugEnabled) {
                        this.log.debug("findKnownHostEntry({})[{}] matched host={} for entry={}", new Object[]{clientSession, remoteAddress, host, entry});
                    }
                    return match;
                }
                catch (Error | RuntimeException e) {
                    this.warn("findKnownHostEntry({})[{}] failed ({}) to check host={} for entry={}: {}", clientSession, remoteAddress, e.getClass().getSimpleName(), host, entry.getConfigLine(), e.getMessage(), e);
                }
            }
        }
        return null;
    }

    protected boolean acceptIncompleteHostKeys(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey, Throwable reason) {
        this.warn("Failed ({}) to reload server keys from {}: {}", reason.getClass().getSimpleName(), this.getPath(), reason.getMessage(), reason);
        return this.acceptUnknownHostKey(clientSession, remoteAddress, serverKey);
    }

    protected boolean acceptUnknownHostKey(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("acceptUnknownHostKey({}) host={}, key={}", new Object[]{clientSession, remoteAddress, KeyUtils.getFingerPrint(serverKey)});
        }
        if (this.delegate.verifyServerKey(clientSession, remoteAddress, serverKey)) {
            Path file = this.getPath();
            Collection<HostEntryPair> keys = this.keysSupplier.get().get();
            try {
                this.updateKnownHostsFile(clientSession, remoteAddress, serverKey, file, keys);
            }
            catch (Throwable t) {
                this.handleKnownHostsFileUpdateFailure(clientSession, remoteAddress, serverKey, file, keys, t);
            }
            return true;
        }
        return false;
    }

    protected void handleKnownHostsFileUpdateFailure(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey, Path file, Collection<HostEntryPair> knownHosts, Throwable reason) {
        this.warn("handleKnownHostsFileUpdateFailure({})[{}] failed ({}) to update key={}-{} in {}: {}", clientSession, remoteAddress, reason.getClass().getSimpleName(), KeyUtils.getKeyType(serverKey), KeyUtils.getFingerPrint(serverKey), file, reason.getMessage(), reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected KnownHostEntry updateKnownHostsFile(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey, Path file, Collection<HostEntryPair> knownHosts) throws Exception {
        KnownHostEntry entry = this.prepareKnownHostEntry(clientSession, remoteAddress, serverKey);
        if (entry == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("updateKnownHostsFile({})[{}] no entry generated for key={}", new Object[]{clientSession, remoteAddress, KeyUtils.getFingerPrint(serverKey)});
            }
            return null;
        }
        String line = entry.getConfigLine();
        byte[] lineData = line.getBytes(StandardCharsets.UTF_8);
        boolean reuseExisting = Files.exists(file, new LinkOption[0]) && Files.size(file) > 0L;
        byte[] eolBytes = IoUtils.getEOLBytes();
        Object object = this.updateLock;
        synchronized (object) {
            try (OutputStream output = reuseExisting ? Files.newOutputStream(file, StandardOpenOption.APPEND) : Files.newOutputStream(file, new OpenOption[0]);){
                if (reuseExisting) {
                    output.write(eolBytes);
                }
                output.write(lineData);
                output.write(eolBytes);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("updateKnownHostsFile({}) updated: {}", (Object)file, (Object)entry);
        }
        this.resetReloadAttributes();
        return entry;
    }

    protected KnownHostEntry prepareKnownHostEntry(ClientSession clientSession, SocketAddress remoteAddress, PublicKey serverKey) throws Exception {
        Collection<SshdSocketAddress> patterns = this.resolveHostNetworkIdentities(clientSession, remoteAddress);
        if (GenericUtils.isEmpty(patterns)) {
            return null;
        }
        StringBuilder sb = new StringBuilder(127);
        Random rnd = null;
        for (SshdSocketAddress hostIdentity : patterns) {
            NamedFactory<Mac> digester;
            if (sb.length() > 0) {
                sb.append(',');
            }
            if ((digester = this.getHostValueDigester(clientSession, remoteAddress, hostIdentity)) != null) {
                if (rnd == null) {
                    FactoryManager manager = Objects.requireNonNull(clientSession.getFactoryManager(), "No factory manager");
                    Factory<? extends Random> factory = Objects.requireNonNull(manager.getRandomFactory(), "No random factory");
                    rnd = Objects.requireNonNull(factory.create(), "No randomizer created");
                }
                Mac mac = (Mac)digester.create();
                int blockSize = mac.getDefaultBlockSize();
                byte[] salt = new byte[blockSize];
                rnd.fill(salt);
                byte[] digestValue = KnownHostHashValue.calculateHashValue(hostIdentity.getHostName(), hostIdentity.getPort(), mac, salt);
                KnownHostHashValue.append(sb, digester, salt, digestValue);
                continue;
            }
            KnownHostHashValue.appendHostPattern(sb, hostIdentity.getHostName(), hostIdentity.getPort());
        }
        PublicKeyEntry.appendPublicKeyEntry(sb.append(' '), serverKey);
        return KnownHostEntry.parseKnownHostEntry(sb.toString());
    }

    protected NamedFactory<Mac> getHostValueDigester(ClientSession clientSession, SocketAddress remoteAddress, SshdSocketAddress hostIdentity) {
        return null;
    }

    protected Collection<SshdSocketAddress> resolveHostNetworkIdentities(ClientSession clientSession, SocketAddress remoteAddress) {
        TreeSet<SocketAddress> candidates = new TreeSet<SocketAddress>(SshdSocketAddress.BY_HOST_AND_PORT);
        candidates.add(SshdSocketAddress.toSshdSocketAddress(remoteAddress));
        SocketAddress connectAddress = clientSession.getConnectAddress();
        candidates.add(SshdSocketAddress.toSshdSocketAddress(connectAddress));
        return candidates;
    }

    @Override
    public boolean acceptModifiedServerKey(ClientSession clientSession, SocketAddress remoteAddress, KnownHostEntry entry, PublicKey expected, PublicKey actual) throws Exception {
        ModifiedServerKeyAcceptor acceptor = this.getModifiedServerKeyAcceptor();
        if (acceptor != null) {
            return acceptor.acceptModifiedServerKey(clientSession, remoteAddress, entry, expected, actual);
        }
        this.log.warn("acceptModifiedServerKey({}) mismatched keys presented by {} for entry={}: expected={}-{}, actual={}-{}", new Object[]{clientSession, remoteAddress, entry, KeyUtils.getKeyType(expected), KeyUtils.getFingerPrint(expected), KeyUtils.getKeyType(actual), KeyUtils.getFingerPrint(actual)});
        return false;
    }

    public static class HostEntryPair {
        private KnownHostEntry hostEntry;
        private PublicKey serverKey;

        public HostEntryPair() {
        }

        public HostEntryPair(KnownHostEntry entry, PublicKey key) {
            this.hostEntry = Objects.requireNonNull(entry, "No entry");
            this.serverKey = Objects.requireNonNull(key, "No key");
        }

        public KnownHostEntry getHostEntry() {
            return this.hostEntry;
        }

        public void setHostEntry(KnownHostEntry hostEntry) {
            this.hostEntry = hostEntry;
        }

        public PublicKey getServerKey() {
            return this.serverKey;
        }

        public void setServerKey(PublicKey serverKey) {
            this.serverKey = serverKey;
        }

        public String toString() {
            return String.valueOf(this.getHostEntry());
        }
    }
}

