/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.resources.rg;

import com.google.gwt.core.ext.BadPropertyValueException;
import com.google.gwt.core.ext.ConfigurationProperty;
import com.google.gwt.core.ext.Generator;
import com.google.gwt.core.ext.PropertyOracle;
import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.core.ext.UnableToCompleteException;
import com.google.gwt.core.ext.typeinfo.JClassType;
import com.google.gwt.core.ext.typeinfo.JMethod;
import com.google.gwt.core.ext.typeinfo.JPrimitiveType;
import com.google.gwt.core.ext.typeinfo.NotFoundException;
import com.google.gwt.core.ext.typeinfo.TypeOracle;
import com.google.gwt.dev.util.DefaultTextOutput;
import com.google.gwt.dev.util.TextOutput;
import com.google.gwt.dev.util.Util;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.StyleInjector;
import com.google.gwt.i18n.client.LocaleInfo;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.resources.css.ClassRenamer;
import com.google.gwt.resources.css.CssGenerationVisitor;
import com.google.gwt.resources.css.DefsCollector;
import com.google.gwt.resources.css.ExternalClassesCollector;
import com.google.gwt.resources.css.GenerateCssAst;
import com.google.gwt.resources.css.IfEvaluator;
import com.google.gwt.resources.css.MergeIdenticalSelectorsVisitor;
import com.google.gwt.resources.css.MergeRulesByContentVisitor;
import com.google.gwt.resources.css.RequirementsCollector;
import com.google.gwt.resources.css.RtlVisitor;
import com.google.gwt.resources.css.SplitRulesVisitor;
import com.google.gwt.resources.css.Spriter;
import com.google.gwt.resources.css.SubstitutionCollector;
import com.google.gwt.resources.css.SubstitutionReplacer;
import com.google.gwt.resources.css.ast.CollapsedNode;
import com.google.gwt.resources.css.ast.CssCompilerException;
import com.google.gwt.resources.css.ast.CssDef;
import com.google.gwt.resources.css.ast.CssIf;
import com.google.gwt.resources.css.ast.CssNode;
import com.google.gwt.resources.css.ast.CssProperty;
import com.google.gwt.resources.css.ast.CssRule;
import com.google.gwt.resources.css.ast.CssStylesheet;
import com.google.gwt.resources.ext.AbstractResourceGenerator;
import com.google.gwt.resources.ext.ClientBundleRequirements;
import com.google.gwt.resources.ext.ResourceContext;
import com.google.gwt.resources.ext.ResourceGeneratorUtil;
import com.google.gwt.resources.rg.Counter;
import com.google.gwt.user.rebind.SourceWriter;
import com.google.gwt.user.rebind.StringSourceWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.Adler32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CssResourceGenerator
extends AbstractResourceGenerator {
    static final char[] BASE32_CHARS = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', '-', '0', '1', '2', '3', '4', '5'};
    private static final int CONCAT_EXPRESSION_LIMIT = 20;
    private static final String KEY_BY_CLASS_AND_METHOD = "classAndMethod";
    private static final String KEY_CLASS_PREFIX = "prefix";
    private static final String KEY_CLASS_COUNTER = "counter";
    private static final String KEY_HAS_CACHED_DATA = "hasCachedData";
    private static final String KEY_SHARED_METHODS = "sharedMethods";
    private static final String KEY_RESERVED_PREFIXES = "CssResource.reservedClassPrefixes";
    private static final char RESERVED_IDENT_CHAR = 'Z';
    private Counter classCounter;
    private JClassType cssResourceType;
    private JClassType elementType;
    private boolean enableMerge;
    private boolean prettyOutput;
    private Map<JClassType, Map<JMethod, String>> replacementsByClassAndMethod;
    private Map<JMethod, String> replacementsForSharedMethods;
    private JClassType stringType;
    private Map<JMethod, CssStylesheet> stylesheetMap;

    public static String getImportPrefix(JClassType importType) {
        String prefix = importType.getSimpleSourceName();
        CssResource.ImportedWithPrefix exp = (CssResource.ImportedWithPrefix)importType.getAnnotation(CssResource.ImportedWithPrefix.class);
        if (exp != null) {
            prefix = exp.value();
        }
        return prefix + "-";
    }

    public static boolean haveCommonProperties(CssRule a, CssRule b) {
        if (a.getProperties().size() == 0 || b.getProperties().size() == 0) {
            return false;
        }
        TreeSet<String> aProperties = new TreeSet<String>();
        TreeSet<String> bProperties = new TreeSet<String>();
        for (CssProperty p : a.getProperties()) {
            aProperties.add(p.getName());
        }
        for (CssProperty p : b.getProperties()) {
            bProperties.add(p.getName());
        }
        Iterator ai = aProperties.iterator();
        Iterator bi = bProperties.iterator();
        String aName = (String)ai.next();
        String bName = (String)bi.next();
        while (true) {
            int comp;
            if ((comp = aName.compareToIgnoreCase(bName)) == 0) {
                return true;
            }
            if (comp > 0) {
                if (aName.startsWith(bName + "-")) {
                    return true;
                }
                if (!bi.hasNext()) break;
                bName = (String)bi.next();
                continue;
            }
            if (bName.startsWith(aName + "-")) {
                return true;
            }
            if (!ai.hasNext()) break;
            aName = (String)ai.next();
        }
        return false;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 1000; ++i) {
            System.out.println(CssResourceGenerator.makeIdent(i));
        }
    }

    static String computeObfuscatedClassName(String classPrefix, Counter classCounter, SortedSet<String> reservedPrefixes) {
        String obfuscatedClassName = classPrefix + CssResourceGenerator.makeIdent(classCounter.next());
        String conflict = CssResourceGenerator.stringStartsWithAny(obfuscatedClassName, reservedPrefixes);
        while (conflict != null) {
            Adler32 hash = new Adler32();
            hash.update(Util.getBytes((String)conflict));
            String newPrefix = CssResourceGenerator.makeIdent(hash.getValue()).substring(0, conflict.length()) + 'Z';
            obfuscatedClassName = newPrefix + obfuscatedClassName.substring(conflict.length());
            conflict = CssResourceGenerator.stringStartsWithAny(obfuscatedClassName, reservedPrefixes);
        }
        return obfuscatedClassName;
    }

    static <T extends CssNode> String makeExpression(TreeLogger logger, ResourceContext context, JClassType cssResourceType, T node, boolean prettyOutput) throws UnableToCompleteException {
        DefaultTextOutput out = new DefaultTextOutput(!prettyOutput);
        CssGenerationVisitor v = new CssGenerationVisitor((TextOutput)out);
        v.accept(node);
        String template = out.toString();
        StringBuilder b = new StringBuilder();
        int start = 0;
        int numExpressions = 0;
        b.append('(');
        for (Map.Entry<Integer, List<CssNode>> entry : v.getSubstitutionPositions().entrySet()) {
            b.append('\"');
            b.append(Generator.escape((String)template.substring(start, entry.getKey())));
            b.append('\"');
            numExpressions = CssResourceGenerator.concatOp(numExpressions, b);
            for (CssNode x : entry.getValue()) {
                TreeLogger loopLogger = logger.branch(TreeLogger.DEBUG, "Performing substitution in node " + x.toString());
                if (x instanceof CssIf) {
                    CssIf asIf = (CssIf)x;
                    String expression = CssResourceGenerator.makeExpression(loopLogger, context, cssResourceType, new CollapsedNode(asIf), prettyOutput);
                    String elseExpression = asIf.getElseNodes().isEmpty() ? "\"\"" : CssResourceGenerator.makeExpression(loopLogger, context, cssResourceType, new CollapsedNode(asIf.getElseNodes()), prettyOutput);
                    b.append("((" + asIf.getExpression() + ") ? " + expression + " : " + elseExpression + ") ");
                    numExpressions = CssResourceGenerator.concatOp(numExpressions, b);
                    continue;
                }
                if (x instanceof CssProperty) {
                    CssProperty property = (CssProperty)x;
                    CssResourceGenerator.validateValue(loopLogger, context.getClientBundleType(), property.getValues());
                    b.append("(" + property.getValues().getExpression() + ") ");
                    numExpressions = CssResourceGenerator.concatOp(numExpressions, b);
                    continue;
                }
                loopLogger.log(TreeLogger.ERROR, "Unhandled substitution " + x.getClass());
                throw new UnableToCompleteException();
            }
            start = entry.getKey();
        }
        b.append('\"');
        b.append(Generator.escape((String)template.substring(start)));
        b.append('\"');
        b.append(')');
        return b.toString();
    }

    private static int concatOp(int numExpressions, StringBuilder b) {
        if (numExpressions >= 20) {
            b.append(") + (");
            return 0;
        }
        b.append(" + ");
        return numExpressions + 1;
    }

    private static String makeIdent(long id) {
        assert (id >= 0L);
        StringBuilder b = new StringBuilder();
        b.append(BASE32_CHARS[(int)(id & 0xFL)]);
        id >>= 4;
        while (id != 0L) {
            b.append(BASE32_CHARS[(int)(id & 0x1FL)]);
            id >>= 5;
        }
        return b.toString();
    }

    private static String stringStartsWithAny(String target, SortedSet<String> prefixes) {
        String prefix;
        if (prefixes.isEmpty()) {
            return null;
        }
        String search = target.toString().toLowerCase() + " ";
        SortedSet<String> headSet = prefixes.headSet(search);
        if (!headSet.isEmpty() && search.startsWith(prefix = headSet.last())) {
            return prefix;
        }
        return null;
    }

    private static void validateValue(TreeLogger logger, JClassType resourceBundleType, CssProperty.Value value) throws UnableToCompleteException {
        CssProperty.ListValue list = value.isListValue();
        if (list != null) {
            for (CssProperty.Value v : list.getValues()) {
                CssResourceGenerator.validateValue(logger, resourceBundleType, v);
            }
            return;
        }
        CssProperty.DotPathValue dot = value.isDotPathValue();
        if (dot != null) {
            try {
                ResourceGeneratorUtil.getMethodByPath(resourceBundleType, dot.getParts(), null);
            }
            catch (NotFoundException e) {
                logger.log(TreeLogger.ERROR, e.getMessage());
                throw new UnableToCompleteException();
            }
        }
    }

    @Override
    public String createAssignment(TreeLogger logger, ResourceContext context, JMethod method) throws UnableToCompleteException {
        TypeOracle typeOracle = context.getGeneratorContext().getTypeOracle();
        StringSourceWriter sw = new StringSourceWriter();
        sw.println("new " + method.getReturnType().getQualifiedSourceName() + "() {");
        sw.indent();
        JClassType cssResourceSubtype = method.getReturnType().isInterface();
        assert (cssResourceSubtype != null);
        HashMap<String, Map<JMethod, String>> replacementsWithPrefix = new HashMap<String, Map<JMethod, String>>();
        replacementsWithPrefix.put("", this.computeReplacementsForType(cssResourceSubtype));
        CssResource.Import imp = (CssResource.Import)method.getAnnotation(CssResource.Import.class);
        if (imp != null) {
            boolean fail = false;
            for (Class<? extends CssResource> clazz : imp.value()) {
                JClassType importType = typeOracle.findType(clazz.getName().replace('$', '.'));
                assert (importType != null) : "TypeOracle does not have type " + clazz.getName();
                String prefix = CssResourceGenerator.getImportPrefix(importType);
                if (replacementsWithPrefix.put(prefix, this.computeReplacementsForType(importType)) == null) continue;
                logger.log(TreeLogger.ERROR, "Multiple imports that would use the prefix " + prefix);
                fail = true;
            }
            if (fail) {
                throw new UnableToCompleteException();
            }
        }
        this.writeEnsureInjected((SourceWriter)sw);
        this.writeGetName(method, (SourceWriter)sw);
        sw.println("public String getText() {");
        sw.indent();
        boolean strict = this.isStrict(logger, method);
        IdentityHashMap<JMethod, String> actualReplacements = new IdentityHashMap<JMethod, String>();
        String cssExpression = this.makeExpression(logger, context, cssResourceSubtype, this.stylesheetMap.get(method), replacementsWithPrefix, strict, actualReplacements);
        sw.println("return " + cssExpression + ";");
        sw.outdent();
        sw.println("}");
        this.writeUserMethods(logger, (SourceWriter)sw, this.stylesheetMap.get(method), cssResourceSubtype.getOverridableMethods(), actualReplacements);
        sw.outdent();
        sw.println("}");
        return sw.toString();
    }

    @Override
    public void init(TreeLogger logger, ResourceContext context) throws UnableToCompleteException {
        String classPrefix;
        try {
            PropertyOracle propertyOracle = context.getGeneratorContext().getPropertyOracle();
            ConfigurationProperty styleProp = propertyOracle.getConfigurationProperty("CssResource.style");
            String style = (String)styleProp.getValues().get(0);
            this.prettyOutput = style.equals("pretty");
            ConfigurationProperty mergeProp = propertyOracle.getConfigurationProperty("CssResource.mergeEnabled");
            String merge = (String)mergeProp.getValues().get(0);
            this.enableMerge = merge.equals("true");
            ConfigurationProperty classPrefixProp = propertyOracle.getConfigurationProperty("CssResource.obfuscationPrefix");
            classPrefix = (String)classPrefixProp.getValues().get(0);
        }
        catch (BadPropertyValueException e) {
            logger.log(TreeLogger.ERROR, "Unable to query module property", (Throwable)e);
            throw new UnableToCompleteException();
        }
        TypeOracle typeOracle = context.getGeneratorContext().getTypeOracle();
        this.cssResourceType = typeOracle.findType(CssResource.class.getName());
        assert (this.cssResourceType != null);
        this.elementType = typeOracle.findType(Element.class.getName());
        assert (this.elementType != null);
        this.stringType = typeOracle.findType(String.class.getName());
        assert (this.stringType != null);
        this.stylesheetMap = new IdentityHashMap<JMethod, CssStylesheet>();
        this.initReplacements(logger, context, classPrefix);
    }

    @Override
    public void prepare(TreeLogger logger, ResourceContext context, ClientBundleRequirements requirements, JMethod method) throws UnableToCompleteException {
        if (method.getReturnType().isInterface() == null) {
            logger.log(TreeLogger.ERROR, "Return type must be an interface");
            throw new UnableToCompleteException();
        }
        URL[] resources = ResourceGeneratorUtil.findResources(logger, context, method);
        if (resources.length == 0) {
            logger.log(TreeLogger.ERROR, "At least one source must be specified");
            throw new UnableToCompleteException();
        }
        CssStylesheet sheet = GenerateCssAst.exec(logger, resources);
        this.stylesheetMap.put(method, sheet);
        new RequirementsCollector(logger, requirements).accept(sheet);
    }

    private String computeClassPrefix(String classPrefix, SortedSet<JClassType> cssResourceSubtypes, TreeSet<String> reservedPrefixes) {
        if ("default".equals(classPrefix)) {
            classPrefix = null;
        } else if ("empty".equals(classPrefix)) {
            classPrefix = "";
        }
        if (classPrefix == null) {
            Adler32 checksum = new Adler32();
            for (JClassType type : cssResourceSubtypes) {
                checksum.update(Util.getBytes((String)type.getQualifiedSourceName()));
            }
            final int seed = Math.abs((int)checksum.getValue());
            classPrefix = "G" + CssResourceGenerator.computeObfuscatedClassName("", new Counter(){

                int next() {
                    return seed;
                }
            }, reservedPrefixes);
            reservedPrefixes.clear();
        }
        return classPrefix;
    }

    private void computeObfuscatedNames(TreeLogger logger, String classPrefix, SortedSet<String> reservedPrefixes, Set<JClassType> cssResourceSubtypes) {
        logger = logger.branch(TreeLogger.DEBUG, "Computing CSS class replacements");
        for (JClassType type : cssResourceSubtypes) {
            if (this.replacementsByClassAndMethod.containsKey(type)) continue;
            IdentityHashMap<JMethod, String> replacements = new IdentityHashMap<JMethod, String>();
            this.replacementsByClassAndMethod.put(type, replacements);
            for (JMethod method : type.getOverridableMethods()) {
                CssResource.Shared shared;
                String name = method.getName();
                if ("getName".equals(name) || "getText".equals(name) || !this.stringType.equals((Object)method.getReturnType())) continue;
                CssResource.ClassName classNameOverride = (CssResource.ClassName)method.getAnnotation(CssResource.ClassName.class);
                if (classNameOverride != null) {
                    name = classNameOverride.value();
                }
                String obfuscatedClassName = CssResourceGenerator.computeObfuscatedClassName(classPrefix, this.classCounter, reservedPrefixes);
                if (this.prettyOutput) {
                    obfuscatedClassName = obfuscatedClassName + "-" + type.getQualifiedSourceName().replaceAll("[.$]", "-") + "-" + name;
                }
                replacements.put(method, obfuscatedClassName);
                if (method.getEnclosingType() == type && (shared = (CssResource.Shared)type.getAnnotation(CssResource.Shared.class)) != null) {
                    this.replacementsForSharedMethods.put(method, obfuscatedClassName);
                }
                logger.log(TreeLogger.SPAM, "Mapped " + type.getQualifiedSourceName() + "." + name + " to " + obfuscatedClassName);
            }
        }
    }

    private SortedSet<JClassType> computeOperableTypes(TreeLogger logger) {
        JClassType[] cssResourceSubtypes;
        logger = logger.branch(TreeLogger.DEBUG, "Finding operable CssResource subtypes");
        TreeSet<JClassType> toReturn = new TreeSet<JClassType>(new JClassOrderComparator());
        for (JClassType type : cssResourceSubtypes = this.cssResourceType.getSubtypes()) {
            if (type.isInterface() != null) {
                logger.log(TreeLogger.SPAM, "Added " + type.getQualifiedSourceName());
                toReturn.add(type);
                continue;
            }
            logger.log(TreeLogger.SPAM, "Ignored " + type.getQualifiedSourceName());
        }
        return toReturn;
    }

    private Map<JMethod, String> computeReplacementsForType(JClassType type) {
        IdentityHashMap<JMethod, String> toReturn = new IdentityHashMap<JMethod, String>();
        if (type == null || !this.derivedFromCssResource(type)) {
            return toReturn;
        }
        if (this.replacementsByClassAndMethod.containsKey(type)) {
            toReturn.putAll(this.replacementsByClassAndMethod.get(type));
        }
        for (JMethod method : type.getOverridableMethods()) {
            if (!this.replacementsForSharedMethods.containsKey(method)) continue;
            assert (toReturn.containsKey(method));
            toReturn.put(method, this.replacementsForSharedMethods.get(method));
        }
        return toReturn;
    }

    private boolean derivedFromCssResource(JClassType type) {
        List<JClassType> superInterfaces = Arrays.asList(type.getImplementedInterfaces());
        if (superInterfaces.contains(this.cssResourceType)) {
            return true;
        }
        JClassType superClass = type.getSuperclass();
        if (superClass != null && this.derivedFromCssResource(superClass)) {
            return true;
        }
        for (JClassType superInterface : superInterfaces) {
            if (!this.derivedFromCssResource(superInterface)) continue;
            return true;
        }
        return false;
    }

    private void initReplacements(TreeLogger logger, ResourceContext context, String classPrefix) {
        SortedSet<JClassType> cssResourceSubtypes = this.computeOperableTypes(logger);
        if (context.getCachedData(KEY_HAS_CACHED_DATA, Boolean.class) != Boolean.TRUE) {
            TreeSet<String> reservedPrefixes = new TreeSet<String>();
            try {
                ConfigurationProperty prop = context.getGeneratorContext().getPropertyOracle().getConfigurationProperty(KEY_RESERVED_PREFIXES);
                for (String value : prop.getValues()) {
                    if ((value = value.trim()).length() == 0) {
                        logger.log(TreeLogger.WARN, "Ignoring nonsensical empty string value for CssResource.reservedClassPrefixes configuration property");
                        continue;
                    }
                    if (value.startsWith(".")) {
                        value = value.substring(1);
                    }
                    reservedPrefixes.add(value.toLowerCase());
                }
            }
            catch (BadPropertyValueException e) {
                // empty catch block
            }
            String computedPrefix = this.computeClassPrefix(classPrefix, cssResourceSubtypes, reservedPrefixes);
            context.putCachedData(KEY_BY_CLASS_AND_METHOD, new IdentityHashMap());
            context.putCachedData(KEY_CLASS_PREFIX, computedPrefix);
            context.putCachedData(KEY_CLASS_COUNTER, new Counter());
            context.putCachedData(KEY_HAS_CACHED_DATA, Boolean.TRUE);
            context.putCachedData(KEY_RESERVED_PREFIXES, reservedPrefixes);
            context.putCachedData(KEY_SHARED_METHODS, new IdentityHashMap());
        }
        this.classCounter = context.getCachedData(KEY_CLASS_COUNTER, Counter.class);
        this.replacementsByClassAndMethod = context.getCachedData(KEY_BY_CLASS_AND_METHOD, Map.class);
        this.replacementsForSharedMethods = context.getCachedData(KEY_SHARED_METHODS, Map.class);
        classPrefix = context.getCachedData(KEY_CLASS_PREFIX, String.class);
        SortedSet reservedPrefixes = context.getCachedData(KEY_RESERVED_PREFIXES, SortedSet.class);
        this.computeObfuscatedNames(logger, classPrefix, reservedPrefixes, cssResourceSubtypes);
    }

    private boolean isStrict(TreeLogger logger, JMethod method) {
        CssResource.Strict strictAnnotation = (CssResource.Strict)method.getAnnotation(CssResource.Strict.class);
        CssResource.NotStrict nonStrictAnnotation = (CssResource.NotStrict)method.getAnnotation(CssResource.NotStrict.class);
        boolean strict = true;
        if (strictAnnotation != null && nonStrictAnnotation != null) {
            logger.log(TreeLogger.WARN, "Contradictory annotations " + CssResource.Strict.class.getName() + " and " + CssResource.NotStrict.class.getName() + " applied to the CssResource accessor method; assuming strict");
        } else if (nonStrictAnnotation != null) {
            strict = false;
        }
        return strict;
    }

    private String makeExpression(TreeLogger logger, ResourceContext context, JClassType cssResourceType, CssStylesheet sheet, Map<String, Map<JMethod, String>> classReplacementsWithPrefix, boolean strict, Map<JMethod, String> actualReplacements) throws UnableToCompleteException {
        try {
            new Spriter(logger, context).accept(sheet);
            SubstitutionCollector collector = new SubstitutionCollector();
            collector.accept(sheet);
            new SubstitutionReplacer(logger, context, collector.getSubstitutions()).accept(sheet);
            new IfEvaluator(logger, context.getGeneratorContext().getPropertyOracle()).accept(sheet);
            ExternalClassesCollector externalClasses = new ExternalClassesCollector();
            externalClasses.accept(sheet);
            ClassRenamer renamer = new ClassRenamer(logger, classReplacementsWithPrefix, strict, externalClasses.getClasses());
            renamer.accept(sheet);
            actualReplacements.putAll(renamer.getReplacements());
            if (this.enableMerge) {
                new SplitRulesVisitor().accept(sheet);
                new MergeIdenticalSelectorsVisitor().accept(sheet);
                new MergeRulesByContentVisitor().accept(sheet);
            }
            String standard = CssResourceGenerator.makeExpression(logger, context, cssResourceType, sheet, this.prettyOutput);
            new RtlVisitor().accept(sheet);
            String reversed = CssResourceGenerator.makeExpression(logger, context, cssResourceType, sheet, this.prettyOutput);
            return LocaleInfo.class.getName() + ".getCurrentLocale().isRTL() ? (" + reversed + ") : (" + standard + ")";
        }
        catch (CssCompilerException e) {
            logger.log(TreeLogger.ERROR, "Unable to process CSS", (Throwable)(e.getCause() == null ? null : e));
            throw new UnableToCompleteException();
        }
    }

    private void writeClassAssignment(SourceWriter sw, JMethod toImplement, Map<JMethod, String> classReplacements) {
        String replacement = classReplacements.get(toImplement);
        assert (replacement != null) : "Missing replacement for " + toImplement.getName();
        sw.println(toImplement.getReadableDeclaration(false, true, true, true, true) + "{");
        sw.indent();
        sw.println("return \"" + replacement + "\";");
        sw.outdent();
        sw.println("}");
    }

    private void writeDefAssignment(TreeLogger logger, SourceWriter sw, JMethod toImplement, CssStylesheet cssStylesheet) throws UnableToCompleteException {
        SubstitutionCollector collector = new SubstitutionCollector();
        collector.accept(cssStylesheet);
        String name = toImplement.getName();
        CssDef def = collector.getSubstitutions().get(name);
        if (def == null) {
            logger.log(TreeLogger.ERROR, "No @def rule for name " + name);
            throw new UnableToCompleteException();
        }
        if (def.getValues().size() != 1) {
            logger.log(TreeLogger.ERROR, "@def rule " + name + " must define exactly one value");
            throw new UnableToCompleteException();
        }
        CssProperty.NumberValue numberValue = def.getValues().get(0).isNumberValue();
        String returnExpr = "";
        JClassType classReturnType = toImplement.getReturnType().isClass();
        if (classReturnType != null && "java.lang.String".equals(classReturnType.getQualifiedSourceName())) {
            returnExpr = "\"" + Generator.escape((String)def.getValues().get(0).toString()) + "\"";
        } else {
            JPrimitiveType returnType = toImplement.getReturnType().isPrimitive();
            if (returnType == null) {
                logger.log(TreeLogger.ERROR, toImplement.getName() + ": Return type must be primitive type or String for " + "@def accessors");
                throw new UnableToCompleteException();
            }
            if (returnType == JPrimitiveType.INT || returnType == JPrimitiveType.LONG) {
                returnExpr = "" + Math.round(numberValue.getValue());
            } else if (returnType == JPrimitiveType.FLOAT) {
                returnExpr = numberValue.getValue() + "F";
            } else if (returnType == JPrimitiveType.DOUBLE) {
                returnExpr = "" + numberValue.getValue();
            } else {
                logger.log(TreeLogger.ERROR, returnType.getQualifiedSourceName() + " is not a valid primitive return type for @def accessors");
                throw new UnableToCompleteException();
            }
        }
        sw.print(toImplement.getReadableDeclaration(false, false, false, false, true));
        sw.println(" {");
        sw.indent();
        sw.println("return " + returnExpr + ";");
        sw.outdent();
        sw.println("}");
    }

    private void writeEnsureInjected(SourceWriter sw) {
        sw.println("private boolean injected;");
        sw.println("public boolean ensureInjected() {");
        sw.indent();
        sw.println("if (!injected) {");
        sw.indentln("injected = true;");
        sw.indentln(StyleInjector.class.getName() + ".inject(getText());");
        sw.indentln("return true;");
        sw.println("}");
        sw.println("return false;");
        sw.outdent();
        sw.println("}");
    }

    private void writeGetName(JMethod method, SourceWriter sw) {
        sw.println("public String getName() {");
        sw.indent();
        sw.println("return \"" + method.getName() + "\";");
        sw.outdent();
        sw.println("}");
    }

    private void writeUserMethods(TreeLogger logger, SourceWriter sw, CssStylesheet sheet, JMethod[] methods, Map<JMethod, String> obfuscatedClassNames) throws UnableToCompleteException {
        DefsCollector collector = new DefsCollector();
        collector.accept(sheet);
        Set<String> defs = collector.getDefs();
        for (JMethod toImplement : methods) {
            String name = toImplement.getName();
            if ("getName".equals(name) || "getText".equals(name) || "ensureInjected".equals(name)) continue;
            if (defs.contains(name) && obfuscatedClassNames.containsKey(toImplement)) {
                logger.log(TreeLogger.ERROR, "@def shadows CSS class name: " + name + ". Fix by renaming the @def name or the CSS class name.");
                throw new UnableToCompleteException();
            }
            if (defs.contains(toImplement.getName()) && toImplement.getParameters().length == 0) {
                this.writeDefAssignment(logger, sw, toImplement, sheet);
                continue;
            }
            if (toImplement.getReturnType().equals((Object)this.stringType) && toImplement.getParameters().length == 0) {
                this.writeClassAssignment(sw, toImplement, obfuscatedClassNames);
                continue;
            }
            logger.log(TreeLogger.ERROR, "Don't know how to implement method " + toImplement.getName());
            throw new UnableToCompleteException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JClassOrderComparator
    implements Comparator<JClassType>,
    Serializable {
        JClassOrderComparator() {
        }

        @Override
        public int compare(JClassType o1, JClassType o2) {
            return o1.getQualifiedSourceName().compareTo(o2.getQualifiedSourceName());
        }
    }
}

