/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.server;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RequestProperty
implements Iterable<RequestProperty> {
    private String propertyName;
    private Map<String, RequestProperty> subProperties;

    public static RequestProperty coalesce(RequestProperty ... properties) {
        assert (properties.length > 0);
        RequestProperty root = new RequestProperty("");
        for (RequestProperty prop : properties) {
            if ("".equals(prop.getPropertyName())) {
                for (RequestProperty p : prop) {
                    root.mergeProperty(p);
                }
                continue;
            }
            root.mergeProperty(prop);
        }
        return root;
    }

    public static RequestProperty parse(String selectors) {
        String[] parts = selectors.split("\\s*,\\s*");
        RequestProperty[] props = new RequestProperty[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            RequestProperty newProp = new RequestProperty("");
            newProp.parseInternal(parts[i]);
            props[i] = newProp;
        }
        return props.length == 1 ? props[0] : RequestProperty.coalesce(props);
    }

    private RequestProperty(String propertyName) {
        this.propertyName = propertyName;
    }

    public RequestProperty add(RequestProperty propertyRef) {
        if (this.subProperties == null) {
            this.subProperties = new HashMap<String, RequestProperty>();
        }
        this.subProperties.put(propertyRef.getPropertyName(), propertyRef);
        return this;
    }

    public RequestProperty getProperty(String propName) {
        return this.subProperties == null ? null : this.subProperties.get(propName);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean hasProperty(String name) {
        return this.subProperties == null ? false : this.subProperties.containsKey(name);
    }

    @Override
    public Iterator<RequestProperty> iterator() {
        return this.subProperties == null ? this.emptyIterator() : this.subProperties.values().iterator();
    }

    public RequestProperty mergeProperty(RequestProperty property) {
        RequestProperty foundProp = this.getProperty(property.getPropertyName());
        if (foundProp == null && !"".equals(property.getPropertyName())) {
            this.add(property);
        } else {
            for (RequestProperty p : property) {
                if (foundProp == null) {
                    this.add(p);
                    continue;
                }
                foundProp.mergeProperty(p);
            }
        }
        return foundProp;
    }

    private Iterator<RequestProperty> emptyIterator() {
        return Collections.EMPTY_MAP.values().iterator();
    }

    private RequestProperty getOrCreate(String part) {
        RequestProperty prop = this.getProperty(part);
        if (prop == null) {
            prop = new RequestProperty(part);
            this.add(prop);
        }
        return prop;
    }

    private RequestProperty parseInternal(String sequence) {
        int dotIndex = sequence.indexOf(46);
        String part = dotIndex > -1 ? sequence.substring(0, dotIndex) : sequence;
        RequestProperty prop = this.getOrCreate(part);
        this.add(prop);
        if (dotIndex > -1) {
            if (dotIndex < sequence.length() - 1) {
                String next = sequence.substring(dotIndex + 1);
                if ("".equals(next)) {
                    throw new IllegalArgumentException("Empty property name '..' not allowed in " + sequence);
                }
                if (next.length() > 0) {
                    return prop.parseInternal(next);
                }
            }
            throw new IllegalArgumentException("Trailing '.' in with() call " + sequence);
        }
        return prop;
    }
}

