/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegionInheritance {
    private static Map<String, String> parentRegionMap = new HashMap<String, String>();

    public static String findCommonParent(String region1, String region2) {
        if (region1 == null || region2 == null) {
            return null;
        }
        ArrayList<String> parents1 = new ArrayList<String>();
        String parent = region1;
        while (parent != null) {
            parents1.add(parent);
            parent = parentRegionMap.get(parent);
        }
        parent = region2;
        while (parent != null) {
            if (parents1.contains(parent)) {
                return parent;
            }
            parent = parentRegionMap.get(parent);
        }
        return null;
    }

    public static List<String> getAllAncestors(String child) {
        ArrayList<String> returnVal = new ArrayList<String>();
        HashSet<String> nextGroup = new HashSet<String>();
        if (child != null) {
            nextGroup.add(child);
        }
        while (!nextGroup.isEmpty()) {
            HashSet<String> ancestors = new HashSet<String>();
            for (String region : nextGroup) {
                ancestors.addAll(RegionInheritance.getImmediateParents(region));
            }
            ancestors.removeAll(returnVal);
            nextGroup.clear();
            nextGroup.addAll(ancestors);
            returnVal.addAll(ancestors);
        }
        return returnVal;
    }

    public static Set<String> getImmediateParents(String region) {
        HashSet<String> returnVal = new HashSet<String>();
        if (parentRegionMap.containsKey(region)) {
            returnVal.add(parentRegionMap.get(region));
        }
        return returnVal;
    }

    public static boolean isParentOf(String parent, String child) {
        if (parent == child) {
            return true;
        }
        while (child != null) {
            if (child.equals(parent)) {
                return true;
            }
            child = parentRegionMap.get(child);
        }
        return false;
    }

    static Map<String, String> getInheritanceMap() {
        return parentRegionMap;
    }

    private static void addChildren(String parent, String ... children) {
        for (String child : children) {
            String oldParent = parentRegionMap.put(child, parent);
            assert (oldParent == null);
        }
    }

    static {
        RegionInheritance.addChildren("001", "002", "009", "019", "142", "150");
        RegionInheritance.addChildren("011", "BF", "BJ", "CI", "CV", "GH", "GM", "GN", "GW", "LR", "ML", "MR", "NE", "NG", "SH", "SL", "SN", "TG");
        RegionInheritance.addChildren("013", "BZ", "CR", "GT", "HN", "MX", "NI", "PA", "SV");
        RegionInheritance.addChildren("014", "BI", "DJ", "ER", "ET", "KE", "KM", "MG", "MU", "MW", "MZ", "RE", "RW", "SC", "SO", "TZ", "UG", "YT", "ZM", "ZW");
        RegionInheritance.addChildren("142", "030", "035", "143", "145", "034", "062");
        RegionInheritance.addChildren("143", "TM", "TJ", "KG", "KZ", "UZ");
        RegionInheritance.addChildren("145", "AE", "AM", "AZ", "BH", "CY", "GE", "IL", "IQ", "JO", "KW", "LB", "OM", "PS", "QA", "SA", "NT", "SY", "TR", "YE", "YD");
        RegionInheritance.addChildren("015", "DZ", "EG", "EH", "LY", "MA", "SD", "TN");
        RegionInheritance.addChildren("150", "039", "151", "154", "155");
        RegionInheritance.addChildren("151", "BG", "BY", "CZ", "HU", "MD", "PL", "RO", "RU", "SU", "SK", "UA");
        RegionInheritance.addChildren("154", "GG", "JE", "AX", "DK", "EE", "FI", "FO", "GB", "IE", "IM", "IS", "LT", "LV", "NO", "SE", "SJ");
        RegionInheritance.addChildren("155", "AT", "BE", "CH", "DE", "DD", "FR", "FX", "LI", "LU", "MC", "NL");
        RegionInheritance.addChildren("017", "AO", "CD", "ZR", "CF", "CG", "CM", "GA", "GQ", "ST", "TD");
        RegionInheritance.addChildren("018", "BW", "LS", "NA", "SZ", "ZA");
        RegionInheritance.addChildren("019", "021", "419");
        RegionInheritance.addChildren("002", "011", "014", "015", "017", "018");
        RegionInheritance.addChildren("021", "BM", "CA", "GL", "PM", "US");
        RegionInheritance.addChildren("029", "AG", "AI", "AN", "AW", "BB", "BL", "BS", "CU", "DM", "DO", "GD", "GP", "HT", "JM", "KN", "KY", "LC", "MF", "MQ", "MS", "PR", "TC", "TT", "VC", "VG", "VI");
        RegionInheritance.addChildren("030", "CN", "HK", "JP", "KP", "KR", "MN", "MO", "TW");
        RegionInheritance.addChildren("035", "BN", "ID", "KH", "LA", "MM", "BU", "MY", "PH", "SG", "TH", "TL", "TP", "VN");
        RegionInheritance.addChildren("039", "AD", "AL", "BA", "ES", "GI", "GR", "HR", "IT", "ME", "MK", "MT", "CS", "RS", "PT", "SI", "SM", "VA", "YU");
        RegionInheritance.addChildren("419", "005", "013", "029");
        RegionInheritance.addChildren("005", "AR", "BO", "BR", "CL", "CO", "EC", "FK", "GF", "GY", "PE", "PY", "SR", "UY", "VE");
        RegionInheritance.addChildren("053", "AU", "NF", "NZ");
        RegionInheritance.addChildren("054", "FJ", "NC", "PG", "SB", "VU");
        RegionInheritance.addChildren("057", "FM", "GU", "KI", "MH", "MP", "NR", "PW");
        RegionInheritance.addChildren("061", "AS", "CK", "NU", "PF", "PN", "TK", "TO", "TV", "WF", "WS");
        RegionInheritance.addChildren("034", "AF", "BD", "BT", "IN", "IR", "LK", "MV", "NP", "PK");
        RegionInheritance.addChildren("009", "053", "054", "057", "061", "QO");
        RegionInheritance.addChildren("QO", "AQ", "BV", "CC", "CX", "GS", "HM", "IO", "TF", "UM");
    }
}

