/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.internal.impldep.javax.annotation.Nullable;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.UnknownModelException;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.internal.adapter.ObjectGraphAdapter;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.ViewBuilder;
import org.gradle.tooling.internal.consumer.connection.HasCompatibilityMapping;
import org.gradle.tooling.internal.consumer.connection.ToolingParameterProxy;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.internal.Exceptions;

abstract class UnparameterizedBuildController
extends HasCompatibilityMapping
implements BuildController {
    private final ProtocolToModelAdapter adapter;
    private final ObjectGraphAdapter resultAdapter;
    private final ModelMapping modelMapping;
    private final File rootDir;

    public UnparameterizedBuildController(ProtocolToModelAdapter adapter, ModelMapping modelMapping, File rootDir) {
        this.adapter = adapter;
        this.resultAdapter = adapter.newGraph();
        this.modelMapping = modelMapping;
        this.rootDir = rootDir;
    }

    @Override
    public <T> T getModel(Class<T> modelType) throws UnknownModelException {
        return this.getModel(null, modelType);
    }

    @Override
    public <T> T findModel(Class<T> modelType) {
        return this.findModel(null, modelType);
    }

    @Override
    public GradleBuild getBuildModel() {
        return this.getModel(null, GradleBuild.class);
    }

    @Override
    public <T> T getModel(Model target, Class<T> modelType) throws UnknownModelException {
        return this.getModel(target, modelType, null, null);
    }

    @Override
    public <T> T findModel(Model target, Class<T> modelType) {
        return this.findModel(target, modelType, null, null);
    }

    @Override
    public <T, P> T getModel(Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer) throws UnsupportedVersionException {
        return this.getModel(null, modelType, parameterType, parameterInitializer);
    }

    @Override
    public <T, P> T findModel(Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer) {
        return this.findModel(null, modelType, parameterType, parameterInitializer);
    }

    @Override
    public <T, P> T findModel(Model target, Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer) {
        try {
            return this.getModel(target, modelType, parameterType, parameterInitializer);
        }
        catch (UnknownModelException e) {
            return null;
        }
    }

    @Override
    public <T, P> T getModel(Model target, Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer) throws UnsupportedVersionException, UnknownModelException {
        BuildResult<?> result;
        ModelIdentifier modelIdentifier = this.modelMapping.getModelIdentifierFromModelType(modelType);
        Object originalTarget = target == null ? null : this.adapter.unpack(target);
        P parameter = this.initializeParameter(parameterType, parameterInitializer);
        try {
            result = this.getModel(originalTarget, modelIdentifier, parameter);
        }
        catch (InternalUnsupportedModelException e) {
            throw Exceptions.unknownModel(modelType, e);
        }
        ViewBuilder<T> viewBuilder = this.resultAdapter.builder(modelType);
        this.applyCompatibilityMapping(viewBuilder, new DefaultProjectIdentifier(this.rootDir, this.getProjectPath(target)));
        return viewBuilder.build(result.getModel());
    }

    private <P> P initializeParameter(Class<P> parameterType, Action<? super P> parameterInitializer) {
        this.validateParameters(parameterType, parameterInitializer);
        if (parameterType != null) {
            P parameter = parameterType.cast(Proxy.newProxyInstance(parameterType.getClassLoader(), new Class[]{parameterType}, (InvocationHandler)new ToolingParameterProxy()));
            parameterInitializer.execute(parameter);
            return parameter;
        }
        return null;
    }

    private <P> void validateParameters(Class<P> parameterType, Action<? super P> parameterInitializer) {
        if (parameterType == null && parameterInitializer != null || parameterType != null && parameterInitializer == null) {
            throw new NullPointerException("parameterType and parameterInitializer both need to be set for a parameterized model request.");
        }
        if (parameterType != null) {
            ToolingParameterProxy.validateParameter(parameterType);
        }
    }

    private String getProjectPath(Model target) {
        if (target instanceof ProjectModel) {
            return ((ProjectModel)((Object)target)).getProjectIdentifier().getProjectPath();
        }
        return ":";
    }

    protected abstract BuildResult<?> getModel(@Nullable Object var1, ModelIdentifier var2, @Nullable Object var3) throws InternalUnsupportedModelException;

    @Override
    public boolean getCanQueryProjectModelInParallel(Class<?> modelType) {
        return false;
    }

    @Override
    public <T> List<T> run(Collection<? extends BuildAction<? extends T>> actions) {
        ArrayList<T> results = new ArrayList<T>(actions.size());
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        for (BuildAction<T> action : actions) {
            try {
                T result = action.execute(this);
                results.add(result);
            }
            catch (Throwable t) {
                failures.add(t);
            }
        }
        if (!failures.isEmpty()) {
            throw new MultipleBuildOperationFailures(failures, null);
        }
        return results;
    }
}

