/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.xml.internal.ui.preferences;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Set;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wildwebdeveloper.xml.internal.Activator;
import org.eclipse.wildwebdeveloper.xml.internal.ui.Messages;
import org.eclipse.wildwebdeveloper.xml.internal.ui.preferences.XMLCatalogs;

public class XMLCatalogPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Set<File> entries;
    private File selectedEntry;
    private boolean isDirty;

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        this.isDirty = false;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Group entriesGroup = new Group(composite, 0);
        entriesGroup.setText(Messages.XMLCatalogPreferencePage_Entries);
        GridLayout gl = new GridLayout(2, false);
        entriesGroup.setLayout((Layout)gl);
        entriesGroup.setLayoutData((Object)new GridData(1808));
        TreeViewer viewer = new TreeViewer((Composite)entriesGroup, 2816);
        viewer.setContentProvider((IContentProvider)new EntriesContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new EntriesLabelProvider());
        this.entries = XMLCatalogs.getAllCatalogs(this.getPreferenceStore());
        viewer.setInput(this.entries);
        viewer.getControl().setLayoutData((Object)new GridData(1808));
        viewer.expandAll();
        Composite buttonComposite = new Composite((Composite)entriesGroup, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        buttonComposite.setLayoutData((Object)new GridData(4, 128, false, false));
        Button addButton = new Button(buttonComposite, 8);
        addButton.setLayoutData((Object)new GridData(768));
        addButton.setText(Messages.Add_button);
        addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            File result = this.openSelectFileDialog();
            if (result == null) {
                return;
            }
            this.entries.add(result);
            viewer.refresh();
            viewer.setSelection((ISelection)new TreeSelection(new TreePath((Object[])new File[]{result})));
            this.isDirty = true;
        }));
        Button removeButton = new Button(buttonComposite, 8);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.setText(Messages.Remove_button);
        removeButton.setEnabled(false);
        removeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.selectedEntry != null) {
                this.entries.remove(this.selectedEntry);
                viewer.refresh();
                this.isDirty = true;
            }
        }));
        Button editButton = new Button(buttonComposite, 8);
        editButton.setLayoutData((Object)new GridData(4, 2, true, false, 1, 18));
        editButton.setText(Messages.XMLCatalogPreferencePage_Edit);
        editButton.setEnabled(false);
        editButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.selectedEntry != null) {
                int result;
                MessageDialog dialog = new MessageDialog(this.getShell(), Messages.XMLCatalogPreferencePage_OpenInEditorTitle, null, Messages.XMLCatalogPreferencePage_OpenInEditorMessage, 5, 1, new String[]{Messages.XMLCatalogPreferencePage_OpenInEditorApplyAndEdit, IDialogConstants.NO_LABEL});
                int n = result = this.isDirty ? dialog.open() : 0;
                if (result == 0) {
                    this.performOk();
                    IPreferencePageContainer iPreferencePageContainer = this.getContainer();
                    if (iPreferencePageContainer instanceof Window var4_5) {
                        void window;
                        window.close();
                    }
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (URI)this.selectedEntry.toURI(), (String)"org.eclipse.ui.genericeditor.GenericEditor", (boolean)true);
                    }
                    catch (PartInitException e1) {
                        Activator.getDefault().getLog().error(e1.getMessage(), (Throwable)e1);
                    }
                }
            }
        }));
        viewer.addSelectionChangedListener(event -> {
            File file;
            void treeSelection;
            Object object;
            Object object2;
            ISelection selection;
            removeButton.setEnabled(!event.getSelection().isEmpty());
            editButton.setEnabled(!event.getSelection().isEmpty());
            this.selectedEntry = null;
            ISelection iSelection = selection = event.getSelection();
            if (iSelection instanceof ITreeSelection var5_6 && (object2 = (object = treeSelection.getFirstElement())) instanceof File && (file = (File)object2) == (File)object2) {
                void file2;
                this.selectedEntry = file2;
            }
        });
        return composite;
    }

    public boolean performOk() {
        XMLCatalogs.storeUserCatalogs(this.getPreferenceStore(), this.entries);
        this.isDirty = false;
        return super.performOk();
    }

    private File openSelectFileDialog() {
        FileDialog dialog = new FileDialog(this.getShell(), 4);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        dialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toString());
        String fileName = dialog.open();
        return fileName == null || fileName.trim().length() == 0 ? null : new File(fileName);
    }

    class EntriesContentProvider
    implements ITreeContentProvider {
        EntriesContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Set var2_3) {
                return set.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof Set;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class EntriesLabelProvider
    extends LabelProvider {
        private Image image;

        public EntriesLabelProvider() {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream imageResource = ((Object)((Object)this)).getClass().getResourceAsStream("/icons/xmlEditorIcon.png");){
                    this.image = new Image((Device)Display.getDefault(), imageResource);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Activator.getDefault().getLog().error(e.getMessage(), (Throwable)e);
            }
        }

        public Image getImage(Object element) {
            return this.image;
        }

        public String getText(Object element) {
            if (element instanceof File var2_3) {
                return file.getAbsolutePath();
            }
            return super.getText(element);
        }

        protected final IWorkbenchAdapter getAdapter(Object o) {
            return (IWorkbenchAdapter)Adapters.adapt((Object)o, IWorkbenchAdapter.class);
        }

        public void dispose() {
            if (this.image != null) {
                this.image.dispose();
            }
            this.image = null;
        }
    }
}

