/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.steps;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerManager;
import org.eclipse.tcf.te.runtime.statushandler.interfaces.IStatusHandler;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.interfaces.IChannelManager;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelRefreshService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.interfaces.IContextHelpIds;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.nls.Messages;

public class DetachStep {
    public void executeDetach(IProcessContextNode node, ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)node);
        if (node.getProcessContext() != null && node.getProcessContext().isAttached()) {
            IPeerNode peerNode = (IPeerNode)node.getAdapter(IPeerNode.class);
            if (peerNode != null) {
                this.doDetach(node, callback);
            } else {
                this.onError(node, Messages.DetachStep_error_disconnect, null, callback);
            }
        } else if (node.getProcessContext() == null) {
            this.onError(node, Messages.DetachStep_error_disconnect, null, callback);
        } else {
            this.onDone(callback);
        }
    }

    protected void doDetach(final IProcessContextNode node, final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)node);
        IPeerNode peerNode = (IPeerNode)node.getAdapter(IPeerNode.class);
        Tcf.getChannelManager().openChannel(peerNode.getPeer(), null, new IChannelManager.DoneOpenChannel(){

            public void doneOpenChannel(Throwable error, IChannel channel) {
                if (error == null) {
                    IProcesses service = (IProcesses)channel.getRemoteService(IProcesses.class);
                    if (service != null) {
                        service.getContext(node.getStringProperty("id"), new IProcesses.DoneGetContext(){

                            public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                                if (error == null && context != null) {
                                    context.detach(new IProcesses.DoneCommand(){

                                        public void doneCommand(IToken token, Exception error) {
                                            if (error == null) {
                                                IModel model = (IModel)node.getParent(IModel.class);
                                                Assert.isNotNull((Object)model);
                                                ((IModelRefreshService)model.getService(IModelRefreshService.class)).refresh((IModelNode)node, (ICallback)new Callback(){

                                                    protected void internalDone(Object caller, IStatus status) {
                                                        DetachStep.this.onDone(callback);
                                                    }
                                                });
                                            } else {
                                                DetachStep.this.onError(node, Messages.DetachStep_error_detach, error, callback);
                                            }
                                        }
                                    });
                                } else {
                                    DetachStep.this.onError(node, Messages.DetachStep_error_getContext, error, callback);
                                }
                            }
                        });
                    } else {
                        DetachStep.this.onError(node, Messages.DetachStep_error_disconnect, null, callback);
                    }
                } else {
                    DetachStep.this.onError(node, Messages.DetachStep_error_openChannel, error, callback);
                }
            }
        });
    }

    protected void onError(Object context, String message, Throwable error, ICallback callback) {
        String fullMessage;
        String detailMessage;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        String string = detailMessage = error != null ? error.getMessage() : null;
        if (detailMessage != null && detailMessage.contains("\n")) {
            detailMessage = detailMessage.replaceAll("\n", ", ");
            detailMessage = detailMessage.replaceAll(":, ", ": ");
        }
        if ((fullMessage = (fullMessage = message) != null ? NLS.bind((String)fullMessage, (Object)(detailMessage != null ? detailMessage : "")) : detailMessage) != null) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), fullMessage, error);
            if (callback == null) {
                IStatusHandler[] handlers = StatusHandlerManager.getInstance().getHandler(context);
                if (handlers.length > 0) {
                    PropertiesContainer data = new PropertiesContainer();
                    data.setProperty("title", (Object)Messages.DetachStep_error_title);
                    data.setProperty("contextHelpId", (Object)IContextHelpIds.MESSAGE_DETACH_FAILED);
                    data.setProperty("caller", (Object)this);
                    handlers[0].handleStatus((IStatus)status, (IPropertiesContainer)data, null);
                } else {
                    CoreBundleActivator.getDefault().getLog().log((IStatus)status);
                }
            } else {
                callback.done((Object)this, (IStatus)status);
            }
        }
    }

    protected void onDone(ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if (callback != null) {
            callback.done((Object)this, Status.OK_STATUS);
        }
    }
}

