/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tools.internal.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.PlatformResourceURIHandlerImpl;
import org.eclipse.sirius.tools.internal.resource.ProgressMonitorInputStream;
import org.eclipse.sirius.tools.internal.resource.ProgressMonitorOutputStream;

public class PlatformResourceURIHandlerWithProgressMonitorImpl
extends PlatformResourceURIHandlerImpl {
    private IProgressMonitor monitor;

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        URI fileURI;
        InputStream inputStream = null;
        String filePath = null;
        if (uri.isFile()) {
            filePath = uri.toFileString();
        } else if (uri.isPlatformResource() && (fileURI = CommonPlugin.asLocalURI((URI)uri)).isFile()) {
            filePath = fileURI.toFileString();
        }
        if (filePath != null) {
            File file = new File(filePath);
            inputStream = new ProgressMonitorInputStream(new FileInputStream(file), file.length(), 1, this.monitor);
            Map response = this.getResponse(options);
            if (response != null) {
                response.put("TIME_STAMP", file.lastModified());
            }
        } else if (uri.isFile()) {
            inputStream = super.createInputStream(uri, options);
        } else if (uri.isPlatformResource()) {
            inputStream = new PlatformResourceURIHandlerImpl().createInputStream(uri, options);
        }
        return inputStream;
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) throws IOException {
        URI fileURI;
        OutputStream outputStream = null;
        String filePath = null;
        if (uri.isFile()) {
            filePath = uri.toFileString();
        } else if (uri.isPlatformResource() && (fileURI = CommonPlugin.asLocalURI((URI)uri)).isFile()) {
            filePath = fileURI.toFileString();
        }
        if (filePath != null) {
            File file = new File(filePath);
            outputStream = new ProgressMonitorOutputStream(new FileOutputStream(file), file.length(), 1, this.monitor);
            Map response = this.getResponse(options);
            if (response != null) {
                response.put("TIME_STAMP", file.lastModified());
            }
        } else if (uri.isFile()) {
            outputStream = super.createOutputStream(uri, options);
        } else if (uri.isPlatformResource()) {
            outputStream = new PlatformResourceURIHandlerImpl().createOutputStream(uri, options);
        }
        return outputStream;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.monitor = progressMonitor;
    }
}

