/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.controlmode;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters;

public class ControlModeRequest
extends AbstractEditCommandRequest
implements ControlModeRequestParameters {
    protected EObject targetObject;
    protected URI newURI;
    protected URI sourceURI;
    protected boolean isControlRequest;

    public ControlModeRequest(TransactionalEditingDomain editingDomain, EObject targetObject) {
        this(editingDomain, targetObject, ControlModeRequest.getTargetURI(targetObject));
        this.isControlRequest = false;
    }

    public ControlModeRequest(TransactionalEditingDomain editingDomain, EObject objectToControl, URI newURI) {
        super(editingDomain);
        Assert.isNotNull((Object)objectToControl);
        this.targetObject = objectToControl;
        this.newURI = newURI;
        if (newURI != null) {
            this.setTargetResource(editingDomain.getResourceSet().getResource(newURI, false), newURI.fileExtension());
        }
        Resource r = objectToControl.eResource();
        Assert.isNotNull((Object)r);
        this.sourceURI = r.getURI();
        this.isControlRequest = true;
    }

    public URI getSourceURI() {
        return this.sourceURI;
    }

    private static URI getTargetURI(EObject targetObject) {
        EObject eContainer = targetObject.eContainer();
        if (eContainer != null) {
            return eContainer.eResource().getURI();
        }
        return null;
    }

    public boolean isControlRequest() {
        return this.isControlRequest;
    }

    public Object getEditHelperContext() {
        return this.targetObject;
    }

    public EObject getTargetObject() {
        return this.targetObject;
    }

    public URI getNewURI() {
        return this.newURI;
    }

    public void setIsUIAction(boolean value) {
        this.setParameter("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.IsUIAction", value);
    }

    public boolean isUIAction() {
        Object result = this.getParameter("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.IsUIAction");
        return (Boolean)(result == null ? Boolean.valueOf(false) : result);
    }

    public void setTargetResource(Resource resource, String extension) {
        this.setParameter(this.getTargetResourceKey(extension), resource);
    }

    public Resource getTargetResource(String extension) {
        Object result = this.getParameter(this.getTargetResourceKey(extension));
        return (Resource)(result == null ? null : result);
    }

    public Resource getSourceResource(String extension) {
        Object result = this.getParameter(this.getSourceResourceKey(extension));
        return (Resource)(result == null ? null : result);
    }

    public void setSourceResource(Resource resource, String extension) {
        this.setParameter(this.getSourceResourceKey(extension), resource);
    }

    protected String getTargetResourceKey(String extension) {
        return this.getResourceKey("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.TargetResource", extension);
    }

    protected String getSourceResourceKey(String extension) {
        return this.getResourceKey("org.eclipse.papyrus.infra.services.controlmode.ControlModeRequestParameters.SourceResource", extension);
    }

    protected String getResourceKey(String key, String extension) {
        return String.valueOf(key) + "." + extension;
    }

    public ModelSet getModelSet() {
        return (ModelSet)this.getEditingDomain().getResourceSet();
    }

    public static ControlModeRequest createUIControlModelRequest(TransactionalEditingDomain editingDomain, EObject objectToControl, URI newURI) {
        ControlModeRequest request = new ControlModeRequest(editingDomain, objectToControl, newURI);
        request.setIsUIAction(true);
        return request;
    }

    public static ControlModeRequest createUIUncontrolModelRequest(TransactionalEditingDomain editingDomain, EObject objectToControl) {
        ControlModeRequest request = new ControlModeRequest(editingDomain, objectToControl);
        request.setIsUIAction(true);
        return request;
    }
}

