/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sashwindows.di.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiFactory;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiPackage;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.sashwindows.di.TabFolder;
import org.eclipse.papyrus.infra.core.sashwindows.di.impl.AbstractPanelImpl;
import org.eclipse.uml2.common.util.SubsetSupersetEObjectContainmentWithInverseEList;

public class TabFolderImpl
extends AbstractPanelImpl
implements TabFolder {
    protected EList<PageRef> children;
    protected PageRef currentSelection;
    protected static final int[] CHILDREN_ESUBSETS = new int[]{2};

    protected TabFolderImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return DiPackage.Literals.TAB_FOLDER;
    }

    @Override
    public EList<PageRef> getChildren() {
        if (this.children == null) {
            this.children = new SubsetSupersetEObjectContainmentWithInverseEList(PageRef.class, (InternalEObject)this, 1, null, CHILDREN_ESUBSETS, 4);
        }
        return this.children;
    }

    @Override
    public PageRef getCurrentSelection() {
        if (this.currentSelection != null && this.currentSelection.eIsProxy()) {
            InternalEObject oldCurrentSelection = (InternalEObject)this.currentSelection;
            this.currentSelection = (PageRef)this.eResolveProxy(oldCurrentSelection);
            if (this.currentSelection != oldCurrentSelection && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldCurrentSelection, (Object)this.currentSelection));
            }
        }
        return this.currentSelection;
    }

    public PageRef basicGetCurrentSelection() {
        return this.currentSelection;
    }

    @Override
    public void setCurrentSelection(PageRef newCurrentSelection) {
        EList<PageRef> children;
        Resource.Internal eInternalResource;
        PageRef oldCurrentSelection = this.currentSelection;
        this.currentSelection = newCurrentSelection;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldCurrentSelection, (Object)this.currentSelection));
        }
        if (!((eInternalResource = this.eInternalResource()) != null && eInternalResource.isLoading() || newCurrentSelection == null || (children = this.getChildren()).contains((Object)newCurrentSelection))) {
            children.add((Object)newCurrentSelection);
        }
    }

    @Override
    public void addPage(Object pageIdentifier) {
        PageRef newPage = DiFactory.eINSTANCE.createPageRef();
        newPage.setPageIdentifier(pageIdentifier);
        this.getChildren().add((Object)newPage);
    }

    @Override
    public void addPage(int index, Object pageIdentifier) {
        PageRef newPage = DiFactory.eINSTANCE.createPageRef();
        newPage.setPageIdentifier(pageIdentifier);
        this.getChildren().add(index, (Object)newPage);
    }

    @Override
    public void addPage(PageRef pageRef) {
        this.getChildren().add((Object)pageRef);
    }

    @Override
    public void removePage(int pageIndex) {
        if (pageIndex >= 0 && pageIndex < this.getChildren().size()) {
            this.getChildren().remove(pageIndex);
        }
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getChildren()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 1: {
                return ((InternalEList)this.getChildren()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getChildren();
            }
            case 2: {
                if (resolve) {
                    return this.getCurrentSelection();
                }
                return this.basicGetCurrentSelection();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getChildren().clear();
                this.getChildren().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setCurrentSelection((PageRef)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.getChildren().clear();
                return;
            }
            case 2: {
                this.setCurrentSelection(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.children != null && !this.children.isEmpty();
            }
            case 2: {
                return this.currentSelection != null;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public void movePage(int oldIndex, int newIndex) {
        int listSize = this.getChildren().size();
        if (newIndex >= listSize) {
            newIndex = listSize - 1;
        }
        if (newIndex < 0) {
            newIndex = 0;
        }
        if (listSize == 0 || oldIndex == newIndex || oldIndex < 0) {
            return;
        }
        this.getChildren().move(newIndex, oldIndex);
    }
}

