/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.AbstractSingletonScope;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdHash;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.SingletonScope;
import org.eclipse.ocl.pivot.internal.ids.WeakHashMapOfListOfWeakReference2;

public class BindingsIdImpl
implements BindingsId,
WeakHashMapOfListOfWeakReference2.MatchableId<ElementId[]> {
    private final @NonNull ElementId @NonNull [] elementIds;
    private final @NonNull Object @Nullable [] values;
    private final @NonNull Integer hashCode;

    private static int computeHashCode(@NonNull ElementId @NonNull [] elementIds, @NonNull Object @Nullable [] values) {
        return IdHash.createParametersHash(BindingsId.class, elementIds, values);
    }

    @Deprecated
    public BindingsIdImpl(@NonNull IdManager idManager, @NonNull Integer hashCode, @NonNull ElementId @NonNull [] elementIds) {
        this.hashCode = hashCode;
        this.elementIds = elementIds;
        this.values = null;
        assert (hashCode == this.hashCode);
    }

    private BindingsIdImpl(@NonNull IdManager idManager, @NonNull ElementId @NonNull [] elementIds, @NonNull Object @Nullable [] values) {
        this.hashCode = BindingsIdImpl.computeHashCode(elementIds, values);
        this.elementIds = elementIds;
        this.values = values;
    }

    @Override
    public int elementIdSize() {
        return this.elementIds.length;
    }

    public final boolean equals(Object that) {
        if (that instanceof SingletonScope.KeyAndValue) {
            return that.equals(this);
        }
        return this == that;
    }

    @Override
    @Deprecated
    public @NonNull ElementId get(int i) {
        return this.getElementId(i);
    }

    @Override
    public @NonNull ElementId getElementId(int i) {
        return this.elementIds[i];
    }

    @Override
    public @NonNull Object getValue(int i) {
        assert (this.values != null);
        return this.values[i];
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    @Deprecated
    public @NonNull java.util.Iterator<@NonNull ElementId> iterator() {
        return new Iterator();
    }

    @Override
    @Deprecated
    public boolean matches(@NonNull ElementId @NonNull [] value) {
        throw new UnsupportedOperationException();
    }

    private boolean matches(@NonNull ElementId @NonNull [] thoseElementIds, @NonNull Object @Nullable [] thoseValues) {
        if (this.elementIds.length != thoseElementIds.length) {
            return false;
        }
        int i = 0;
        while (i < this.elementIds.length) {
            if (this.elementIds[i] != thoseElementIds[i]) {
                return false;
            }
            ++i;
        }
        @NonNull Object[] theseValues = this.values;
        if (theseValues != null != (thoseValues != null)) {
            return false;
        }
        if (theseValues != null) {
            assert (thoseValues != null);
            int length = theseValues.length;
            if (length != thoseValues.length) {
                return false;
            }
            int i2 = 0;
            while (i2 < length) {
                Object thisValue = theseValues[i2];
                Object thatValue = thoseValues[i2];
                if (thisValue != thatValue && !thisValue.equals(thatValue)) {
                    return false;
                }
                ++i2;
            }
        }
        return true;
    }

    @Override
    @Deprecated
    public int size() {
        return this.elementIdSize();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('(');
        int i = 0;
        while (i < this.elementIds.length) {
            if (i > 0) {
                s.append(',');
            }
            s.append(String.valueOf(this.elementIds[i]));
            ++i;
        }
        @NonNull Object[] values2 = this.values;
        if (values2 != null) {
            int i2 = 0;
            while (i2 < values2.length) {
                s.append(',');
                s.append(String.valueOf(values2[i2]));
                ++i2;
            }
        }
        s.append(')');
        return s.toString();
    }

    @Override
    public int valuesSize() {
        @NonNull Object[] values2 = this.values;
        return values2 != null ? values2.length : 0;
    }

    /* synthetic */ BindingsIdImpl(IdManager idManager, ElementId[] elementIdArray, Object[] objectArray, BindingsIdImpl bindingsIdImpl) {
        this(idManager, elementIdArray, objectArray);
    }

    public static class BindingsIdSingletonScope
    extends AbstractSingletonScope<BindingsId, ElementId[]> {
        public @NonNull BindingsId getSingleton(@NonNull IdManager idManager, @NonNull ElementId @NonNull [] elements, @NonNull Object @Nullable [] values) {
            return this.getSingletonFor(new BindingsIdValue(idManager, elements, values));
        }
    }

    private static class BindingsIdValue
    extends SingletonScope.AbstractKeyAndValue<BindingsId> {
        private final @NonNull IdManager idManager;
        private @NonNull ElementId @NonNull [] elements;
        private @NonNull Object @Nullable [] values;

        private BindingsIdValue(@NonNull IdManager idManager, @NonNull ElementId @NonNull [] elements, @NonNull Object @Nullable [] values) {
            super(BindingsIdImpl.computeHashCode(elements, values));
            this.idManager = idManager;
            this.elements = elements;
            this.values = values;
        }

        @Override
        public @NonNull BindingsId createSingleton() {
            return new BindingsIdImpl(this.idManager, this.elements, this.values, null);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that instanceof BindingsIdImpl) {
                BindingsIdImpl singleton = (BindingsIdImpl)that;
                return singleton.matches(this.elements, this.values);
            }
            return false;
        }
    }

    @Deprecated
    protected class Iterator
    implements java.util.Iterator<ElementId> {
        private int index = 0;

        protected Iterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < BindingsIdImpl.this.elementIds.length;
        }

        @Override
        public @NonNull ElementId next() {
            return BindingsIdImpl.this.elementIds[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

