/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.views;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.Localization;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.TapsetLibrary;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.structures.tparsers.TreeTapsetParser;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.views.BrowserView;
import org.eclipse.swt.widgets.Composite;

public abstract class TapsetBrowserView
extends BrowserView {
    private final TreeTapsetParser parser;
    private final Object lock = new Object();
    protected JobChangeAdapter viewUpdater = new JobChangeAdapter(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void aboutToRun(IJobChangeEvent event) {
            Object object = TapsetBrowserView.this.lock;
            synchronized (object) {
                TapsetBrowserView.this.displayLoadingMessage();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done(IJobChangeEvent event) {
            Object object = TapsetBrowserView.this.lock;
            synchronized (object) {
                if (event.getResult().isOK()) {
                    TapsetBrowserView.this.displayContents();
                } else {
                    TapsetBrowserView.this.displayCancelContents();
                }
            }
        }
    };

    public TapsetBrowserView(TreeTapsetParser parser) {
        Assert.isNotNull((Object)((Object)parser));
        this.parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.makeActions();
        Object object = this.lock;
        synchronized (object) {
            IStatus result = this.parser.safelyAddJobChangeListener((IJobChangeListener)this.viewUpdater);
            if (result != null) {
                if (result.isOK()) {
                    this.displayContents();
                } else {
                    this.displayCancelContents();
                }
            } else {
                this.displayLoadingMessage();
            }
        }
    }

    @Override
    protected void displayLoadingMessage() {
        super.displayLoadingMessage();
        this.setRefreshable(false);
    }

    protected abstract void displayContents();

    protected void displayCancelContents() {
        this.displayMessage(Localization.getString("BrowserView.TryRefresh"));
        this.setRefreshable(true);
    }

    @Override
    protected void refresh() {
        TapsetLibrary.runStapParser();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.parser.removeJobChangeListener((IJobChangeListener)this.viewUpdater);
    }
}

