/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.matching;

import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.SourceModule;
import org.eclipse.dltk.internal.core.search.matching.MatchingNodeSet;

public class PossibleMatch
implements org.eclipse.dltk.compiler.env.ISourceModule {
    public static final String NO_SOURCE_FILE_NAME = "NO SOURCE FILE NAME";
    public IResource resource;
    public Openable openable;
    public MatchingNodeSet nodeSet;
    public char[][] compoundName;
    public ModuleDeclaration parsedUnit;
    public SearchDocument document;
    private String source;

    public PossibleMatch(MatchLocator locator, IResource resource, ISourceModule openable, SearchDocument document) {
        this(locator, resource, (Openable)((Object)openable), document);
    }

    public PossibleMatch(MatchLocator locator, IResource resource, Openable openable, SearchDocument document) {
        this.resource = resource;
        this.openable = openable;
        this.document = document;
        this.nodeSet = new MatchingNodeSet();
        char[] qualifiedName = this.getQualifiedName();
        if (qualifiedName != null) {
            this.compoundName = CharOperation.splitOn('.', qualifiedName);
        }
    }

    public void cleanUp() {
        this.source = null;
        if (this.parsedUnit != null) {
            this.parsedUnit = null;
        }
        this.nodeSet = null;
    }

    public boolean equals(Object obj) {
        if (this.compoundName == null) {
            return super.equals(obj);
        }
        if (!(obj instanceof PossibleMatch)) {
            return false;
        }
        return CharOperation.equals(this.compoundName, ((PossibleMatch)obj).compoundName);
    }

    @Override
    public String getSourceContents() {
        if (this.source != null) {
            return this.source;
        }
        this.source = this.document.getContents();
        return this.source;
    }

    @Override
    public char[] getContentsAsCharArray() {
        return this.getSourceContents().toCharArray();
    }

    @Override
    public String getFileName() {
        return this.openable.getElementName();
    }

    public char[] getMainTypeName() {
        return this.compoundName[this.compoundName.length - 1];
    }

    public char[][] getPackageName() {
        int length = this.compoundName.length;
        if (length <= 1) {
            return CharOperation.NO_CHAR_CHAR;
        }
        return CharOperation.subarray(this.compoundName, 0, length - 1);
    }

    private char[] getQualifiedName() {
        String fileName;
        String mainTypeName;
        SourceModule cu;
        String fqName;
        if (this.openable instanceof SourceModule && (fqName = (cu = (SourceModule)this.openable).getType(mainTypeName = (fileName = this.openable.getElementName())).getFullyQualifiedName()) != null) {
            return fqName.toCharArray();
        }
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Code review here...");
        }
        return null;
    }

    public int hashCode() {
        if (this.compoundName == null) {
            return super.hashCode();
        }
        int hashCode = 0;
        int i = 0;
        int length = this.compoundName.length;
        while (i < length) {
            hashCode += CharOperation.hashCode(this.compoundName[i]);
            ++i;
        }
        return hashCode;
    }

    public String toString() {
        return this.openable == null ? "Fake PossibleMatch" : this.openable.toString();
    }

    @Override
    public IModelElement getModelElement() {
        return this.openable;
    }
}

