/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat, Inc. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
import { CodeLens, Range } from 'vscode-languageserver-types';
import { YamlCommands } from '../../commands';
import { yamlDocumentsCache } from '../parser/yaml-documents';
import { getSchemaUrls } from '../utils/schemaUrls';
import { convertErrorToTelemetryMsg } from '../utils/objects';
import { getSchemaTitle } from '../utils/schemaUtils';
export class YamlCodeLens {
    constructor(schemaService, telemetry) {
        this.schemaService = schemaService;
        this.telemetry = telemetry;
    }
    getCodeLens(document) {
        return __awaiter(this, void 0, void 0, function* () {
            const result = [];
            try {
                const yamlDocument = yamlDocumentsCache.getYamlDocument(document);
                let schemaUrls = new Map();
                for (const currentYAMLDoc of yamlDocument.documents) {
                    const schema = yield this.schemaService.getSchemaForResource(document.uri, currentYAMLDoc);
                    if (schema === null || schema === void 0 ? void 0 : schema.schema) {
                        // merge schemas from all docs to avoid duplicates
                        schemaUrls = new Map([...getSchemaUrls(schema === null || schema === void 0 ? void 0 : schema.schema), ...schemaUrls]);
                    }
                }
                for (const urlToSchema of schemaUrls) {
                    const lens = CodeLens.create(Range.create(0, 0, 0, 0));
                    lens.command = {
                        title: getSchemaTitle(urlToSchema[1], urlToSchema[0]),
                        command: YamlCommands.JUMP_TO_SCHEMA,
                        arguments: [urlToSchema[0]],
                    };
                    result.push(lens);
                }
            }
            catch (err) {
                this.telemetry.sendError('yaml.codeLens.error', { error: convertErrorToTelemetryMsg(err) });
            }
            return result;
        });
    }
    resolveCodeLens(param) {
        return param;
    }
}
//# sourceMappingURL=yamlCodeLens.js.map