/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.segment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.datastore.core.serialization.SafeByteBufferFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.segmentstore.core.IContentSegment;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.INamedSegment;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public class TmfXmlPatternSegment
implements INamedSegment,
IContentSegment {
    private static final long serialVersionUID = 3556323761465412078L;
    private static final byte TYPE_NULL = -1;
    private static final byte TYPE_INTEGER = 0;
    private static final byte TYPE_STRING = 1;
    private static final byte TYPE_LONG = 2;
    private final long fStart;
    private final long fEnd;
    private final @NonNull String fSegmentName;
    private transient @NonNull Map<@NonNull String, @NonNull Object> fContent;
    public static final @NonNull IHTIntervalReader<@NonNull ISegment> READER = buffer -> {
        long start = buffer.getLong();
        long end = buffer.getLong();
        buffer.getInt();
        String segmentName = buffer.getString();
        int contentSize = buffer.getInt();
        HashMap<@NonNull String, @NonNull Object> content = new HashMap<String, Object>();
        int i = 0;
        while (i < contentSize) {
            Object value;
            String name = buffer.getString().intern();
            Byte type = buffer.get();
            switch (type) {
                case 0: {
                    value = buffer.getInt();
                    break;
                }
                case 2: {
                    value = buffer.getLong();
                    break;
                }
                case 1: {
                    value = buffer.getString().intern();
                    break;
                }
                default: {
                    value = null;
                    Activator.logError("Read segment failed : Invalid data, value will be ignored");
                }
            }
            if (value != null) {
                content.put(name, value);
            }
            ++i;
        }
        return new TmfXmlPatternSegment(start, end, segmentName, content);
    };

    public TmfXmlPatternSegment(long start, long end, String segmentName, @NonNull Map<@NonNull String, @NonNull Object> fields) {
        this.fStart = start;
        this.fEnd = end;
        this.fSegmentName = String.valueOf(segmentName);
        this.fContent = Collections.unmodifiableMap(fields);
    }

    public Map<@NonNull String, @NonNull Object> getContent() {
        return this.fContent;
    }

    public String getName() {
        return this.fSegmentName;
    }

    public int compareTo(@NonNull ISegment o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        return this.toString().compareTo(o.toString());
    }

    public long getStart() {
        return this.fStart;
    }

    public long getEnd() {
        return this.fEnd;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", [fTimestampStart=" + this.getStart() + ", fTimestampEnd=" + this.getEnd() + ", duration= " + this.getLength() + ", fName=" + this.getName() + ", fContent=" + this.getContent() + "]";
    }

    public void writeSegment(@NonNull ISafeByteBufferWriter buffer) {
        buffer.putLong(this.fStart);
        buffer.putLong(this.fEnd);
        buffer.putInt(0);
        buffer.putString(this.fSegmentName);
        buffer.putInt(this.fContent.size());
        for (Map.Entry<String, Object> entry : this.fContent.entrySet()) {
            buffer.putString(entry.getKey());
            Object value = entry.getValue();
            byte type = TmfXmlPatternSegment.getByteFromObject(value);
            buffer.put(type);
            switch (type) {
                case -1: {
                    break;
                }
                case 0: {
                    buffer.putInt(((Integer)value).intValue());
                    break;
                }
                case 2: {
                    buffer.putLong(((Long)value).longValue());
                    break;
                }
                case 1: {
                    String string = (String)value;
                    buffer.putString(Objects.requireNonNull(string));
                    break;
                }
                default: {
                    Activator.logError("Write object failed : Invalid data");
                }
            }
        }
    }

    public int getSizeOnDisk() {
        int size = 20 + SafeByteBufferFactory.getStringSizeInBuffer((String)this.fSegmentName) + 4;
        for (Map.Entry<String, Object> entry : this.fContent.entrySet()) {
            size += SafeByteBufferFactory.getStringSizeInBuffer((String)entry.getKey());
            Object value = entry.getValue();
            byte type = TmfXmlPatternSegment.getByteFromObject(value);
            ++size;
            switch (type) {
                case -1: {
                    break;
                }
                case 0: {
                    size += 4;
                    break;
                }
                case 2: {
                    size += 8;
                    break;
                }
                case 1: {
                    String string = (String)value;
                    size += SafeByteBufferFactory.getStringSizeInBuffer((String)Objects.requireNonNull(string));
                    break;
                }
                default: {
                    Activator.logError("get segment size on disk failed : Invalid data");
                }
            }
        }
        return size;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.fContent.size());
        for (Map.Entry<String, Object> entry : this.fContent.entrySet()) {
            out.writeInt(entry.getKey().length());
            out.writeBytes(entry.getKey());
            Object value = entry.getValue();
            byte type = TmfXmlPatternSegment.getByteFromObject(value);
            out.writeByte(type);
            switch (type) {
                case -1: {
                    break;
                }
                case 0: {
                    out.writeInt((Integer)value);
                    break;
                }
                case 2: {
                    out.writeLong((Long)value);
                    break;
                }
                case 1: {
                    String string = (String)value;
                    out.writeInt(string.length());
                    out.writeBytes(string);
                    break;
                }
                default: {
                    throw new IOException("Write object failed : Invalid data");
                }
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int contentSize = in.readInt();
        HashMap<@NonNull String, @NonNull Object> content = new HashMap<String, Object>();
        int i = 0;
        while (i < contentSize) {
            int length = in.readInt();
            byte[] bytes = new byte[length];
            in.read(bytes, 0, length);
            String name = new String(bytes).intern();
            Byte type = in.readByte();
            content.put(name, switch (type) {
                case -1 -> TmfStateValue.nullValue();
                case 0 -> TmfStateValue.newValueInt((int)in.readInt());
                case 2 -> TmfStateValue.newValueLong((long)in.readLong());
                case 1 -> {
                    length = in.readInt();
                    bytes = new byte[length];
                    in.read(bytes, 0, length);
                    yield TmfStateValue.newValueString((String)new String(bytes).intern());
                }
                default -> throw new IOException("Read object failed : Invalid data");
            });
            ++i;
        }
        this.fContent = content;
    }

    private static byte getByteFromObject(Object value) {
        if (value == null) {
            return -1;
        }
        if (value instanceof Integer) {
            return 0;
        }
        if (value instanceof Long) {
            return 2;
        }
        if (value instanceof String) {
            return 1;
        }
        throw new IllegalStateException("Data type " + value.getClass() + " not supported");
    }
}

