/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.tcf.te.ui.utils.StringMatcher;

public class TablePatternFilter
extends ViewerFilter {
    private static final String ALL = "*";
    protected StringMatcher matcher = null;
    protected ILabelProvider labelProvider;
    protected List<PropertyChangeListener> listeners;
    protected String pattern;

    public TablePatternFilter(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        this.listeners = Collections.synchronizedList(new ArrayList());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.add(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.remove(l);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        return this.match(this.labelProvider.getText(element));
    }

    public void setPattern(String newPattern) {
        StringMatcher old = this.matcher;
        this.pattern = newPattern;
        if (newPattern == null || newPattern.trim().length() == 0) {
            this.matcher = null;
        } else {
            String patternString = ALL + newPattern + ALL;
            this.matcher = new StringMatcher(patternString, true, false);
        }
        this.firePatternChangedEvent(old, this.matcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void firePatternChangedEvent(StringMatcher oldMatcher, StringMatcher newMatcher) {
        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "pattern", oldMatcher, newMatcher);
        List<PropertyChangeListener> list = this.listeners;
        synchronized (list) {
            for (PropertyChangeListener listener : this.listeners) {
                listener.propertyChange(event);
            }
        }
    }

    public String getFilterText() {
        return this.pattern;
    }

    public boolean match(String input) {
        if (input == null) {
            return false;
        }
        return this.matcher == null || this.matcher.match(input);
    }
}

