/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.business.api.helper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class TreeUIHelper {
    private TreeUIHelper() {
    }

    public static void addLineToTree(List<String> expected, String str) {
        expected.add(str);
    }

    public static String toContentHTMl(Tree tree) {
        return TreeUIHelper.toHTML(TreeUIHelper.toTreeDescriptor(tree));
    }

    public static List<String> toTreeDescriptor(Tree tree) {
        ArrayList<String> expected = new ArrayList<String>();
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            expected.add(treeItem.getText());
            if (treeItem.getData() instanceof DTreeItem) {
                for (String str : TreeUIHelper.addLineToDescriptor((EList<DTreeItem>)((DTreeItem)treeItem.getData()).getOwnedTreeItems())) {
                    expected.add(str);
                }
            }
            ++n2;
        }
        return expected;
    }

    private static List<String> addLineToDescriptor(EList<DTreeItem> treeItemSpecs) {
        ArrayList<String> expected = new ArrayList<String>();
        for (DTreeItem dTreeItem : treeItemSpecs) {
            expected.add(dTreeItem.getName());
            if (dTreeItem.getOwnedTreeItems().isEmpty()) continue;
            for (String str : TreeUIHelper.addLineToDescriptor((EList<DTreeItem>)dTreeItem.getOwnedTreeItems())) {
                expected.add(str);
            }
        }
        return expected;
    }

    public static String toHTML(List<String> descriptor) {
        StringBuffer result = new StringBuffer();
        result.append("<table>\n");
        for (String line : descriptor) {
            result.append("<tr>");
            result.append("<td>");
            result.append(line);
            result.append("</td>");
            result.append("</tr>\n");
        }
        result.append("</table>");
        return result.toString();
    }
}

